/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOptions;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class TicketFieldDefinitionCategoryId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager {
    public TicketFieldDefinitionCategoryId() {
        super(Tickets.FIELD_CATEGORY_ID, CategoryManager.getInstance());
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/kategorie_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/kategorie_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/kategorie_16@3x.png");
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                if (!HDUsersAndGroups.isSupporter(currentUserAccount)) {
                    MandatoryFieldsManager mandatoryFieldsManager = (MandatoryFieldsManager)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
                    List<MandatoryFieldVO> mandatoryFieldSettings = mandatoryFieldsManager.getMandatoryFieldSettings();
                    MandatoryFieldVO mandatoryField = mandatoryFieldSettings.stream().filter(f -> ((Object)((Object)f.getTicketField())).equals((Object)Tickets.FIELD_CATEGORY_ID)).findFirst().orElse(null);
                    return mandatoryField != null && mandatoryField.getUserMandatorySetting() != MandatoryFieldVO.MandatoryType.HIDDEN;
                }
                if (tickets != null) {
                    ActionVO action = (ActionVO)ActionManager.getInstance().get(-26);
                    for (TicketVO ticket : tickets) {
                        if (TicketManager.getTicketActionChecker().checkAction(action, ticket, TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket)) == null) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                Integer categoryId;
                SelectOption selectOption;
                String valueString;
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value) && !StringFunctions.isEmpty((String)(valueString = (selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class)).getValue())) && (categoryId = Integer.valueOf(selectOption.getValue())) != null) {
                    if (categoryId == 0) {
                        ticketData.put(Tickets.FIELD_CATEGORY_ID, null);
                    } else {
                        ticketData.put(Tickets.FIELD_CATEGORY_ID, categoryId);
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                CategoryVO categoryVO;
                Integer categoryId = null;
                if (ticket != null) {
                    categoryId = ticket.getCategoryID();
                }
                SelectOption option = new SelectOption(null, "");
                if (categoryId != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryId)) != null) {
                    option = new SelectOption(String.valueOf(categoryId), categoryVO.getDisplayValue(), String.valueOf(categoryVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionCategoryId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionCategoryId.this.getDisplayName();
            }

            @Override
            public SelectOptions getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                boolean supporter = HDUsersAndGroups.isSupporter(currentUserAccount);
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator<CategoryVO> comparator = new Comparator<CategoryVO>(){

                    @Override
                    public int compare(CategoryVO o1, CategoryVO o2) {
                        return o1.getPath().compareToIgnoreCase(o2.getPath());
                    }
                };
                searchTerm = searchTerm != null ? searchTerm : "";
                CategoryManager manager = CategoryManager.getInstance();
                List categories = manager.getAll(true);
                categories.sort(comparator);
                String hiddenPath = null;
                for (CategoryVO categoryVO : categories) {
                    if (!supporter) {
                        if (categoryVO.isHidden()) {
                            if (hiddenPath != null && categoryVO.getPath().startsWith(hiddenPath)) continue;
                            hiddenPath = categoryVO.getPath();
                            continue;
                        }
                        if (hiddenPath != null) {
                            if (categoryVO.getPath().startsWith(hiddenPath)) {
                                continue;
                            }
                        } else {
                            hiddenPath = null;
                        }
                    }
                    if (!categoryVO.getPath().toLowerCase().contains(searchTerm.toLowerCase())) continue;
                    int level = this.getLevel(manager, categoryVO, 0);
                    if (!StringFunctions.isEmpty((String)searchTerm) && level > 0) {
                        this.addParents(manager, categoryVO, list, level);
                    }
                    list.add(new SelectOption(String.valueOf(categoryVO.getId()), categoryVO.getDisplayValue(), String.valueOf(categoryVO.getId()), level));
                }
                if (list.size() < currentSize) {
                    return new SelectOptions(new ArrayList<SelectOption>(), 0);
                }
                List<SelectOption> subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptions(subList, list.size());
            }

            private void addParents(CategoryManager manager, CategoryVO categoryVO, ArrayList<SelectOption> list, int level) {
                Integer parentId = categoryVO.getParentCategoryID();
                if (parentId != null && parentId > 0) {
                    CategoryVO parent = (CategoryVO)manager.get(parentId);
                    this.addParents(manager, parent, list, level - 1);
                    SelectOption parentOption = new SelectOption(String.valueOf(parent.getId()), parent.getDisplayValue(), String.valueOf(parent.getId()), level - 1);
                    if (!list.stream().anyMatch(opt -> opt.getValue().equals(parentOption.getValue()))) {
                        list.add(parentOption);
                    }
                }
            }

            private int getLevel(CategoryManager manager, CategoryVO categoryVO, int level) {
                Integer parent = categoryVO.getParentCategoryID();
                if (parent != null && parent > 0) {
                    int nextLevel = this.getLevel(manager, (CategoryVO)manager.get(parent), level + 1);
                    return nextLevel;
                }
                return level;
            }
        };
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        String path;
        CategoryVO categoryVO;
        Integer categoryID = ticket.getCategoryID();
        if (categoryID != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryID)) != null && !StringFunctions.isEmpty((String)(path = categoryVO.getPath()))) {
            path = path.replace("\\", " \\ ");
            return path;
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(Tickets.FIELD_CATEGORY_ID.getKey(), sortGroupKey -> {
            CategoryVO parent;
            if (StringFunctions.isEmpty((String)sortGroupKey)) {
                return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]), false, null);
            }
            CategoryVO cat = (CategoryVO)CategoryManager.getInstance().get(Integer.parseInt(sortGroupKey));
            Object displayName = cat.getDisplayValue();
            Integer parentCatID = cat.getParentCategoryID();
            while (parentCatID != null && parentCatID > 0 && (parent = (CategoryVO)CategoryManager.getInstance().get(parentCatID)) != null) {
                displayName = parent.getDisplayValue() + " \\ " + (String)displayName;
                parentCatID = parent.getParentCategoryID();
            }
            String iconKey = sortGroupKey;
            return new SortGroup((String)displayName, true, iconKey);
        });
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator nullsFirst = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

