/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByFirstLetterSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Comparator;

@InternalApi
public abstract class AbstractTicketFieldDefinitionForTicketOwner
extends TicketFieldDefinition {
    private UserField<?> fieldInstance;

    public AbstractTicketFieldDefinitionForTicketOwner(UserField<?> fieldInstance) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET_OWNER, "ticketowner." + fieldInstance.getKey(), true, false);
        this.fieldInstance = fieldInstance;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        GUID ownerID = ticket.getOwnerID();
        if (ownerID == null) {
            return null;
        }
        UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
        if (userAccount != null) {
            return (String)userAccount.getValue(this.fieldInstance);
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return UsersAndGroups.getFieldDisplayName((String)this.fieldInstance.getKey());
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByFirstLetterSortGroupInformation(this);
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(this.getDisplayValue((TicketVO)a), this.getDisplayValue((TicketVO)b));
    }
}

