/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.CustomFieldDefinitionEditInformations;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldCustomField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectOptions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@InternalApi
public abstract class AbstractTicketFieldDefinitionForCustomFields
extends AbstractTicketFieldDefinitionWithField<String> {
    private TicketFieldCustomField fieldInstance;

    public AbstractTicketFieldDefinitionForCustomFields(TicketFieldCustomField fieldInstance) {
        super(fieldInstance, true, false);
        this.fieldInstance = fieldInstance;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        String value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Comparator nullsFirst = Comparator.nullsFirst(comp);
        return (a, b) -> nullsFirst.compare(a.getForKey(this.getKey()), b.getForKey(this.getKey()));
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        FreifeldSetting editInformation = CustomFieldDefinitionEditInformations.getEditInformation(UserManager.getInstance().getCurrentUserAccount(), this.fieldInstance);
        if (editInformation == null) {
            return this.getTextInputEditDefinition(this.fieldInstance);
        }
        if (editInformation.getFreifeldType() == FreifeldType.Multi) {
            return this.getSelectEditDefinition(this.fieldInstance, true, false);
        }
        if (editInformation.getFreifeldType() == FreifeldType.Editable) {
            return this.getSelectEditDefinition(this.fieldInstance, false, true);
        }
        return this.getSelectEditDefinition(this.fieldInstance, false, false);
    }

    protected FieldEditDefinition getTextInputEditDefinition(final TicketFieldCustomField field) {
        return new FieldEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                if (currentUserAccount == null) {
                    return false;
                }
                if (!HDUsersAndGroups.isSupporter(currentUserAccount)) {
                    MandatoryFieldsManager mandatoryFieldsManager = (MandatoryFieldsManager)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
                    List<MandatoryFieldVO> mandatoryFieldSettings = mandatoryFieldsManager.getMandatoryFieldSettings();
                    MandatoryFieldVO mandatoryField = mandatoryFieldSettings.stream().filter(f -> ((Object)((Object)f.getTicketField())).equals((Object)field)).findFirst().orElse(null);
                    return mandatoryField != null && mandatoryField.getUserMandatorySetting() != MandatoryFieldVO.MandatoryType.HIDDEN;
                }
                return super.isAvailable(tickets);
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String custom = values.get(this.getFieldKey());
                if (custom != null) {
                    ticketData.put(field, custom);
                } else {
                    ticketData.put(field, null);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (ticket != null) {
                    String custom = ticket.getValue(field);
                    values.put(this.getFieldKey(), String.valueOf(custom));
                } else {
                    values.put(this.getFieldKey(), "");
                }
            }

            @Override
            public String getFieldKey() {
                return AbstractTicketFieldDefinitionForCustomFields.this.getKey();
            }

            @Override
            public String getDisplayType() {
                return TEXTINPUT;
            }

            @Override
            public String getDisplayName() {
                return AbstractTicketFieldDefinitionForCustomFields.this.getDisplayName();
            }
        };
    }

    protected SelectEditDefinition getSelectEditDefinition(final TicketFieldCustomField field, final boolean multi, final boolean customValues) {
        return new SelectEditDefinition(){

            @Override
            public boolean isAvailable(List<TicketVO> tickets) {
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                if (currentUserAccount == null) {
                    return false;
                }
                if (!HDUsersAndGroups.isSupporter(currentUserAccount)) {
                    MandatoryFieldsManager mandatoryFieldsManager = (MandatoryFieldsManager)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
                    List<MandatoryFieldVO> mandatoryFieldSettings = mandatoryFieldsManager.getMandatoryFieldSettings();
                    MandatoryFieldVO mandatoryField = mandatoryFieldSettings.stream().filter(f -> ((Object)((Object)f.getTicketField())).equals((Object)field)).findFirst().orElse(null);
                    return mandatoryField != null && mandatoryField.getUserMandatorySetting() != MandatoryFieldVO.MandatoryType.HIDDEN;
                }
                return super.isAvailable(tickets);
            }

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    if (multi) {
                        ticketData.put(field, value);
                    } else {
                        SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                        String valueString = selectOption.getValue();
                        if (!StringFunctions.isEmpty((String)valueString)) {
                            ticketData.put(field, valueString);
                        } else {
                            ticketData.put(field, null);
                        }
                    }
                } else {
                    ticketData.put(field, null);
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                if (multi) {
                    if (ticket != null) {
                        String custom = ticket.getValue(field);
                        values.put(this.getFieldKey(), String.valueOf(custom));
                    } else {
                        values.put(this.getFieldKey(), "");
                    }
                } else {
                    String custom = null;
                    SelectOption option = new SelectOption("", "");
                    if (ticket != null && (custom = ticket.getValue(field)) != null) {
                        option = new SelectOption(custom, custom);
                    }
                    values.put(this.getFieldKey(), new Json().toJson((Object)option));
                }
            }

            @Override
            public String getFieldKey() {
                return AbstractTicketFieldDefinitionForCustomFields.this.getKey();
            }

            @Override
            public String getDisplayType() {
                if (multi) {
                    return SELECT_MULTI;
                }
                if (customValues) {
                    return SELECT_EDITABLE;
                }
                return SELECT;
            }

            @Override
            public String getDisplayName() {
                return AbstractTicketFieldDefinitionForCustomFields.this.getDisplayName();
            }

            @Override
            public SelectOptions getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                SelectOptions data = CustomFieldDefinitionEditInformations.getData(UserManager.getInstance().getCurrentUserAccount(), field, true);
                if (data != null) {
                    List<SelectOption> allOptions = data.getOptions();
                    for (SelectOption option : allOptions) {
                        String label = option.getLabel();
                        if (label == null) {
                            label = "";
                        }
                        if (!label.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                        list.add(option);
                    }
                }
                if (list.size() < currentSize) {
                    return new SelectOptions(new ArrayList<SelectOption>(), 0);
                }
                List<SelectOption> subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptions(subList, list.size());
            }
        };
    }
}

