/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.extension;

import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import javax.annotation.Nonnull;

public class ExtensionUtils {
    public static void escalateTicketSilently(OperationChangedTicket ticket, @Nonnull UserGroupInfo targetResource, long lastChanged) {
        GUID oldResID = ticket.getOldTicket().get().getResourceID();
        String description = ExtensionUtils.getResourceDisplayName(oldResID) + " -> " + targetResource.getDisplayName();
        MutableReaStepData reaStepData = new MutableReaStepData();
        reaStepData.put(ReaStepVO.FIELD_DESC, description);
        reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(lastChanged));
        ticket.getNewTicketData().put(Tickets.FIELD_RESOURCE_GUID, targetResource.getID());
        ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, lastChanged);
        ticket.addReaStep(8, reaStepData, null);
    }

    public static String getResourceDisplayName(GUID resID) {
        UserGroupInfo res = UserGroupManager.getInstance().getGroup(resID);
        return res == null ? "" : res.getDisplayName();
    }
}

