/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.servlets.rpc;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.servlets.rpc.PacketHandler;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.helpdesk.shared.rpc.PrimitiveWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;

public abstract class ProxyPacketHandler
implements PacketHandler {
    private Map<String, Method> map = Collections.synchronizedMap(new HashMap());

    public abstract Class<?> getRemoteInterface();

    @Override
    public void handle(HttpServletRequest request, Reader jsonData, Writer output) throws Throwable {
        String restFullCmd = request.getPathInfo();
        if (restFullCmd == null) {
            throw new IOException("No restful method name. You use an old version of the client.");
        }
        String cmd = "/" + this.getCommand() + "/";
        int idx = restFullCmd.indexOf(cmd);
        String methodName = restFullCmd.substring(idx + cmd.length());
        Method method = this.getMap().get(methodName);
        if (method == null) {
            throw new IllegalArgumentException(new NoSuchMethodException(methodName));
        }
        Type[] paramTypes = method.getGenericParameterTypes();
        Object[] args = paramTypes.length > 0 ? JSON.fromJson(jsonData, paramTypes) : null;
        List<LargeContent> attachments = LargeContent.getLargeContent(args);
        if (attachments.size() > 0) {
            for (int i = 0; i < attachments.size(); ++i) {
                LargeContent att = attachments.get(i);
                String name = "attachment" + i;
                final Part part = request.getPart(name);
                att.setStreamProvider(new LargeContent.InputStreamProvider(){

                    @Override
                    public InputStream getStream() {
                        try {
                            return part.getInputStream();
                        }
                        catch (IOException e) {
                            HDLogger.error(e);
                            return null;
                        }
                    }

                    @Override
                    public long getSize() {
                        return part.getSize();
                    }
                });
            }
        }
        try {
            Object result = method.invoke((Object)this, args);
            result = this.wrapIfNecessary(result);
            JSON.toJson(result, (Appendable)output);
        }
        catch (InvocationTargetException ex) {
            HDLogger.error(ex);
            throw ex.getCause();
        }
        catch (Exception ex) {
            HDLogger.error(ex);
            throw ex;
        }
    }

    private Object wrapIfNecessary(Object result) {
        if (result == null) {
            return result;
        }
        Class<?> clazz = result.getClass();
        if (Number.class.isAssignableFrom(clazz) || Character.class == clazz) {
            result = new PrimitiveWrapper(result);
        }
        return result;
    }

    @Override
    public boolean encryptionRequired() {
        return true;
    }

    @Override
    public final String getCommand() {
        return this.getRemoteInterface().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Method> getMap() {
        if (this.map.isEmpty()) {
            Map<String, Method> map = this.map;
            synchronized (map) {
                if (this.map.isEmpty()) {
                    for (Method m : this.getRemoteInterface().getDeclaredMethods()) {
                        this.map.put(m.getName(), m);
                    }
                }
            }
        }
        return this.map;
    }
}

