/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.data;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.general.Sorting;
import com.inet.helpdesk.core.model.ticket.Action;
import com.inet.helpdesk.core.model.ticket.ReaStep;
import com.inet.helpdesk.core.model.ticket.SenderInformation;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.model.ticket.TicketPermissionsInfo;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public interface TicketDataConnector {
    public static final int EMPTY_TICKET = -1;

    public ArrayList<Ticket> getTicketsSync(ContextType var1, GroupingParameter var2, Sorting var3, int var4, Map<Integer, Integer> var5, boolean var6) throws ServerDataException;

    public GroupVersionID getGroupVersion(GroupingParameter var1, boolean var2, boolean var3, int var4) throws ServerDataException;

    public ArrayList<Ticket> getDispatcherTicketsSync(ContextType var1, GroupingParameter var2, Sorting var3, int var4, Map<Integer, Integer> var5, int var6) throws ServerDataException;

    public int executeSearch(int var1, int var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, UserAccount var10, int var11, int var12, Date var13, Date var14, int[] var15) throws ServerDataException;

    public SearchResultInfo getSearchedTicketsSync(ContextType var1, UserAccount var2, int var3, int[] var4, int var5, Sorting var6, Map<Integer, Integer> var7, int var8, List<Integer> var9) throws ServerDataException;

    public List<ReaStep> getReaSteps(ContextType var1, int var2) throws ServerDataException;

    public void logIntoTicket(int var1, int var2) throws ServerDataException;

    public void logOutFromTicket(int var1, int ... var2) throws ServerDataException;

    public ArrayList<UserAccount> getUsersInTicket(int var1);

    public Ticket getTicket(ContextType var1, int var2, TicketText var3) throws ServerDataException;

    public void changeTicketStatus(int var1, int var2, int var3, MailNotification var4) throws ServerDataException;

    public void escalateTicket(int var1, int var2) throws ServerDataException;

    public String getReaStepContent(int var1) throws ServerDataException;

    public TicketPermissionsInfo getTicketPermissionsInfo(Ticket var1, int var2, ContextType var3) throws ServerDataException;

    public ArrayList<Action> getTicketActions(Ticket var1, boolean var2) throws ServerDataException;

    public int createStepByApplyingAction(ContextType var1, int var2, Action var3, int var4, Date var5, String var6, boolean var7, String var8, BiConsumer<Ticket, Integer> var9) throws ServerDataException;

    public void applyAnswer(int var1, String var2, String var3, String var4, String var5, String var6, boolean var7, int var8, int var9, ExtensionArguments var10) throws ServerDataException;

    public ArrayList<User> getReceivers(Ticket var1, RECEIVERTYP var2, boolean var3) throws ServerDataException;

    public SenderInformation getSenderInformation(Ticket var1) throws ServerDataException;

    public String getAnswerSignature(Ticket var1, boolean var2, Locale var3) throws ServerDataException;

    @Deprecated
    public Ticket createNewTicket(ContextType var1, UserAccount var2, int var3, HashMap<String, String> var4, ArrayList<String> var5, boolean var6, @Nullable ExtensionArguments var7) throws ServerDataException;

    public Ticket createNewTicket(ContextType var1, UserAccount var2, UserAccount var3, HashMap<String, String> var4, ArrayList<String> var5, boolean var6, @Nullable ExtensionArguments var7) throws ServerDataException;

    public void editTicket(int var1, HashMap<String, String> var2, int var3, ArrayList<String> var4, boolean var5) throws ServerDataException;

    public void updateReaStepContent(int var1, int var2, String var3) throws ServerDataException;

    public static interface AttachmentsProvider {
        public String[][] createAttachmentsForStep(int var1) throws ServerDataException;
    }

    public static class SearchResultInfo {
        private final int resultCount;
        private final ArrayList<Ticket> tickets;

        public SearchResultInfo(ArrayList<Ticket> tickets, int resultCount) {
            this.tickets = tickets;
            this.resultCount = resultCount;
        }

        public int getResultCount() {
            return this.resultCount;
        }

        public ArrayList<Ticket> getTickets() {
            return this.tickets;
        }
    }

    public static enum RECEIVERTYP {
        TO,
        CC,
        ALL;

    }

    public static class GroupVersionID {
        private final int version;
        private final int count;

        public GroupVersionID(int version, int count) {
            this.version = version;
            this.count = count;
        }

        public int getVersion() {
            return this.version;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class GroupingParameter {
        private int firstGroupType;
        private String firstGroupValue;
        private int secondGroupType;
        private String secondGroupValue;

        public GroupingParameter(int firstGroupType, String firstGroupValue, int secondGroupType, String secondGroupValue) {
            this.firstGroupType = firstGroupType;
            this.firstGroupValue = firstGroupValue;
            this.secondGroupType = secondGroupType;
            this.secondGroupValue = secondGroupValue;
        }

        public int getFirstGroupType() {
            return this.firstGroupType;
        }

        public String getFirstGroupValue() {
            return this.firstGroupValue;
        }

        public int getSecondGroupType() {
            return this.secondGroupType;
        }

        public String getSecondGroupValue() {
            return this.secondGroupValue;
        }
    }

    public static enum TicketText {
        NONE,
        INQUIRY,
        LASTSTEP;

    }

    public static enum MailNotification {
        NEVER,
        SERVERSETTING,
        ALWAYS;

    }

    public static enum BooleanFlagOption {
        SET,
        DONT_TOUCH,
        RESET;

    }
}

