/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.pages;

import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigPage;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.pages.TicketConfigPage;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ServerConfigPage
implements ConfigPage {
    public String getPageKey() {
        return "configuration.server";
    }

    public String getParentKey() {
        return null;
    }

    public Integer getOptionalPriority() {
        return 5000;
    }

    public String getShortDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.server", new Object[0]);
    }

    public String getFullDisplayName() {
        return HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.server.fulldisplayname", new Object[0]);
    }

    public String getDescription() {
        return null;
    }

    public URL getIconURL() {
        return this.getClass().getResource("/com/inet/helpdesk/config/pages/server_48.png");
    }

    public boolean isAccessAllowed() {
        return SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
    }

    public List<ConfigPage> getChildren(ConfigStructure configStructure) {
        ArrayList<ConfigPage> children = new ArrayList<ConfigPage>();
        List groups = configStructure.getGroups();
        for (final ConfigGroup group : groups) {
            if (TicketConfigPage.INCLUDED_GROUPS.containsKey(group.getKey())) continue;
            children.add(new ConfigPage(){

                public String getPageKey() {
                    return "configuration.server." + group.getKey();
                }

                public String getParentKey() {
                    return "configuration.server";
                }

                public String getShortDisplayName() {
                    return group.getDisplayName();
                }

                public String getFullDisplayName() {
                    return group.getDisplayName() + " - " + HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.server.fulldisplayname", new Object[0]);
                }

                public String getDescription() {
                    return null;
                }

                public String getHelpKey() {
                    return group.getKey();
                }

                public URL getIconURL() {
                    return this.getClass().getResource("/com/inet/helpdesk/config/pages/server_" + group.getKey().replace('.', '_') + "_48.png");
                }

                public boolean isAccessAllowed() {
                    return SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
                }

                public Set<String> getIncludedConfigGroups(ConfigStructure configStructure) {
                    return new HashSet<String>(Arrays.asList(group.getKey()));
                }
            });
        }
        return children;
    }

    public Set<String> getIncludedConfigGroups(ConfigStructure configStructure) {
        return configStructure.getGroups().stream().filter(group -> !TicketConfigPage.INCLUDED_GROUPS.containsKey(group.getKey())).map(LocalizedKey::getKey).collect(Collectors.toSet());
    }
}

