/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.Freifeld;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldSettingList;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.MailResourceToAbsenderAndAliasMap;
import com.inet.helpdesk.config.OutgoingMailHeaderMap;
import com.inet.helpdesk.config.TicketIdDefList;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.utils.SecurityUtils;
import com.inet.lib.util.Encryption;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.plugin.ServerPluginManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.annotation.SuppressFBWarnings;

public class ServerPropertiesConverter {
    private static final List<String> OUTDATED_KEY_PREFIXES = new ArrayList<String>(){
        {
            this.add("jtapi.minvalid");
            this.add("kostenstelle");
            this.add("ldap.multicolumns");
            this.add("ldap.queryattribut");
            this.add("ldap.replace");
            this.add("mail.dispatcher");
            this.add("mail.htmlcrit");
            this.add("mail.localh");
            this.add("mail.plainte");
            this.add("mail.second");
            this.add("nichteinlesen");
            this.add("plaintextforced");
            this.add("searchindex.directory");
            this.add("autoprocesstimeout");
            this.add("dataimportstrict");
            this.add("deadlinemails");
            this.add("emailheader");
            this.add("hostalias");
            this.add("hostdomain");
            this.add("ldap.numeric");
            this.add("ldap.stricterror");
            this.add("mail.unknowndispatch");
            this.add("maxlistrows");
            this.add("pleasecontact");
            this.add("ldap.notemptycolumns");
            this.add("dbs/");
            this.add("BackendTyp");
            this.add("BunFeld5");
            this.add("CompanyName");
            this.add("Port2");
            this.add("SerialNumber");
            this.add("generalLogStream");
            this.add("host");
            this.add("jdbc.drivers");
            this.add("mgr.port");
            this.add("port");
            this.add("statusMailEingang");
            this.add("mail.imap.fetchsize");
            this.add("device.");
        }
    };
    private static final String TICKET_ID_DEF_KEY = "TicketIDdef";
    private static final Map<String, String> FREIFELD_NAMEN = new HashMap<String, String>(){
        {
            this.put("AUFTRAGFREI1", Freifeld.auftrag1.name());
            this.put("AUFTRAGFREI2", Freifeld.auftrag2.name());
            this.put("AUFTRAGFREI3", Freifeld.auftrag3.name());
            this.put("AUFTRAGFREI4", Freifeld.auftrag4.name());
            this.put("AUFTRAGFREI5", Freifeld.auftrag5.name());
            this.put("KENNUNG", Freifeld.kennung.name());
            this.put("BENUTZERFREI1", Freifeld.benutzer1.name());
            this.put("BENUTZERFREI2", Freifeld.benutzer2.name());
            this.put("BENUTZERFREI3", Freifeld.benutzer3.name());
            this.put("BENUTZERFREI4", Freifeld.benutzer4.name());
            this.put("BENUTZERFREI5", Freifeld.benutzer5.name());
            this.put("GERFELD1", Freifeld.geraet1.name());
            this.put("GERFELD2", Freifeld.geraet2.name());
            this.put("GERFELD3", Freifeld.geraet3.name());
            this.put("GERFELD4", Freifeld.geraet4.name());
            this.put("GERFELD5", Freifeld.geraet5.name());
            this.put("GERFELD6", Freifeld.geraet6.name());
            this.put("GERFELD7", Freifeld.geraet7.name());
            this.put("GERFELD8", Freifeld.geraet8.name());
            this.put("GERFELD9", Freifeld.geraet9.name());
            this.put("ABTEILUNG", Freifeld.abteilung.name());
        }
    };
    static InputStreamForFile get = new InputStreamForFile(){

        @Override
        @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="internal api")
        public InputStream streamForRelativeFileName(String name) throws FileNotFoundException {
            return new FileInputStream(name);
        }
    };

    public static void convertEscalationWarningStatusIfNeeded() {
        try {
            Configuration config = ConfigurationManager.getInstance().getCurrent();
            Integer escaWarningStatus = Integer.valueOf(config.get("escalationWarningStatus", "-1"));
            if (escaWarningStatus > -1) {
                ServerDataConnector sdc = (ServerDataConnector)ServerPluginManager.getInstance().getSingleInstance(ServerDataConnector.class);
                sdc.getAllActions().stream().filter(a -> a.getStateId() == escaWarningStatus.intValue()).findFirst().ifPresent(a -> config.put(HDConfigKeys.ESCALATION_WARNING_ACTION.getKey(), "" + a.getId()));
            }
            config.put("escalationWarningStatus", null);
        }
        catch (Exception exc) {
            HDLogger.error(exc);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="internal api")
    public static Properties toNewFormat(Properties old) {
        Properties props = new Properties();
        HashMap<String, EmailAccount> accountMap = new HashMap<String, EmailAccount>();
        HashMap<String, DatabaseConfigInfo> dbConfigInfoMap = new HashMap<String, DatabaseConfigInfo>();
        LdapConnectionInfoMap ldapConfigInfoMap = new LdapConnectionInfoMap();
        OutgoingMailHeaderMap mailHeaders = new OutgoingMailHeaderMap();
        DeviceImportConfigInfoMap deviceImportConfigInfoMap = new DeviceImportConfigInfoMap();
        TicketIdDefList ticketIdDefList = new TicketIdDefList();
        FreifeldSettingList freifelder = new FreifeldSettingList();
        MailResourceToAbsenderAndAliasMap mailResourceToAbsenderMap = new MailResourceToAbsenderAndAliasMap();
        UserImportConfigInfoMap userImportConfigInfoMap = new UserImportConfigInfoMap();
        HashMap<Integer, String> indexToTicketIdDef = new HashMap<Integer, String>();
        ServerPropertiesConverter.readDatabaseConnections(old, dbConfigInfoMap);
        ServerPropertiesConverter.readGlobalConnections(old, dbConfigInfoMap, ldapConfigInfoMap, userImportConfigInfoMap);
        block56: for (Map.Entry<Object, Object> entry : old.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("mail/")) {
                ServerPropertiesConverter.convertMailEntry(key, (String)entry.getValue(), accountMap);
                continue;
            }
            if (key.startsWith("mail.resourceAbs.")) {
                String resName = key.substring("mail.resourceAbs.".length());
                mailResourceToAbsenderMap.setAbsender(resName, (String)entry.getValue());
                continue;
            }
            if (key.startsWith("mail.resourceAbsAlias.")) {
                String resName = key.substring("mail.resourceAbsAlias.".length());
                mailResourceToAbsenderMap.setAlias(resName, (String)entry.getValue());
                continue;
            }
            if (key.startsWith("mailheader.name")) {
                if (mailHeaders.containsKey(entry.getValue()) || ((String)entry.getValue()).trim().length() <= 0) continue;
                try {
                    int index = Integer.valueOf(key.substring("mailheader.name".length()));
                    String headerValue = old.getProperty("mailheader.value" + index);
                    mailHeaders.put((String)entry.getValue(), headerValue);
                }
                catch (NumberFormatException exc) {
                    HDLogger.error("unknown key " + key);
                }
                continue;
            }
            if (key.startsWith("device/")) {
                String deviceFileName = key.substring("device/".length());
                if (deviceFileName.contains(".")) {
                    deviceFileName = deviceFileName.substring(0, deviceFileName.indexOf(46));
                }
                Properties deviceImportProps = ServerPropertiesConverter.getImportDefProps(deviceFileName);
                String host = deviceImportProps.getProperty("host", "");
                String domaene = deviceImportProps.getProperty("domaene", "");
                String port = deviceImportProps.getProperty("port", "");
                String datasource = deviceImportProps.getProperty("datasource", "");
                String user = deviceImportProps.getProperty("user", "");
                String password = deviceImportProps.getProperty("password", "");
                if (password.length() > 0 && password.charAt(0) == '\u0001') {
                    password = SecurityUtils.decodePassword(password);
                }
                String searchContext = deviceImportProps.getProperty("searchContext", "");
                DeviceImportConfigInfo deviceImportConfigInfo = DeviceImportConfigInfo.importFrom(deviceImportProps);
                String connectionName = ServerPropertiesConverter.getOrAddConnection(dbConfigInfoMap, ldapConfigInfoMap, "Device", host, domaene, searchContext, port, datasource, user, password);
                deviceImportConfigInfo.setConnectionName(connectionName);
                deviceImportConfigInfo.setLdap("0".equals(datasource) || "6".equals(datasource));
                deviceImportConfigInfoMap.put(deviceFileName, deviceImportConfigInfo);
                continue;
            }
            if (key.startsWith("mailheader.value")) {
                try {
                    String headerName;
                    int index = Integer.valueOf(key.substring("mailheader.value".length()));
                    if (mailHeaders.containsKey(old.getProperty("mailheader.name" + index)) || (headerName = old.getProperty("mailheader.name" + index)) == null || headerName.trim().length() <= 0) continue;
                    mailHeaders.put(headerName, (String)entry.getValue());
                }
                catch (NumberFormatException exc) {
                    HDLogger.error("unknown key " + key);
                }
                continue;
            }
            if (key.startsWith(TICKET_ID_DEF_KEY)) {
                try {
                    String indexString = key.substring(TICKET_ID_DEF_KEY.length());
                    int index = indexString.length() == 0 ? 0 : Integer.valueOf(indexString);
                    indexToTicketIdDef.put(index, (String)entry.getValue());
                }
                catch (NumberFormatException exc) {
                    HDLogger.error("unknown key " + key);
                }
                continue;
            }
            if (key.startsWith("ldap")) {
                String value = (String)entry.getValue();
                ServerPropertiesConverter.readIntoUserImportConfigInfo(userImportConfigInfoMap, key, value);
                continue;
            }
            if (FREIFELD_NAMEN.containsKey(key.toUpperCase())) {
                try {
                    Freifeld freifeld = Freifeld.valueOf(FREIFELD_NAMEN.get(key.toUpperCase()));
                    FreifeldSetting setting = new FreifeldSetting(freifeld);
                    String value = (String)entry.getValue();
                    String[] values = value.split(";");
                    if (values.length >= 2) {
                        String dbName = values[0];
                        if (dbName.isEmpty()) {
                            dbName = "HDS";
                        }
                        setting.setDatabase(dbName);
                        setting.setQueryName(values[1]);
                        if (values.length > 2) {
                            switch (values[2].toLowerCase()) {
                                case "multi": {
                                    setting.setFreifeldType(FreifeldType.Multi);
                                    break;
                                }
                                case "editable": {
                                    setting.setFreifeldType(FreifeldType.Editable);
                                    break;
                                }
                                default: {
                                    setting.setFreifeldType(FreifeldType.Single);
                                }
                            }
                        }
                    }
                    freifelder.add(setting);
                }
                catch (IllegalArgumentException exc) {
                    HDLogger.error(exc);
                }
                continue;
            }
            if (key.toLowerCase().equals("attachmentfilepath")) {
                String path = (String)entry.getValue();
                if (path.isEmpty()) continue;
                File attFolder = new File(path);
                if (attFolder.exists() && attFolder.isDirectory()) {
                    File rootFolder = attFolder.getParentFile();
                    if (rootFolder != null) {
                        try {
                            if (!Files.isWritable(rootFolder.toPath())) {
                                rootFolder = null;
                            }
                        }
                        catch (InvalidPathException ex) {
                            rootFolder = null;
                        }
                    }
                    if (rootFolder == null) {
                        rootFolder = attFolder;
                    } else {
                        File parallelFolder = new File(rootFolder, ".HelpDeskAppData");
                        if (parallelFolder.exists()) {
                            HDLogger.error(new Throwable("AppDataPath allready exists"));
                        }
                        rootFolder = !parallelFolder.exists() && parallelFolder.mkdir() ? parallelFolder : attFolder;
                    }
                    HDLogger.info("Set " + ConfigKey.APP_DATA_PATH.getKey() + ": " + rootFolder.getAbsolutePath().toString());
                    props.setProperty(ConfigKey.APP_DATA_PATH.getKey(), rootFolder.getAbsolutePath().toString());
                    props.setProperty("AttachmentFilePath", (String)entry.getValue());
                    continue;
                }
                HDLogger.error("attachmentfilepath could not be converted: '" + path + "'");
                continue;
            }
            switch (key.toLowerCase()) {
                case "defaultlocale": {
                    props.put("vm.user.country", entry.getValue());
                    continue block56;
                }
                case "mail.starttls": {
                    props.setProperty(HDConfigKeys.MAIL_ENCRYPTION.getKey(), "true".equals(entry.getValue()) ? "STARTTLS" : "NONE");
                    continue block56;
                }
                case "mail.from": 
                case "mail.users.defabs": {
                    if ("".equals(entry.getValue())) continue block56;
                    props.put(ConfigKey.MAIL_SENDER.getKey(), entry.getValue());
                    continue block56;
                }
                case "mail.password": {
                    String v = (String)entry.getValue();
                    props.put(ConfigKey.MAIL_PASSWORD.getKey(), Encryption.encrypt((String)ServerPropertiesConverter.getOldPassword(v.toCharArray())));
                    continue block56;
                }
                case "mail.port": {
                    props.put(ConfigKey.MAIL_SMTPPORT.getKey(), entry.getValue());
                    continue block56;
                }
                case "mail.host": {
                    props.put(ConfigKey.MAIL_SMTPHOST.getKey(), entry.getValue());
                    continue block56;
                }
                case "mail.logofile": {
                    if (props.get(ConfigKey.IMPRINT_LOGO_URL.getKey()) != null) continue block56;
                    ServerPropertiesConverter.setLogoFileProp(props, entry);
                    continue block56;
                }
                case "logofile": {
                    ServerPropertiesConverter.setLogoFileProp(props, entry);
                    continue block56;
                }
                case "loginurl": {
                    props.put(ConfigKey.PERMISSION_LOGINURL.getKey(), entry.getValue());
                    continue block56;
                }
                case "loginurl.trustall": {
                    props.put(ConfigKey.PERMISSION_LOGINURL_TRUSTALL.getKey(), entry.getValue());
                    continue block56;
                }
                case "triggerfile": {
                    props.put("triggerfile", entry.getValue());
                    continue block56;
                }
                case "port2": {
                    if ("".equals(entry.getValue())) continue block56;
                    props.put(ConfigKey.LISTENER_PORT.getKey(), entry.getValue());
                    continue block56;
                }
                case "mail.authentification": {
                    if (!"true".equals(entry.getValue())) continue block56;
                    props.put(ConfigKey.MAIL_AUTHENTICATION.getKey(), "" + MailAuthenticationMethod.SMTP.ordinal());
                    continue block56;
                }
                case "port": {
                    if ("".equals(entry.getValue()) || !props.getProperty(ConfigKey.LISTENER_PORT.getKey(), "").isEmpty()) continue block56;
                    try {
                        int port1 = Integer.valueOf((String)entry.getValue());
                        props.setProperty(ConfigKey.LISTENER_PORT.getKey(), "" + (port1 + 2));
                    }
                    catch (Exception exception) {}
                    continue block56;
                }
                case "serialnumber": {
                    props.put(ConfigKey.LICENSEKEY.getKey(), entry.getValue());
                    continue block56;
                }
            }
            if (ServerPropertiesConverter.isOutdatedKey(key)) continue;
            props.put(key, entry.getValue());
        }
        if (accountMap.size() > 0) {
            EmailAccountList accounts = new EmailAccountList();
            accounts.addAll(accountMap.values());
            props.setProperty(HDConfigKeys.MAIL_ACCOUNTS.getKey(), accounts.toString());
        }
        if (dbConfigInfoMap.size() > 0) {
            DatabaseConfigInfoList list = new DatabaseConfigInfoList();
            for (Map.Entry entry : dbConfigInfoMap.entrySet()) {
                ((DatabaseConfigInfo)entry.getValue()).setDbName((String)entry.getKey());
                list.add((DatabaseConfigInfo)entry.getValue());
            }
            props.setProperty(HDConfigKeys.DB_CONFIGS.getKey(), list.toString());
        }
        if (ldapConfigInfoMap.size() > 0) {
            props.setProperty(HDConfigKeys.LDAP_CONNECTION_INFOS.getKey(), ldapConfigInfoMap.toString());
        }
        if (userImportConfigInfoMap.size() > 0) {
            Iterator it = userImportConfigInfoMap.entrySet().iterator();
            while (it.hasNext()) {
                UserImportConfigInfo userImportConfigInfo = (UserImportConfigInfo)it.next().getValue();
                Object ldapAnd = userImportConfigInfo.getLdapAndSyntax();
                if (userImportConfigInfo.isUseUserSyntax() || ldapAnd == null || ((String)ldapAnd).length() <= 0) continue;
                if (((String)ldapAnd).charAt(0) != '(') {
                    ldapAnd = "(" + (String)ldapAnd + ")";
                }
                String ldapQuery = "(&(objectClass=organizationalPerson)" + (String)ldapAnd + ")";
                userImportConfigInfo.setUserSyntax(ldapQuery);
                userImportConfigInfo.setUseUserSyntax(true);
            }
            props.setProperty(HDConfigKeys.USER_IMPORT_CONFIGS.getKey(), userImportConfigInfoMap.toString());
        }
        if (freifelder.size() > 0) {
            props.setProperty(HDConfigKeys.FREIFELDER.getKey(), freifelder.toString());
        }
        if (mailHeaders.size() > 0) {
            props.setProperty(HDConfigKeys.OUTGOING_MAIL_HEADERS.getKey(), mailHeaders.toString());
        }
        if (deviceImportConfigInfoMap.size() > 0) {
            props.setProperty(HDConfigKeys.DEVICE_IMPORT_CONFIGS.getKey(), deviceImportConfigInfoMap.toString());
        }
        if (mailResourceToAbsenderMap.size() > 0) {
            props.setProperty(HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP.getKey(), mailResourceToAbsenderMap.toString());
        }
        if (indexToTicketIdDef.size() > 0) {
            Object[] indexArray = indexToTicketIdDef.keySet().toArray(new Integer[0]);
            Arrays.sort(indexArray);
            for (Object index : indexArray) {
                ticketIdDefList.add((String)indexToTicketIdDef.get(index));
            }
            props.setProperty(HDConfigKeys.TICKET_ID_DEF_LIST.getKey(), ticketIdDefList.toString());
        }
        props.setProperty(ConfigKey.LOG_LEVELS.getKey(), "{\"Reporting\":1, \"Config\":3, \"HelpDesk\":3}");
        return props;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="internal api")
    private static void setLogoFileProp(Properties props, Map.Entry<Object, Object> entry) {
        Object logofile = (String)entry.getValue();
        if (!"".equals(logofile)) {
            try {
                if (!Paths.get((String)logofile, new String[0]).isAbsolute()) {
                    logofile = "Templates/" + (String)logofile;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            props.put(ConfigKey.IMPRINT_LOGO_URL.getKey(), logofile);
        }
    }

    private static String getOldPassword(char[] input) {
        for (int i = 0; i < input.length; ++i) {
            input[i] = (char)(input[i] ^ 0x24);
        }
        return new String(input);
    }

    private static boolean isOutdatedKey(String key) {
        return OUTDATED_KEY_PREFIXES.stream().filter(k -> key.toLowerCase().startsWith(k.toLowerCase())).count() > 0L;
    }

    private static String getOrAddConnection(Map<String, DatabaseConfigInfo> dbConfigInfoMap, LdapConnectionInfoMap ldapConfigInfoMap, String prefix, String host, String domaene, String searchContext, String port, String datasource, String user, String decodedPassword) {
        if (decodedPassword.length() > 0 && decodedPassword.charAt(0) == '\u0001') {
            throw new IllegalArgumentException("unexpected password for " + user + " detected while converting ServerProperties!");
        }
        Object connectionName = null;
        for (Map.Entry<String, DatabaseConfigInfo> dbConfigInfoEntry : dbConfigInfoMap.entrySet()) {
            DatabaseConfigInfo dbConfigInfo = dbConfigInfoEntry.getValue();
            if (!host.equals(dbConfigInfo.getHost()) || "0".equals(datasource) || "6".equals(datasource) || !domaene.equals(dbConfigInfo.getCatalog()) || !port.equals(dbConfigInfo.getPort()) || !datasource.equals("" + dbConfigInfo.getBackendType()) || !user.equals(dbConfigInfo.getUser()) || !decodedPassword.equals(dbConfigInfo.getEncodedPassword()) && !decodedPassword.equals(dbConfigInfo.getDecodedPassword())) continue;
            connectionName = dbConfigInfoEntry.getKey();
            break;
        }
        if (connectionName == null) {
            if ("0".equals(datasource) || "6".equals(datasource)) {
                String connName = prefix + "Ldap";
                if (!host.isEmpty()) {
                    connName = connName + "." + host;
                }
                if (!user.isEmpty()) {
                    connName = connName + "." + user;
                }
                if (!port.isEmpty()) {
                    connName = connName + "." + port;
                }
                LdapConnectionInfo newLdapConnectionInfo = new LdapConnectionInfo(connName);
                newLdapConnectionInfo.put("host", host);
                newLdapConnectionInfo.put("user", user);
                newLdapConnectionInfo.setDecodedPassword(decodedPassword);
                newLdapConnectionInfo.put("port", port);
                newLdapConnectionInfo.put("datasource", datasource);
                newLdapConnectionInfo.put("domaene", domaene);
                newLdapConnectionInfo.setSsl("6".equals(datasource));
                newLdapConnectionInfo.setSearchContext(searchContext);
                ldapConfigInfoMap.put(connName, newLdapConnectionInfo);
                connectionName = connName;
            } else {
                DatabaseConfigInfo newDbConfigInfo = new DatabaseConfigInfo();
                newDbConfigInfo.setHost(host);
                newDbConfigInfo.setPort(port);
                newDbConfigInfo.setUser(user);
                newDbConfigInfo.setCatalog(domaene);
                newDbConfigInfo.setDriver(ServerPropertiesConverter.driverForDatasourceType(datasource));
                newDbConfigInfo.setDecodedPassword(decodedPassword.toCharArray());
                String connName = prefix + "Db";
                if (!host.isEmpty()) {
                    connName = connName + "." + host;
                }
                if (!user.isEmpty()) {
                    connName = connName + "." + user;
                }
                if (!port.isEmpty()) {
                    connName = connName + "." + port;
                }
                dbConfigInfoMap.put(connName, newDbConfigInfo);
                connectionName = connName;
            }
        }
        return connectionName;
    }

    private static void readIntoUserImportConfigInfo(UserImportConfigInfoMap userImportConfigInfoMap, String key, String value) {
        Iterator it = userImportConfigInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            UserImportConfigInfo userImportConfigInfo = (UserImportConfigInfo)it.next().getValue();
            switch (key.toLowerCase()) {
                case "ldap.timeoption": {
                    userImportConfigInfo.setSchedule(userImportConfigInfo.mapOldSchedule(value));
                    break;
                }
                case "ldap.alle": {
                    userImportConfigInfo.setAlle(Boolean.valueOf(value));
                    break;
                }
                case "ldap.reaktivieren": {
                    userImportConfigInfo.setReaktivieren(Boolean.valueOf(value));
                    break;
                }
                case "ldap.loeschen": {
                    userImportConfigInfo.setLoeschen(Boolean.valueOf(value));
                    break;
                }
                case "ldap.useusersyntax": {
                    userImportConfigInfo.setUseUserSyntax(Boolean.valueOf(value));
                    break;
                }
                case "ldap.usersyntax": {
                    userImportConfigInfo.setUserSyntax(value);
                    break;
                }
                case "ldap.tabelle": {
                    userImportConfigInfo.setTable(value);
                    break;
                }
                case "ldap.selectioncolumns": {
                    userImportConfigInfo.setSelektionList(value);
                    break;
                }
                case "ldap.defaultsncolumn": {
                    userImportConfigInfo.setDefaultSnColumn(value);
                    break;
                }
                case "ldapandsyntax": {
                    userImportConfigInfo.setLdapAndSyntax(value);
                }
            }
        }
    }

    private static DatabaseConfigInfo.DatabaseType driverForDatasourceType(String datasource) {
        switch (datasource) {
            case "1": {
                return DatabaseConfigInfo.DatabaseType.odbc;
            }
            case "2": {
                return DatabaseConfigInfo.DatabaseType.inetdae7;
            }
            case "4": {
                return DatabaseConfigInfo.DatabaseType.inetora;
            }
            case "5": {
                return DatabaseConfigInfo.DatabaseType.mysql;
            }
        }
        return DatabaseConfigInfo.DatabaseType.inetdae7;
    }

    private static void readGlobalConnections(Properties old, Map<String, DatabaseConfigInfo> dbConfigInfoMap, LdapConnectionInfoMap ldapConfigInfoMap, UserImportConfigInfoMap userImportConfigInfoMap) {
        String[] domains;
        String[] decodedPws;
        String[] users;
        String hostProperty = old.getProperty("ldap.host", "");
        String datasourceProperty = old.getProperty("ldap.DataSource", "");
        String userProperty = old.getProperty("ldap.user", "");
        Object pwProperty = old.getProperty("ldap.password", "");
        if (((String)pwProperty).length() > 0) {
            if (((String)pwProperty).charAt(0) != '\u0001' && ((String)pwProperty).chars().anyMatch(c -> c < 32)) {
                pwProperty = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", "\u0001"}, (String)pwProperty);
            }
            if (((String)pwProperty).charAt(0) == '\u0001') {
                pwProperty = SecurityUtils.decodePassword((String)pwProperty);
            }
        }
        String portProperty = old.getProperty("ldap.port", "");
        String domaeneProperty = old.getProperty("ldap.domaene", "");
        String searchContextProperty = old.getProperty("ldap.searchContext", "");
        String[] hosts = hostProperty.split("\\|");
        if (hosts.length == 0) {
            hosts = new String[]{""};
        }
        if ((users = userProperty.split("\\|")).length == 0) {
            users = new String[]{""};
        }
        if ((decodedPws = ((String)pwProperty).split("\\|")).length == 0) {
            decodedPws = new String[]{""};
        }
        if ((domains = domaeneProperty.split("\\|")).length == 0) {
            domains = new String[]{""};
        }
        for (int i = 0; i < hosts.length; ++i) {
            String host = hosts[i];
            if (host.length() == 0) continue;
            String user = users.length > i ? users[i] : users[users.length - 1];
            String decodedPw = decodedPws.length > i ? decodedPws[i] : decodedPws[decodedPws.length - 1];
            String domaene = domains.length > i ? domains[i] : domains[domains.length - 1];
            String connectionName = ServerPropertiesConverter.getOrAddConnection(dbConfigInfoMap, ldapConfigInfoMap, "User", host, domaene, searchContextProperty, portProperty, datasourceProperty, user, decodedPw);
            UserImportConfigInfo info = new UserImportConfigInfo();
            info.setUid(UUID.randomUUID().toString());
            info.setConnectionName(connectionName);
            info.setLdap("0".equals(datasourceProperty) || "6".equals(datasourceProperty));
            if (i == 0) {
                info.setName("Default");
            } else {
                info.setName("Default" + i);
            }
            userImportConfigInfoMap.put(info.getName(), info);
        }
    }

    private static void readDatabaseConnections(Properties old, Map<String, DatabaseConfigInfo> dbConfigInfoMap) {
        for (Map.Entry<Object, Object> entry : old.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("dbs/")) continue;
            ServerPropertiesConverter.convertDbsEntry(key.substring(4), (String)entry.getValue(), dbConfigInfoMap);
        }
    }

    private static void convertDbsEntry(String key, String value, Map<String, DatabaseConfigInfo> dbConfigInfoMap) {
        String propName;
        int idx = key.lastIndexOf(46);
        if (idx < 0) {
            return;
        }
        String name = key.substring(0, idx);
        DatabaseConfigInfo account = dbConfigInfoMap.get(name);
        if (account == null) {
            account = new DatabaseConfigInfo();
            account.setDbName(name);
            dbConfigInfoMap.put(name, account);
        }
        if ("password".equals(propName = key.substring(idx + 1))) {
            if (value.length() > 0 && value.charAt(0) == '\u0001') {
                account.setEncodedPassword(new String(Base64.getEncoder().encode(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
            } else {
                account.setDecodedPassword(value.toCharArray());
            }
        } else if ("url".equals(propName)) {
            account.setCustomUrl(value);
        } else if ("user".equals(propName)) {
            account.setUser(value);
        } else if ("host".equals(propName)) {
            account.setHost(value);
        } else if ("port".equals(propName)) {
            account.setPort(value);
        } else if ("sid".equals(propName)) {
            account.setSid(value);
        } else if ("catalog".equals(propName)) {
            account.setCatalog(value);
        } else if ("driver".equals(propName)) {
            account.setDriver(DatabaseConfigInfo.DatabaseType.valueOf(value));
        }
    }

    private static Properties getImportDefProps(String name) {
        Properties propse;
        block5: {
            propse = new Properties();
            try {
                if (name == null) break block5;
                InputStream is = null;
                try {
                    is = get.streamForRelativeFileName(name);
                }
                catch (FileNotFoundException e2) {
                    HDLogger.error(e2);
                }
                if (is != null) {
                    propse.load(is);
                    Properties lowercaseProps = new Properties();
                    propse.entrySet().stream().forEach(e -> lowercaseProps.setProperty(String.valueOf(e.getKey()).toLowerCase(), String.valueOf(e.getValue())));
                    propse = lowercaseProps;
                    is.close();
                }
            }
            catch (Throwable e3) {
                HDLogger.error(e3);
            }
        }
        return propse;
    }

    private static void convertMailEntry(String key, String value, Map<String, EmailAccount> accounts) {
        String propName;
        int idx = key.lastIndexOf(46);
        if (idx < 0) {
            return;
        }
        String name = key.substring(0, idx);
        EmailAccount account = accounts.get(name);
        if (account == null) {
            account = new EmailAccount();
            accounts.put(name, account);
        }
        if ("account".equals(propName = key.substring(idx + 1))) {
            account.setAccount((String)value);
        } else if ("password".equals(propName)) {
            if (((String)value).length() > 0) {
                if (((String)value).charAt(0) != '\u0001' && ((String)value).chars().anyMatch(c -> c < 32)) {
                    value = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", "\u0001"}, (String)value);
                }
                if (((String)value).charAt(0) == '\u0001') {
                    account.setPasswordEncoded(new String(Base64.getEncoder().encode(((String)value).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                } else {
                    account.setPasswordDecoded((String)value);
                }
            }
        } else if ("from".equals(propName)) {
            account.setFrom((String)value);
        } else if ("bezeich".equals(propName)) {
            account.setFromName((String)value);
        } else if ("kategorie".equals(propName)) {
            try {
                Integer categoryId = CategoryManager.getInstance().findOrCreateCategory((String)value);
                account.setCategoryId(categoryId);
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
        } else if ("noBundles".equals(propName)) {
            account.setNoBundles((String)value);
        } else if ("template".equals(propName)) {
            int dotIndex = ((String)value).lastIndexOf(46);
            if (dotIndex > -1) {
                value = ((String)value).substring(0, dotIndex);
            }
            account.setTemplate((String)value);
        } else if ("errorMessage".equals(propName)) {
            account.setErrorMessage((String)value);
        } else if ("host".equals(propName)) {
            account.setHost((String)value);
        } else if ("port".equals(propName)) {
            account.setPort((String)value);
        } else if ("imapProtokoll".equals(propName)) {
            account.setProtocol((String)value);
        } else if ("ssl".equals(propName)) {
            account.setSSL("true".equals(value));
        } else if ("directory".equals(propName)) {
            account.setDirectory((String)value);
        } else if ("newuser".equals(propName)) {
            account.setNewUser("true".equals(value));
        } else if ("newDomainGeb".equals(propName)) {
            account.setCreateDomain("true".equals(value));
        } else if ("prioritaet".equals(propName)) {
            try {
                account.setPriority(((String)value).isEmpty() ? 0 : Integer.parseInt((String)value));
            }
            catch (Exception e) {
                HDLogger.error(e);
            }
        } else if ("ressource".equals(propName)) {
            try {
                account.setResID(value == null || ((String)value).isEmpty() ? 0 : Integer.parseInt((String)value));
            }
            catch (Exception e) {
                HDLogger.error(e);
            }
        }
    }

    private static void convertTicketIdDefList(TicketIdDefList list, Properties old) {
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                old.setProperty(TICKET_ID_DEF_KEY + i, (String)list.get(i));
                continue;
            }
            old.setProperty(TICKET_ID_DEF_KEY, (String)list.get(i));
        }
    }

    private static void convertEmailAccounts(EmailAccountList accounts, Properties old) {
        for (EmailAccount account : accounts) {
            String base = "mail/" + account.getAccount() + ".";
            ServerPropertiesConverter.putNonNull(old, base, "account", account.getAccount());
            ServerPropertiesConverter.putNonNull(old, base, "password", account.getPasswordEncoded());
            ServerPropertiesConverter.putNonNull(old, base, "from", account.getFrom());
            ServerPropertiesConverter.putNonNull(old, base, "bezeich", account.getFromName());
            try {
                Integer categoryId = account.getCategoryId();
                String categoryPath = CategoryManager.getInstance().findCategoryPathOrThrow(categoryId);
                ServerPropertiesConverter.putNonNull(old, base, "kategorie", categoryPath);
            }
            catch (ServerDataException e) {
                HDLogger.error(e);
                ServerPropertiesConverter.putNonNull(old, base, "kategorie", "");
            }
            ServerPropertiesConverter.putNonNull(old, base, "noBundles", account.getNoBundles());
            ServerPropertiesConverter.putNonNull(old, base, "template", account.getTemplate());
            ServerPropertiesConverter.putNonNull(old, base, "errorMessage", account.getErrorMessage());
            ServerPropertiesConverter.putNonNull(old, base, "host", account.getHost());
            if (account.getPort() > 0) {
                ServerPropertiesConverter.putNonNull(old, base, "port", String.valueOf(account.getPort()));
            }
            ServerPropertiesConverter.putNonNull(old, base, "imapProtokoll", String.valueOf((Object)account.getProtocol()));
            ServerPropertiesConverter.putNonNull(old, base, "ssl", String.valueOf(account.getSSL()));
            ServerPropertiesConverter.putNonNull(old, base, "directory", account.getDirectory());
            ServerPropertiesConverter.putNonNull(old, base, "newuser", String.valueOf(account.getNewUser()));
            ServerPropertiesConverter.putNonNull(old, base, "newDomainGeb", String.valueOf(account.getCreateDomain()));
            if (account.getPriority() > 0) {
                ServerPropertiesConverter.putNonNull(old, base, "prioritaet", String.valueOf(account.getPriority()));
            }
            if (account.getResID() <= 0) continue;
            ServerPropertiesConverter.putNonNull(old, base, "ressource", String.valueOf(account.getResID()));
        }
    }

    private static void convertResourceToAbsenderAndAliasMap(MailResourceToAbsenderAndAliasMap map, Properties old) {
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            if (((String)entry.getKey()).startsWith("abs.")) {
                ServerPropertiesConverter.putNonNull(old, "mail.resourceAbs.", ((String)entry.getKey()).substring(4), (String)entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).startsWith("ali.")) continue;
            ServerPropertiesConverter.putNonNull(old, "mail.resourceAbsAlias.", ((String)entry.getKey()).substring(4), (String)entry.getValue());
        }
    }

    private static void convertDbConfigs(DatabaseConfigInfoList list, Properties old) {
        for (DatabaseConfigInfo account : list) {
            String base = "dbs/" + account.getDbName() + ".";
            ServerPropertiesConverter.putNonNull(old, base, "user", account.getUser());
            ServerPropertiesConverter.putNonNull(old, base, "password", account.getEncodedPassword());
            ServerPropertiesConverter.putNonNull(old, base, "url", account.getUrl());
            ServerPropertiesConverter.putNonNull(old, base, "sid", account.getSid());
            ServerPropertiesConverter.putNonNull(old, base, "host", account.getHost());
            ServerPropertiesConverter.putNonNull(old, base, "catalog", account.getCatalog());
            ServerPropertiesConverter.putNonNull(old, base, "driver", account.getDriver().name());
            ServerPropertiesConverter.putNonNull(old, base, "port", account.getPort());
        }
    }

    private static void convertMailHeaders(OutgoingMailHeaderMap headers, Properties old) {
        Object[] array = headers.keySet().toArray();
        Arrays.sort(array);
        int i = 0;
        for (Object key : array) {
            String value = (String)headers.get(key);
            ServerPropertiesConverter.putNonNull(old, "mailheader.name" + i, "", key.toString());
            ServerPropertiesConverter.putNonNull(old, "mailheader.value" + i, "", value);
            ++i;
        }
    }

    private static void putNonNull(Properties props, String baseKey, String key, String value) {
        if (value != null) {
            props.setProperty(baseKey + key, value);
        }
    }

    public static Properties toOldFormat(Properties newProps) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : newProps.entrySet()) {
            ArrayList list;
            String key = (String)entry.getKey();
            if (key.equals(HDConfigKeys.MAIL_ACCOUNTS.getKey())) {
                EmailAccountList accounts = EmailAccountList.valueOf((String)entry.getValue());
                ServerPropertiesConverter.convertEmailAccounts(accounts, props);
                continue;
            }
            if (key.equals(HDConfigKeys.DB_CONFIGS.getKey())) {
                list = DatabaseConfigInfoList.valueOf((String)entry.getValue());
                ServerPropertiesConverter.convertDbConfigs(list, props);
                continue;
            }
            if (key.equals(HDConfigKeys.OUTGOING_MAIL_HEADERS.getKey())) {
                OutgoingMailHeaderMap mailHeaders = OutgoingMailHeaderMap.valueOf((String)entry.getValue());
                ServerPropertiesConverter.convertMailHeaders(mailHeaders, props);
                continue;
            }
            if (key.equals(HDConfigKeys.TICKET_ID_DEF_LIST.getKey())) {
                list = TicketIdDefList.valueOf((String)entry.getValue());
                ServerPropertiesConverter.convertTicketIdDefList((TicketIdDefList)list, props);
                continue;
            }
            if (key.equals(HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP.getKey())) {
                MailResourceToAbsenderAndAliasMap map = MailResourceToAbsenderAndAliasMap.valueOf((String)entry.getValue());
                ServerPropertiesConverter.convertResourceToAbsenderAndAliasMap(map, props);
                continue;
            }
            props.put(key, entry.getValue());
        }
        return props;
    }

    static interface InputStreamForFile {
        public InputStream streamForRelativeFileName(String var1) throws FileNotFoundException;
    }
}

