/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.PriorityList;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.lib.json.Json;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PriorityListConfigProperty
extends ItemListConfigProperty {
    public PriorityListConfigProperty(ConnectionFactory factory, ConfigStructureSettings settings, Translator translator) {
        super(0, "Priorities", "PRIORITIES", PriorityListConfigProperty.getObjectListValue(factory, settings), null, PriorityListConfigProperty.createRowActions(settings, translator));
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"hide", "true"}));
        this.setReloadAfterRowDeletion(true);
    }

    static Object getObjectListValue(ConnectionFactory connectionFactory, ConfigStructureSettings settings) {
        List changedValueRaw = (List)settings.getChangedValue("Priorities", List.class);
        if (changedValueRaw != null) {
            List idList = changedValueRaw.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
            changedValueRaw.forEach(m -> {
                ArrayList idListWithoutMyself = new ArrayList(idList);
                idListWithoutMyself.remove(m.get("id"));
                String idListJson = new Json().toJson(idListWithoutMyself);
                m.put("allids", idListJson);
            });
            Comparator<Map> comparator = Comparator.comparing(e -> Integer.valueOf((String)e.get("id")));
            return changedValueRaw.stream().sorted(comparator.reversed()).collect(Collectors.toList());
        }
        int defaultPrio = 0;
        try (Connection con = connectionFactory.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT PriID FROM tblOptionen");){
            if (rs.next()) {
                defaultPrio = rs.getInt("PriID");
            }
        }
        catch (SQLException sqlex) {
            HDLogger.error(sqlex);
        }
        List list = PriorityManager.getInstance().getAll(true).stream().sorted((o1, o2) -> Integer.compare(o2.getId(), o1.getId())).collect(Collectors.toList());
        PriorityList cList = new PriorityList();
        cList.addAll(list);
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        List idList = cList.stream().map(p -> "" + p.getId()).collect(Collectors.toList());
        String allIds = new Json().toJson(idList);
        for (PriorityVO priority : cList) {
            HashMap<String, String> entry = PriorityListConfigProperty.convertToHashmap(priority, defaultPrio);
            if (defaultPrio == priority.getId()) {
                entry.put("hide", "true");
            }
            entry.put("isNewlyCreated", "false");
            entry.put("allids", allIds);
            result.add(entry);
        }
        return result;
    }

    private static HashMap<String, String> convertToHashmap(PriorityVO priority, int defaultPrio) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("PriBezeichnung", priority.getDisplayValue());
        result.put("EskaZeit", "" + priority.getEscalationTimeout());
        result.put("DeadLine", "" + priority.getDeadline());
        result.put("PriImage", priority.getImageName());
        result.put("IsDefault", "" + (priority.getId() == defaultPrio));
        result.put("id", "" + priority.getId());
        result.put("hide", "false");
        TicketValueIconConfigProperty.prepareConfigValueMapForIcons(result);
        return result;
    }

    public static PriorityList convertToList(HashMap<String, String>[] result) {
        PriorityList map = new PriorityList();
        for (HashMap<String, String> priority : result) {
            PriorityVO info = PriorityListConfigProperty.convertToEntry(priority);
            map.add(info);
        }
        return map;
    }

    private static PriorityVO convertToEntry(HashMap<String, String> priorityMap) {
        String id = priorityMap.get("id");
        if (id == null) {
            id = "-1";
        }
        int idNum = Integer.parseInt(id);
        String eskaZeitStr = priorityMap.get("EskaZeit");
        String deadLineStr = priorityMap.get("DeadLine");
        double eskaZeit = 0.0;
        try {
            eskaZeit = Double.parseDouble(eskaZeitStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        double deadLine = 0.0;
        try {
            deadLine = Double.parseDouble(deadLineStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new PriorityVO(idNum, priorityMap.get("PriBezeichnung"), eskaZeit, deadLine, priorityMap.get("PriImage"));
    }

    private static ConfigRowAction[] createRowActions(ConfigStructureSettings settings, Translator translator) {
        List allids = null;
        List changedValueRaw = (List)settings.getChangedValue("Priorities", List.class);
        if (changedValueRaw != null) {
            allids = changedValueRaw.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
        } else {
            String prioritiesOrigValue = settings.getValue("Priorities");
            if (prioritiesOrigValue != null) {
                PriorityList priorities = (PriorityList)new Json().fromJson(prioritiesOrigValue, PriorityList.class);
                allids = priorities.stream().map(p -> "" + p.getId()).collect(Collectors.toList());
            } else {
                allids = PriorityManager.getInstance().getAll(true).stream().map(s -> "" + s.getId()).collect(Collectors.toList());
            }
        }
        int defaultPrio = 50;
        while (allids.contains("" + defaultPrio)) {
            ++defaultPrio;
        }
        String myId = settings.getValue("id");
        if (myId != null) {
            allids.remove(myId);
        }
        ConfigAction action = new ConfigAction("priority.new", translator.translate("AddPriority"));
        ConfigCategory category = new ConfigCategory(0, "priority.new", translator.translate("Priority"), "ticket.values.priorities");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "priority.new.group", ""));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("priority.new.group", propertyList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        conditions.add(g.enableActionFor(g.createCondition().property("isNewlyCreated").equals().value((Object)"true"), "id"));
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(PriorityListConfigProperty.propWith("FixNumber", translator.translate("PriID"), "id", "" + defaultPrio));
        propertyList.add(PriorityListConfigProperty.propWith("SimpleText", translator.translate("PriBezeichnung"), "PriBezeichnung", ""));
        ArrayList<UnitConfigProperty.Unit> units = new ArrayList<UnitConfigProperty.Unit>();
        units.add(new UnitConfigProperty.Unit(60.0, translator.translate("mail.timer.minutes")));
        units.add(new UnitConfigProperty.Unit(1.0, translator.translate("mail.timer.hours")));
        propertyList.add(new UnitConfigProperty(0, "EskaZeit", "FloatNumber", translator.translate("EskaZeit"), (Object)"8.0", null, units, null));
        propertyList.add(new UnitConfigProperty(0, "DeadLine", "FloatNumber", translator.translate("DeadLine"), (Object)"8.0", null, units, null));
        propertyList.add((Object)new TicketValueIconConfigProperty(0, translator.translate("PriImage"), 2));
        propertyList.add(PriorityListConfigProperty.propWith("Hidden", "isNewlyCreated", "isNewlyCreated", "true"));
        propertyList.add(PriorityListConfigProperty.propWith("Hidden", "IsDefault", "IsDefault", "false"));
        propertyList.add(PriorityListConfigProperty.propWith("Hidden", "allids", "allids", new Json().toJson(allids)));
        return new ConfigRowAction[]{rowAction};
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

