/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.core.utils.SecurityUtils;
import java.util.HashMap;

@JsonData
public class LdapConnectionInfo
extends HashMap<String, String> {
    private LdapConnectionInfo() {
    }

    public LdapConnectionInfo(String name) {
        this.put("name", name);
    }

    public DatabaseConfigInfo.Status getStatus() {
        if (this.get("status") == null) {
            this.put("status", DatabaseConfigInfo.Status.Unknown.name());
        }
        return DatabaseConfigInfo.Status.valueOf((String)this.get("status"));
    }

    public void setStatus(DatabaseConfigInfo.Status status) {
        this.put("status", status.name());
    }

    public String getName() {
        return (String)this.get("name");
    }

    public String getHost() {
        return (String)this.get("host");
    }

    public void setHost(String host) {
        this.put("host", host);
    }

    public String getUser() {
        return (String)this.get("user");
    }

    public void setUser(String user) {
        this.put("user", user);
    }

    public String getEncodedPassword() {
        return (String)this.get("password");
    }

    public void setEncodedPassword(String password) {
        this.put("password", password);
    }

    public String getDecodedPassword() {
        return SecurityUtils.decodePassword(this.getEncodedPassword());
    }

    public void setDecodedPassword(String password) {
        this.setEncodedPassword(SecurityUtils.encodePassword(password.toCharArray()));
    }

    public String getDomaene() {
        return (String)this.get("domaene");
    }

    public void setDomaene(String domaene) {
        this.put("domaene", domaene);
    }

    public int getPort() {
        String port = (String)this.get("port");
        if (port == null) {
            return 0;
        }
        return Integer.valueOf(port);
    }

    public void setPort(int port) {
        this.put("port", "" + port);
    }

    public boolean isSsl() {
        return Boolean.valueOf(this.getOrDefault("ssl", "false"));
    }

    public void setSsl(boolean ssl) {
        this.put("ssl", Boolean.toString(ssl));
    }

    public void setSearchContext(String searchContext) {
        this.put("searchContext", searchContext);
    }

    public String getSearchContext() {
        return this.getOrDefault("searchContext", "");
    }
}

