/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.ConfigKey;
import com.inet.helpdesk.config.AddonConfigList;
import com.inet.helpdesk.config.BundleBehavior;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.FreifeldSettingList;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.MailResourceToAbsenderAndAliasMap;
import com.inet.helpdesk.config.OutgoingMailHeaderMap;
import com.inet.helpdesk.config.TicketIdDefList;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.utils.DatabaseVersionChecker;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HDConfigKeys {
    public static final ConfigKey ADDON_CONFIGS = new ConfigKey("addonCfgs", "[]", AddonConfigList.class);
    public static final ConfigKey MAIL_ACCOUNTS_DISABLED = new ConfigKey("mail.accounts.disabled", "false", Boolean.class);
    public static final ConfigKey MAIL_ACCOUNTS = new ConfigKey("mail.accounts", "[]", EmailAccountList.class);
    public static final ConfigKey DB_CONFIGS = new ConfigKey("dbsConfigs", "[]", DatabaseConfigInfoList.class);
    public static final ConfigKey DATABASESTRUCTURE = new ConfigKey("database.structure.versions", "", DatabaseVersionChecker.DatabaseStructureValue.class);
    public static final ConfigKey CUSTOM_DICTIONARY_LOCATION = new ConfigKey("customDictionaryLocation", "Client/dictionaries", String.class);
    public static final String MAIL_SENDER_SOURCE_SUPPORTER_ADDRESS = "0";
    public static final String MAIL_SENDER_SOURCE_MAILBOX = "1";
    public static final String MAIL_SENDER_SOURCE_CATEGORY = "2";
    public static final String MAIL_SENDER_SOURCE_RESOURCE = "3";
    public static final String MAIL_SENDER_SOURCE_FALLBACK_ADDRESS = "4";
    public static final ConfigKey MAIL_SENDER_ORDER = new ConfigKey("mail.sender.order", "01234", String.class);
    public static final ConfigKey MAIL_USERS_DEF_ABSENDER = new ConfigKey("mail.users.DefAbs", "", String.class);
    public static final ConfigKey MAIL_USERS_DEF_ABSENDER_NAME = new ConfigKey("mail.users.DefAbsAlias", "", String.class);
    public static final ConfigKey MAIL_RESOURCES_DEF_ABSENDER = new ConfigKey("mail.resources.DefAbs", "", String.class);
    public static final ConfigKey MAIL_RESOURCES_DEF_ABSENDER_NAME = new ConfigKey("mail.resources.DefAbsAlias", "", String.class);
    public static final ConfigKey MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP = new ConfigKey("mail.resourceToAbsenderAndAliasMap", "{}", MailResourceToAbsenderAndAliasMap.class);
    public static final ConfigKey MAIL_ENCRYPTION = ConfigKey.MAIL_ENCRYPTION;
    public static final ConfigKey MAIL_AUTHENTICATION = ConfigKey.MAIL_AUTHENTICATION;
    public static final ConfigKey MAIL_USER = ConfigKey.MAIL_USER;
    public static final ConfigKey MAIL_PASSWORD = ConfigKey.MAIL_PASSWORD;
    public static final ConfigKey MAIL_PORT = ConfigKey.MAIL_SMTPPORT;
    public static final ConfigKey MAIL_TIMER = new ConfigKey("mail.timer", "2", Integer.class);
    public static final ConfigKey MAILTO_DISPATCHER = new ConfigKey("mailtoDispatcher", null, String.class);
    public static final ConfigKey TICKET_ID_PREFIX = new ConfigKey("TicketIDprefix", "", String.class);
    public static final ConfigKey TICKET_ID_SUFFIX = new ConfigKey("TicketIDsuffix", "", String.class);
    public static final ConfigKey TICKET_ID_DEF_LIST = new ConfigKey("TicketIDdefList", "[\"TicketID\"]", TicketIdDefList.class);
    public static final ConfigKey MAIL_WIEDERVORLAGE_RES = new ConfigKey("mail.wiedervor.res", "false", Boolean.class);
    public static final ConfigKey MAIL_AUTO_ESCA_DISP = new ConfigKey("mail.auto_esca.disp", "false", Boolean.class);
    public static final ConfigKey MAIL_AUTO_ESCA_NEWRES = new ConfigKey("mail.auto_esca.newres", "false", Boolean.class);
    public static final ConfigKey MAIL_MAILEINGANG_RES = new ConfigKey("mail.maileingang.res", "false", Boolean.class);
    public static final ConfigKey MAIL_MAILEINGANG_DISP = new ConfigKey("mail.maileingang.disp", "false", Boolean.class);
    public static final ConfigKey MAIL_MANU_ESCA_DISP = new ConfigKey("mail.manu_esca.disp", "false", Boolean.class);
    public static final ConfigKey MAIL_MANU_ESCA_NEWRES = new ConfigKey("mail.manu_esca.newres", "false", Boolean.class);
    public static final ConfigKey MAIL_ANFRAGE_DISP = new ConfigKey("mail.anfrage.disp", "false", Boolean.class);
    public static final ConfigKey MAIL_DEADLINE_DISP = new ConfigKey("mail.deadline.disp", "true", Boolean.class);
    public static final ConfigKey MAIL_DEADLINE_RES = new ConfigKey("mail.deadline.res", "false", Boolean.class);
    public static final ConfigKey MAIL_AUTORISIERUNG_RES = new ConfigKey("mail.autorisierung.res", "false", Boolean.class);
    public static final ConfigKey FOREIGN_KEY_COLUMN = new ConfigKey("foreignKeyColumn", "", String.class);
    public static final ConfigKey MAIL_FORMAT = new ConfigKey("mail.format", "html", String.class);
    public static final ConfigKey SUBTEMPLATE_ORDER = new ConfigKey("subtemplate.order", "", String.class);
    public static final ConfigKey BUNDLE_BEHAVIOR = new ConfigKey("bundleBehavior", BundleBehavior.sameLocationOnly.name(), BundleBehavior.class);
    public static final ConfigKey TICKET_ID_SERVER_UID = new ConfigKey("ticketIdUid", "", String.class);
    public static final ConfigKey TICKET_ID_FIRST = new ConfigKey("tickedIdFirst", "false", Boolean.class);
    public static final ConfigKey TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD = new ConfigKey("warningthreshold.yellow.escalation", "27.0", Double.class);
    public static final ConfigKey TICKET_WARNING_RED_ESCALATION_THRESHOLD = new ConfigKey("warningthreshold.red.escalation", "18.0", Double.class);
    public static final ConfigKey TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD = new ConfigKey("warningthreshold.yellow.deadline", "0.0", Double.class);
    public static final ConfigKey TICKET_WARNING_RED_DEADLINE_THRESHOLD = new ConfigKey("warningthreshold.red.deadline", "0.0", Double.class);
    public static final ConfigKey TICKET_START_TICKET_ID = new ConfigKey("ticket.start.id", "0", Integer.class);
    public static final ConfigKey AUTOMAIL_WHEN_YELLOW_ESCALATION_THRESHOLD_PASSED = new ConfigKey("mail.warningthreshold.yellow.escalation", "false", Boolean.class);
    public static final ConfigKey AUTOMAIL_WHEN_RED_ESCALATION_THRESHOLD_PASSED = new ConfigKey("mail.warningthreshold.red.escalation", "false", Boolean.class);
    public static final ConfigKey AUTOMAIL_WHEN_YELLOW_DEADLINE_THRESHOLD_PASSED = new ConfigKey("mail.warningthreshold.yellow.deadline", "false", Boolean.class);
    public static final ConfigKey AUTOMAIL_WHEN_RED_DEADLINE_THRESHOLD_PASSED = new ConfigKey("mail.warningthreshold.red.deadline", "false", Boolean.class);
    public static final ConfigKey EMAIL_FILE_FILTER = new ConfigKey("email.filefilter", "{\"xlsm\":\"full\"}", HashMap.class);
    public static final ConfigKey EMAIL_INTERNAL_ADDRESSES_LIST = new ConfigKey("email.internaladdresses", "[]", ArrayList.class);
    public static final ConfigKey EMAIL_INTERNAL_ADDRESSES_IS_WHITELIST = new ConfigKey("email.internaladdresses.whitelist", "false", Boolean.class);
    public static final ConfigKey JTAPI_PROVIDER = new ConfigKey("jtapi.provider", "", String.class);
    public static final ConfigKey JTAPI_PEER = new ConfigKey("jtapi.peer", "", String.class);
    public static final ConfigKey JTAPI_NATIONALVW = new ConfigKey("jtapi.nationlVW", "", String.class);
    public static final ConfigKey JTAPI_LOCALVW = new ConfigKey("jtapi.localVW", "", String.class);
    public static final ConfigKey JTAPI_BASIS_RUF_NR = new ConfigKey("jtapi.basisRufnr", "", String.class);
    public static final ConfigKey JTAPI_DISPATCHERS_ONLY = new ConfigKey("jtapi.dispatchersOnly", "false", Boolean.class);
    public static final ConfigKey TRIGGER_FILES = new ConfigKey("triggerFiles", "{}", HashMap.class);
    public static final ConfigKey SPLASH_FILE = new ConfigKey("splashFile", "", String.class);
    public static final ConfigKey LOGO_FILE = ConfigKey.IMPRINT_LOGO_URL;
    public static final ConfigKey THEME = new ConfigKey("theme", "", String.class);
    public static final ConfigKey FREIFELDER = new ConfigKey("freifelder", "[]", FreifeldSettingList.class);
    public static final ConfigKey ADDITIONAL_DEVICE_COLUMN = new ConfigKey("AdditionalDeviceColumn", null, String.class);
    public static final ConfigKey CLIENT_HOSTNAME = new ConfigKey("Client_Hostname", null, String.class);
    public static final ConfigKey CLIENT_CONFIG_FILE = new ConfigKey("clientConfigFile", null, String.class);
    public static final ConfigKey REQUEST_CONDITION_FILE = new ConfigKey("requestConditionFile", null, String.class);
    public static final ConfigKey ESCALATION_WARNING_ACTION = new ConfigKey("escalationWarningAction", "-1", Integer.class);
    public static final ConfigKey CLIENT_START_OPTION = new ConfigKey("clientstartoption", "536875008", Integer.class);
    public static final ConfigKey CLIENT_TREE_CONFIG = new ConfigKey("clienttreeconfig", "tblBuendel.BunFeld1", String.class);
    public static final ConfigKey CLIENT_MAX_HEAP_SIZE = new ConfigKey("clientMaxHeapSize", null, Integer.class);
    @Deprecated
    public static final ConfigKey DB_AUTH = new ConfigKey("DB_Auth", "0", Integer.class);
    public static final ConfigKey MAIL_BEENDEN_USER = new ConfigKey("mail.beenden.user", "false", Boolean.class);
    public static final ConfigKey EXTENDED_STATE_EVENTS = new ConfigKey("extendedStateEvents", "false", Boolean.class);
    public static final ConfigKey MAIL_HOST = ConfigKey.MAIL_SMTPHOST;
    public static final ConfigKey MAIL_AUTORISIERUNG_USER = new ConfigKey("mail.autorisierung.user", "false", Boolean.class);
    public static final ConfigKey MAIL_ANFRAGEN_USER = new ConfigKey("mail.anfragen.user", "false", Boolean.class);
    public static final ConfigKey MAIL_SENDER_ADD_ALIAS = new ConfigKey("mail.sender.addalias", "false", Boolean.class);
    public static final ConfigKey SPERRLIST = new ConfigKey("sperrlist", "", String.class);
    public static final ConfigKey CLIENT_MAIL = new ConfigKey("ClientMail", "", String.class);
    public static final ConfigKey USER_ACCESS_FILTER = new ConfigKey("UserAccessFilter", "0", Integer.class);
    public static final ConfigKey OUTGOING_MAIL_HEADERS = new ConfigKey("mailheaders", "{}", OutgoingMailHeaderMap.class);
    public static final ConfigKey GERAETE_VERERBUNG = new ConfigKey("geraete.vererbung", "false", Boolean.class);
    public static final ConfigKey LDAP_CONNECTION_INFOS = new ConfigKey("ldapConnectionInfos", "{}", LdapConnectionInfoMap.class);
    public static final ConfigKey USER_IMPORT_CONFIGS = new ConfigKey("userImportConfigs", "{}", UserImportConfigInfoMap.class);
    public static final ConfigKey DEVICE_IMPORT_CONFIGS = new ConfigKey("deviceImportConfigs", "{}", DeviceImportConfigInfoMap.class);
    public static final ConfigKey PARAM_START_TAG = new ConfigKey("paramStartTag", "", String.class);
    public static final ConfigKey PARAM_END_TAG = new ConfigKey("paramEndTag", "", String.class);
    public static final ConfigKey MAIL_USE_RECEIVED_DATE = new ConfigKey("mail.useReceivedDate", "true", Boolean.class);
    public static final ConfigKey RES_MAIL_NO_STATUS_CHANGED = new ConfigKey("resMailNoStatusChange", "false", Boolean.class);
    public static final ConfigKey DEFAULT_USER_LOCATION_ID = new ConfigKey("default.user.customer", "0", Integer.class);
    public static final ConfigKey DEFAULT_TICKET_ITIL_ID = new ConfigKey("default.ticket.itilid", "0", Integer.class);
    public static final String DEFAULT_TICKET_FONT_NAME_KEY = "default.ticket.font.name";
    public static final ConfigKey DEFAULT_TICKET_FONT_NAME = new ConfigKey("default.ticket.font.name", "Arial", String.class);
    public static final ConfigKey DEFAULT_TICKET_FONT_SIZE = new ConfigKey("default.ticket.font.size", "10", Integer.class);
    public static final ConfigKey DEFAULT_TICKET_REACTIVATION_TIME = new ConfigKey("default.ticket.reactivation", "14", Integer.class);
    public static final ConfigKey DEFAULT_EMAIL_SEND_CLOSE_TIME = new ConfigKey("default.email.closeafter", "14", Integer.class);
    public static final ConfigKey DEFAULT_RESUBMISSION_TIME = new ConfigKey("default.resubmission.days", "7", Integer.class);
    public static final ConfigKey DEFAULT_TICKET_PLAINTEXT_REASTEP = new ConfigKey("default.ticket.plaintext", "false", Boolean.class);
    public static final ConfigKey DEFAULT_COMPANY_ADDRESS = new ConfigKey("default.company.description", "", String.class);
    public static final ConfigKey CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS = new ConfigKey("client.enduser.visibleticketfields", "[]", List.class);
    public static final ConfigKey CLIENT_ENDUSER_SHOWBEARBEITER;
    public static final ConfigKey CLIENT_EFFORTTIME_CONFIG;

    static {
        ArrayList<String> allowedFieldKeys = new ArrayList<String>();
        allowedFieldKeys.add("ticketid");
        allowedFieldKeys.add(Tickets.ATTRIBUTE_ATTACHMENTS.getKey());
        allowedFieldKeys.add(Tickets.ATTRIBUTE_STATUS_ID.getKey());
        allowedFieldKeys.add(Tickets.FIELD_SUBJECT.getKey());
        allowedFieldKeys.add(Tickets.FIELD_RESOURCE_GUID.getKey());
        allowedFieldKeys.add(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey());
        String json = new Json().toJson(allowedFieldKeys);
        CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS.setDefault(json);
        CLIENT_ENDUSER_SHOWBEARBEITER = new ConfigKey("client.enduser.showbearbeiter", "false", Boolean.class);
        CLIENT_EFFORTTIME_CONFIG = new ConfigKey("clientefforttimeconfig", null, Integer.class);
    }
}

