/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.util.List;

public class MySQLPatcher
implements IModelComparator {
    @Override
    public Node compare(Node source, Node target, DatabaseInfos sourceInfos, DatabaseInfos targetInfos) {
        return this.compare(source, target);
    }

    private Node compare(Node source, Node target) {
        if (source.getName() == target.getName()) {
            List<? extends Node> children;
            if (source.getName() == NodeFactory.TAG.table && source.getName() == NodeFactory.TAG.table) {
                String name = IDatabaseInfos.TABLE_PARAM.name.name();
                source.readParameter(name, target.getParameter(name));
            }
            if (source.getName() == NodeFactory.TAG.column && source.getName() == NodeFactory.TAG.column) {
                String defaultValue = source.getParameter(IDatabaseInfos.COLUMN_PARAM.column_def.name());
                if (defaultValue != null && ("getdate()".equalsIgnoreCase(defaultValue) || "SYSDATE".equalsIgnoreCase(defaultValue))) {
                    source.dropParameter(IDatabaseInfos.COLUMN_PARAM.column_def.name());
                }
                if ("true".equals(target.getParameter(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name()))) {
                    source.readParameter(IDatabaseInfos.COLUMN_PARAM.isautoincrement.name(), "true");
                }
                if ("Date".equalsIgnoreCase(source.getParameter(IDatabaseInfos.COLUMN_PARAM.type_name.name()))) {
                    source.readParameter(IDatabaseInfos.COLUMN_PARAM.type_name.name(), target.getParameter(IDatabaseInfos.COLUMN_PARAM.type_name.name()));
                }
                String name = IDatabaseInfos.COLUMN_PARAM.column_name.name();
                source.readParameter(name, target.getParameter(name));
            }
            if ((children = source.getAllChildren()) != null) {
                for (Node node : children) {
                    Node tChild = target.findChildMatching(node.getKeyValueLowerCase(), node.getName());
                    if (tChild == null) continue;
                    this.compare(node, tChild);
                }
            }
        }
        return source;
    }
}

