/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseAlterColumnCommand
implements ITableCommand {
    protected List<Node> getAllRefs(Node column, boolean onTable) {
        String refColumn = onTable ? null : column.getParameter(IDatabaseInfos.COLUMN_PARAM.column_name.name());
        String refTable = column.getParent().getParameter(IDatabaseInfos.TABLE_PARAM.name.name());
        Node thisTable = column.getParent();
        Node database = thisTable.getParent();
        List<? extends Node> allTables = database.getDiffSource().getChildren(NodeFactory.TAG.table);
        HashMap<String, Node> sourceRefs = new HashMap<String, Node>();
        for (Node node : allTables) {
            Node node2 = this.getReferenceBind(node, refColumn, refTable);
            if (node2 == null) continue;
            sourceRefs.put(node2.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name()), node2);
        }
        allTables = database.getDiffTarget().getChildren(NodeFactory.TAG.table);
        HashMap<String, Node> targetRefs = new HashMap<String, Node>();
        for (Node node : allTables) {
            Node ref = this.getReferenceBind(node, refColumn, refTable);
            if (ref == null) continue;
            targetRefs.put(ref.getParameter(IDatabaseInfos.REFERENCE_PARAM.fk_name.name()), ref);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Map.Entry e : sourceRefs.entrySet()) {
            if (!targetRefs.containsKey(e.getKey())) continue;
            arrayList.add((Node)e.getValue());
        }
        return arrayList;
    }

    private Node getReferenceBind(Node table, String refColumn, String refTable) {
        List<? extends Node> refs = table.getChildren(NodeFactory.TAG.reference);
        if (refs == null || refs.size() == 0) {
            return null;
        }
        for (Node node : refs) {
            if (refColumn != null && !refColumn.equalsIgnoreCase(node.getParameter(IDatabaseInfos.REFERENCE_PARAM.pkcolumn_name.name())) || !refTable.equalsIgnoreCase(node.getParameter(IDatabaseInfos.REFERENCE_PARAM.pktable_name.name()))) continue;
            return node;
        }
        return null;
    }
}

