/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases;

import com.inet.dbupdater.data.ListResultSet;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.OracleCommandFactory;
import com.inet.dbupdater.databases.modelpatch.IModelPatcher;
import com.inet.dbupdater.databases.modelpatch.OracleModelPatcher;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.NodeReference;
import com.inet.dbupdater.model.OraclePatcher;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

public class DatabaseInfosOracle
extends DatabaseInfos {
    private static final String[] COLUMN_NAMES = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
    private static final int[] COLUMN_TYPES = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 4, 4, 4, 12, 12, 4};
    private Map<String, List<Object[]>> allReferences;

    public DatabaseInfosOracle(DBConnection dbcon) {
        super(dbcon);
    }

    @Override
    protected IModelPatcher createModelPatcher() {
        return new OracleModelPatcher();
    }

    @Override
    protected ICommandFactory createCommandFactory() {
        return new OracleCommandFactory(this);
    }

    @Override
    public String getDefaultSchema() {
        String dbname = this.getDBConnection().getDatabaseName();
        if (dbname != null) {
            return dbname.toUpperCase();
        }
        return this.getDBConnection().getJdbcUser().toUpperCase();
    }

    @Override
    public String checkIndexName(String indexName) {
        return indexName.length() > 30 ? indexName.substring(0, 30) : indexName;
    }

    @Override
    public String getDestDataType(int datatype, int size, int scale, String originalName, boolean identity) throws SQLException {
        switch (datatype) {
            case -7: {
                return "number(1)";
            }
            case -6: {
                return "number(" + size + ")";
            }
            case 5: {
                return "number(" + size + ")";
            }
            case -5: {
                return "number(" + size + ")";
            }
            case 3: 
            case 7: 
            case 8: {
                return "number(" + size + "," + scale + ")";
            }
            case -1: {
                return "long varchar";
            }
            case -3: {
                return "raw(" + size + ")";
            }
            case -4: {
                return "long raw";
            }
            case 4: {
                return "number(" + size + ")";
            }
            case 93: {
                if (size == 7) {
                    return "date";
                }
                return "timestamp";
            }
            case 92: {
                return "date";
            }
            case -8: {
                return "varchar2(" + size + ")";
            }
            case -9: {
                return "varchar2(" + size + ")";
            }
            case -10: {
                return "long varchar";
            }
            case -11: {
                return "uniqueidentifer";
            }
            case -16: {
                return "long varchar";
            }
        }
        return super.getDestDataType(datatype, size, scale, originalName, identity);
    }

    @Override
    public IModelComparator getModelPatchComparator() {
        return new OraclePatcher();
    }

    @Override
    public String translateDefault(String def, int datatype) {
        int idx = (def = def.trim()).toLowerCase().replace('\n', ' ').replace('\t', ' ').indexOf(" as ");
        if (idx > 0) {
            def = def.substring(idx + 4);
        }
        def = this.removeStartingAndEndingCharacter('\'', '\'', def);
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProcedure(int type, String name) throws SQLException {
        PreparedStatement pr = this.getDBConnection().prepareStatement("SELECT TYPE FROM all_source WHERE NAME = ? AND OWNER = ?");
        try {
            pr.setString(1, name);
            pr.setString(2, this.getDefaultSchema());
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                String string = rs.getString("TYPE");
                boolean bl = string != null && string.trim().equalsIgnoreCase("PROCEDURE");
                return bl;
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
        }
        finally {
            this.getDBConnection().close(pr);
        }
        return super.isProcedure(type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readFunction(String cat, String schema, String name) throws SQLException {
        PreparedStatement pr = null;
        pr = this.getDBConnection().prepareStatement("SELECT TEXT FROM all_source WHERE TYPE='FUNCTION' AND NAME = ? AND OWNER = ? ORDER BY LINE");
        pr.setString(1, name);
        pr.setString(2, schema);
        StringBuffer buffer = new StringBuffer();
        try {
            ResultSet rs = pr.executeQuery();
            while (rs.next()) {
                buffer.append(rs.getString("TEXT"));
            }
        }
        finally {
            this.getDBConnection().close(pr);
        }
        if (buffer.length() == 0) {
            throw new SQLException("Column 'TEXT' (FUNCTION) not found for " + name);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readProcedure(String cat, String schema, String name) throws SQLException {
        PreparedStatement pr = null;
        pr = this.getDBConnection().prepareStatement("SELECT TEXT FROM all_source WHERE TYPE='PROCEDURE' AND NAME = ? AND OWNER = ? ORDER BY LINE");
        pr.setString(1, name);
        pr.setString(2, schema);
        StringBuffer buffer = new StringBuffer();
        try {
            ResultSet rs = pr.executeQuery();
            while (rs.next()) {
                buffer.append(rs.getString("TEXT"));
            }
        }
        finally {
            this.getDBConnection().close(pr);
        }
        if (buffer.length() == 0) {
            throw new SQLException("Column 'TEXT' (PROCEDURE) not found for " + name);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readView(String cat, String schema, String name) throws SQLException {
        PreparedStatement pr = this.getDBConnection().prepareStatement("SELECT TEXT FROM ALL_VIEWS WHERE VIEW_NAME = ? AND OWNER = ?");
        try {
            pr.setString(1, name);
            pr.setString(2, schema);
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                String string = rs.getString("TEXT");
                return string;
            }
        }
        finally {
            this.getDBConnection().close(pr);
        }
        throw new SQLException("View TEXT not found for " + name);
    }

    @Override
    public ResultSet getTriggers() throws SQLException {
        return this.getDBConnection().executeQuery("SELECT OWNER \"Schema\", TRIGGER_NAME \"Trigger\", TRIGGER_TYPE \"Timing\", TRIGGERING_EVENT \"Event\", TABLE_NAME \"Table\", TRIGGER_BODY \"Statement\" FROM all_triggers WHERE OWNER = '" + this.getDefaultSchema() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserEntry(String name) throws SQLException {
        PreparedStatement pr = this.getDBConnection().prepareStatement("SELECT count(NAME) FROM ALL_SOURCE WHERE NAME = ? AND OWNER = ? AND TYPE IN ('PROCEDURE', 'FUNCTION')");
        try {
            pr.setString(1, name);
            pr.setString(2, this.getDefaultSchema());
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(1) >= 1;
                return bl;
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
        }
        finally {
            this.getDBConnection().close(pr);
        }
        return super.isUserEntry(name);
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="constant sql")
    public ResultSet getSequences() throws SQLException {
        return this.getDBConnection().createStatement().executeQuery("SELECT * FROM all_sequences WHERE SEQUENCE_OWNER = '" + this.getDefaultSchema() + "'");
    }

    @Override
    @SuppressFBWarnings(value={"EXTERNAL_CONFIG_CONTROL", "SQL_INJECTION_JDBC"}, justification="access only possible with server credentials")
    public void activateDatabase(DBConnection wrappedConnection, Connection connection, String databaseName) throws SQLException {
        String statement = "ALTER SESSION SET CURRENT_SCHEMA = " + databaseName;
        if (wrappedConnection != null) {
            wrappedConnection.execute(statement);
        } else {
            try (Statement stm = connection.createStatement();){
                stm.execute(statement);
            }
        }
        connection.setCatalog(databaseName);
    }

    @Override
    public String getDBMSTypeName() {
        return "Oracle";
    }

    @Override
    public String getDefaultStringByType(int type) {
        switch (type) {
            case 91: 
            case 92: 
            case 93: {
                return "SYSDATE";
            }
        }
        return super.getDefaultStringByType(type);
    }

    @Override
    public int getTypeID() {
        return 5;
    }

    @Override
    public String getOnChangeDirective(IDatabaseInfos.REFERENCE_PARAM type, NodeReference.onChange action) {
        if (type == null || action == null) {
            return "";
        }
        if (type == IDatabaseInfos.REFERENCE_PARAM.ondelete) {
            StringBuilder b = new StringBuilder();
            b.append(" ON DELETE ");
            switch (action) {
                case cascade: 
                case setnull: {
                    b.append(action.toString());
                    break;
                }
                case noaction: 
                case restrict: {
                    return "";
                }
                case setdefault: {
                    b.append(NodeReference.onChange.setnull.toString());
                }
            }
            return b.toString();
        }
        return "";
    }

    @Override
    public String getDefaultForOnChange(IDatabaseInfos.REFERENCE_PARAM type) {
        switch (type) {
            case onupdate: {
                return null;
            }
        }
        return super.getDefaultForOnChange(type);
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        Connection connection = this.getDBConnection().getConnection();
        try (Statement s = connection.createStatement();
             ResultSet rs = s.executeQuery("SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') FROM DUAL");){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        return super.getCurrentSchema();
    }

    @Override
    public ResultSet getForeignKeys(String catalog, String schema, String table) throws SQLException {
        if (this.allReferences == null) {
            String query = "  select '' as PKTABLE_CAT, c.owner as PKTABLE_SCHEM, c.table_name as PKTABLE_NAME, c.column_name as PKCOLUMN_NAME,'' as FKTABLE_CAT, b.owner as FKTABLE_SCHEM, b.table_name as FKTABLE_NAME, b.column_name as FKCOLUMN_NAME,b.position as KEY_SEQ,0 as UPDATE_RULE,case when a.delete_rule = 'NO ACTION' then 3 when lower(a.delete_rule) = 'noaction' then 3 when a.delete_rule = 'CASCADE' then 0 end as DELETE_RULE,a.constraint_name as FK_NAME,a.r_constraint_name as PK_NAME,case when a.deferrable = 'NOT DEFERFABLE' then 7 else 6 end as DEFERRABILITY    from all_cons_columns b,          all_cons_columns c,          all_constraints a    where b.constraint_name = a.constraint_name      and a.owner           = b.owner      and b.position        = c.position      and c.constraint_name = a.r_constraint_name      and c.owner           = a.r_owner      and a.constraint_type = 'R'      and c.owner      like ?";
            this.allReferences = new HashMap<String, List<Object[]>>();
            try (PreparedStatement stm = this.getDBConnection().getConnection().prepareStatement(query);){
                stm.setString(1, schema);
                try (ResultSet rs = stm.executeQuery();){
                    while (rs.next()) {
                        Object[] data = new Object[COLUMN_NAMES.length];
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = rs.getObject(i + 1);
                        }
                        String key = rs.getString(7);
                        List<Object[]> references = this.allReferences.get(key);
                        if (references == null) {
                            references = new ArrayList<Object[]>();
                            this.allReferences.put(key, references);
                        }
                        references.add(data);
                    }
                }
            }
        }
        ListResultSet result = new ListResultSet();
        ArrayList references = this.allReferences.get(table);
        result.setValues(references != null ? references : new ArrayList());
        result.setColumns(COLUMN_NAMES);
        result.setColumnTypes(COLUMN_TYPES);
        return result;
    }
}

