/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.api;

import com.inet.annotations.InternalApi;
import com.inet.help.api.utils.NodeIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;

@InternalApi
public class HelpPageManipulationMethods {
    private static final Pattern q = Pattern.compile("h(\\d+)");

    public static boolean isHeaderNode(Element node) {
        return node.tagName().matches("h\\d+");
    }

    public static boolean isSameOrHigherHeaderNumber(Element headerNode, Element next) {
        if (!HelpPageManipulationMethods.isHeaderNode(next)) {
            return false;
        }
        int n = HelpPageManipulationMethods.getHeaderNumber(headerNode);
        int n2 = HelpPageManipulationMethods.getHeaderNumber(next);
        return n != -1 && n2 != -1 && n >= n2;
    }

    public static int getHeaderNumber(Element node) {
        Matcher matcher = q.matcher(node.tagName());
        if (matcher.matches()) {
            return Integer.valueOf(matcher.group(1));
        }
        return -1;
    }

    public static Element findLastMostOuterElementOfSection(Element headerNode) {
        List<Element> list = HelpPageManipulationMethods.getMostOuterSectionNodes(headerNode);
        return list.get(list.size() - 1);
    }

    public static List<Element> getMostOuterSectionNodes(Element headerNode) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = headerNode;
        arrayList.add(element);
        while ((element = element.nextElementSibling()) != null && !HelpPageManipulationMethods.a(headerNode, element, null)) {
            arrayList.add(element);
        }
        return arrayList;
    }

    public static List<Element> getSectionNodesWithText(Element headerNode) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = headerNode;
        while (headerNode != null && !HelpPageManipulationMethods.isHeaderNode(element)) {
            if (element.ownText().length() > 0 || "img".equalsIgnoreCase(element.nodeName().trim())) {
                arrayList.add(element);
            } else {
                List<Element> list = HelpPageManipulationMethods.getSectionNodesWithText(element.children().first());
                if (list.size() > 0) {
                    arrayList.add(element);
                }
            }
            if ((element = element.nextElementSibling()) != null) continue;
        }
        return arrayList;
    }

    public static Element getParentNotContainingOtherHeaderWithSameOrHigherLevel(Element headerNode) {
        Element element;
        Element element2 = element = headerNode;
        while ((element = element.parent()) != null) {
            if (HelpPageManipulationMethods.a(headerNode, element, headerNode)) {
                return element2;
            }
            if (element.tagName().equalsIgnoreCase("body") || element.tagName().equalsIgnoreCase("html")) {
                return element2;
            }
            element2 = element;
        }
        return element2;
    }

    private static boolean a(Element element, Element element2, Element element3) {
        if (element2 == element3) {
            return false;
        }
        if (HelpPageManipulationMethods.isSameOrHigherHeaderNumber(element, element2)) {
            return true;
        }
        String string = element2.attr("class");
        if (string != null && string.contains("clearer")) {
            return true;
        }
        for (Element element4 : element2.children()) {
            if (!HelpPageManipulationMethods.a(element, element4, element3)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameHeaderLevel(Element node, Element secondNode) {
        int n = HelpPageManipulationMethods.getHeaderNumber(node);
        int n2 = HelpPageManipulationMethods.getHeaderNumber(secondNode);
        return n != -1 && n2 != -1 && n == n2;
    }

    public static void removeSectionNodes(Element headerNode, NodeIterator nodeIterator) {
        List<Element> list = HelpPageManipulationMethods.getMostOuterSectionNodes(headerNode);
        nodeIterator.moveTo(list.get(list.size() - 1));
        nodeIterator.remove();
        list.remove(list.size() - 1);
        for (Element element : list) {
            element.remove();
        }
    }
}

