/*
 * Decompiled with CFR 0.152.
 */
package com.inet.help.content.processing.osslicenses;

import com.inet.annotations.JsonData;
import com.inet.classloader.BaseLocator;
import com.inet.help.api.model.VirtualHelpPage;
import com.inet.help.content.processing.osslicenses.a;
import com.inet.help.content.processing.osslicenses.c;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@JsonData
public class OpenSourceSoftwareListGeneratorHelpPage
extends VirtualHelpPage {
    private static final String OSS_SEPARATOR = "-\u00a7\u00a7\u00a7-";
    private String specificKey = null;

    public OpenSourceSoftwareListGeneratorHelpPage() {
        this("open-source-components-licenses");
    }

    private OpenSourceSoftwareListGeneratorHelpPage(String key) {
        this.specificKey = key;
    }

    @Nonnull
    public String getExtensionName() {
        return "open-source-components-licenses";
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.specificKey;
    }

    @Override
    public String getPageKeyForUrl(String url, Locale locale) {
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        if (url.startsWith("open-source-components-licenses")) {
            return url.replaceAll("/", OSS_SEPARATOR);
        }
        return null;
    }

    @Override
    @Nonnull
    public String getTitle() {
        return "open-source-components-licenses";
    }

    @Override
    public boolean isKeyFromPage(@Nonnull String key, Locale locale) {
        return key.startsWith("open-source-components-licenses") && key.split(OSS_SEPARATOR).length == 3;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The file location is fixed by the system. User input is verified against a well known location.")
    public URL getResourceForName(String name) {
        block10: {
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (name.startsWith("open-source-components-licenses") && name.split(OSS_SEPARATOR).length == 3) {
                String[] stringArray = name.split(OSS_SEPARATOR);
                String string = stringArray[1];
                String string2 = stringArray[2];
                try {
                    if (!a.b(string, string2)) {
                        return null;
                    }
                    if ("core".equals(string)) {
                        File file = new File(BaseLocator.getBaseDirectory().getAbsolutePath(), "licenses/" + string2);
                        if (file.getCanonicalPath().startsWith(BaseLocator.getBaseDirectory().getAbsolutePath() + "/licenses/")) {
                            return file.toURI().toURL();
                        }
                        break block10;
                    }
                    if ("persistence".equals(string)) {
                        ResourceFile resourceFile = OpenSourceSoftwareListGeneratorHelpPage.getPersistenceLicenseFile(string2);
                        if (resourceFile == null) {
                            return null;
                        }
                        File file = new File(resourceFile.getAbsolutePath());
                        if (file.getCanonicalPath().startsWith(BaseLocator.getBaseDirectory().getAbsolutePath() + "/plugins/persistence/")) {
                            return file.toURI().toURL();
                        }
                        break block10;
                    }
                    ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
                    c c2 = new c((VirtualFile)serverPluginManager.getPluginFile(string, string2));
                    return c2.getURL();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    protected static ResourceFile getPersistenceLicenseFile(String name) {
        ResourceFile resourceFile = BaseLocator.getBaseDirectory().createChild("plugins").createChild("persistence");
        if (!resourceFile.exists() || !resourceFile.isDirectory()) {
            return null;
        }
        for (ResourceFile resourceFile2 : resourceFile.listFiles()) {
            ResourceFile resourceFile3;
            if (!resourceFile2.isDirectory() || !resourceFile2.getName().endsWith("licenses") || !(resourceFile3 = resourceFile2.createChild(name)).exists()) continue;
            return resourceFile3;
        }
        return null;
    }

    @Override
    public VirtualHelpPage getSpecificHelpPage(@Nonnull String key, Locale locale) {
        return new OpenSourceSoftwareListGeneratorHelpPage(key);
    }

    @Override
    public boolean showInToc() {
        return false;
    }
}

