/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.jar.JarFileObject;

public class JarURLConnectionImpl
extends JarURLConnection {
    private static final String HACK_URL = "jar:http://somehost/somejar.jar!/";
    private final FileContent fileContent;
    private final URL parentURL;
    private final JarFileObject jarFileObject;
    private final String entryName;

    public JarURLConnectionImpl(JarFileObject jarFileObject, FileContent fileContent) throws MalformedURLException, FileSystemException {
        super(new URL(HACK_URL));
        this.url = jarFileObject.getURL();
        this.fileContent = fileContent;
        this.parentURL = jarFileObject.getURL();
        this.entryName = jarFileObject.getName().getPath();
        this.jarFileObject = jarFileObject;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public Attributes getAttributes() throws IOException {
        return this.jarFileObject.getAttributes();
    }

    @Override
    public Certificate[] getCertificates() {
        return this.jarFileObject.doGetCertificates();
    }

    @Override
    public int getContentLength() {
        try {
            return (int)this.fileContent.getSize();
        }
        catch (FileSystemException ignored) {
            return -1;
        }
    }

    @Override
    public String getEntryName() {
        return this.entryName;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.fileContent.getInputStream();
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-entry-no-access.error");
    }

    @Override
    public JarFile getJarFile() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-file-no-access.error");
    }

    @Override
    public URL getJarFileURL() {
        return this.parentURL;
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFileObject.getManifest();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.fileContent.getOutputStream();
    }
}

