/*
 * Decompiled with CFR 0.152.
 */
package com.inet.ftp.taskplanner;

import com.inet.annotations.PublicApi;
import com.inet.ftp.shared.b;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class FtpResultActionBuilder {
    private Map<String, String> af = new HashMap<String, String>();

    public static FtpResultActionBuilder createFTPConnection() {
        FtpResultActionBuilder ftpResultActionBuilder = new FtpResultActionBuilder();
        ftpResultActionBuilder.af.put("protocol", "ftp");
        ftpResultActionBuilder.af.put("portftp", "21");
        ftpResultActionBuilder.af.put("portftps", "990");
        ftpResultActionBuilder.af.put("portsftp", "22");
        return ftpResultActionBuilder;
    }

    public FtpResultActionBuilder setServerURL(String serverURL) {
        this.af.put("server", serverURL);
        return this;
    }

    public FtpResultActionBuilder setUserLogin(String username, String password) {
        this.af.put("username", username);
        this.af.put("password", password);
        this.af.put("logintype", b.a.T.toString());
        return this;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="An empty password is used for anonymous logins")
    public FtpResultActionBuilder setAnonymousLogin() {
        this.af.put("username", "anonymous");
        this.af.put("password", "");
        this.af.put("logintype", b.a.S.toString());
        return this;
    }

    public FtpResultActionBuilder setServerPath(String serverPath) {
        this.af.put("path", serverPath);
        return this;
    }

    public FtpResultActionBuilder setServerPort(int serverPort) {
        this.af.put("portftp", String.valueOf(serverPort));
        this.af.put("portsftp", String.valueOf(serverPort));
        this.af.put("portftps", String.valueOf(serverPort));
        return this;
    }

    public FtpResultActionBuilder setServerProtocol(String securityType) {
        if (securityType != null && (securityType.equalsIgnoreCase("sftp") || securityType.equalsIgnoreCase("ftps") || securityType.equalsIgnoreCase("ftpes"))) {
            this.af.put("protocol", securityType);
        } else {
            this.af.put("protocol", "ftp");
        }
        return this;
    }

    public FtpResultActionBuilder setFileNameFormat(String fileNameFormat) {
        this.af.put("filenameformat", fileNameFormat);
        return this;
    }

    public ResultActionDefinition create() {
        ResultActionDefinition resultActionDefinition = new ResultActionDefinition("result.ftp");
        Set<String> set = this.af.keySet();
        for (String string : set) {
            resultActionDefinition.setProperty(string, this.af.get(string));
        }
        return resultActionDefinition;
    }
}

