/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.texttransform;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.filter.texttransform.TextTransformPlugin;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.util.EnumParser;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public class TextTransformFilter
extends SortFilterBase {
    public static final String FILTER_NAME = "TEXTTRANSFORM";
    private static final Map<com.inet.pdfc.filter.texttransform.a, a> a = new HashMap<com.inet.pdfc.filter.texttransform.a, a>();
    private FilterHighlights b = new FilterHighlights();
    public static final Map<Integer, char[]> REPLACE_MAP;
    private List<com.inet.pdfc.filter.texttransform.a> c = new ArrayList<com.inet.pdfc.filter.texttransform.a>();

    public TextTransformFilter() {
        super(FILTER_NAME);
    }

    public ISortFilter setProfile(IProfile profile) {
        List list = EnumParser.getConfiguredValues((IProfile)profile, TextTransformPlugin.TRANSFORM_OPERATIONS, com.inet.pdfc.filter.texttransform.a.class);
        this.c.clear();
        for (com.inet.pdfc.filter.texttransform.a a2 : com.inet.pdfc.filter.texttransform.a.values()) {
            if (!list.contains((Object)a2)) continue;
            this.c.add(a2);
        }
        return this;
    }

    public List<DrawableElement> sortOrFilterPage(int pageNr, List<DrawableElement> pageElements, boolean first, List<CompareDiffGroup> diffGroups) {
        if (this.c.size() == 0) {
            return pageElements;
        }
        for (DrawableElement drawableElement : pageElements) {
            WordElement wordElement;
            if (drawableElement instanceof WordElement) {
                String string;
                wordElement = (WordElement)drawableElement;
                String string2 = string = wordElement.getCompareWord();
                for (com.inet.pdfc.filter.texttransform.a a2 : this.c) {
                    string2 = a.get((Object)a2).transform(string2);
                }
                if (string.equals(string2)) continue;
                wordElement.setWord(string2, true);
                this.b.addMarker(wordElement, string2, pageNr, first);
                continue;
            }
            if (!(drawableElement instanceof StructureElement)) continue;
            wordElement = (StructureElement)drawableElement;
            this.sortOrFilterPage(pageNr, wordElement.getChildren(), first, diffGroups);
        }
        return pageElements;
    }

    public FilterHighlights getHighlightProvider() {
        return this.b;
    }

    public static String getDecomposedString(String input) {
        String string = Normalizer.normalize(input, Normalizer.Form.NFKD);
        if (string.indexOf(32) >= 0) {
            string = string.replace(" ", "");
        }
        return string;
    }

    public static String getReplacedString(String input) {
        String string = Normalizer.isNormalized(input, Normalizer.Form.NFD) ? input : Normalizer.normalize(input, Normalizer.Form.NFD);
        for (int i = 0; i < string.length(); ++i) {
            Integer n = string.codePointAt(i);
            char[] cArray = REPLACE_MAP.get(n);
            if (cArray == null) continue;
            StringBuilder stringBuilder = i > 0 ? new StringBuilder(string.substring(0, i)) : new StringBuilder();
            stringBuilder.append(cArray);
            ++i;
            while (i < string.length()) {
                n = string.codePointAt(i);
                cArray = REPLACE_MAP.get(n);
                if (cArray != null) {
                    stringBuilder.append(cArray);
                } else {
                    stringBuilder.appendCodePoint(n);
                }
                ++i;
            }
            return stringBuilder.toString();
        }
        return input;
    }

    private static Map<Integer, char[]> a(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        HashMap<Integer, char[]> hashMap = new HashMap<Integer, char[]>();
        block4: while (true) {
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    if (string.startsWith("#") || string.length() == 0 || (string = string.trim()).startsWith("#") || string.length() == 0 || (stringArray = string.split("\\s*;\\s*")).length < 2) continue;
                    String string2 = stringArray[0];
                    String[] stringArray2 = stringArray[1].split("\\s+");
                    try {
                        Integer n = (char)Integer.parseInt(string2, 16);
                        char[] cArray = new char[stringArray2.length];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            cArray[i] = (char)Integer.parseInt(stringArray2[i], 16);
                        }
                        hashMap.put(n, cArray);
                        continue block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        PDFCCore.LOGGER_CORE.warn((Object)numberFormatException);
                    }
                }
                break;
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                break;
            }
        }
        return hashMap;
    }

    static {
        a.put(com.inet.pdfc.filter.texttransform.a.e, TextTransformFilter::getReplacedString);
        a.put(com.inet.pdfc.filter.texttransform.a.d, TextTransformFilter::getDecomposedString);
        REPLACE_MAP = TextTransformFilter.a(TextTransformFilter.class.getResourceAsStream("confusables/confusables.txt"));
    }

    @JsonData
    private static class FilterHighlights
    extends BasicHighlightDataImpl {
        private static final Color OUTLINE = new Color(0, 0, 128, 64);

        public FilterHighlights() {
            super(TextTransformFilter.FILTER_NAME);
        }

        public void addMarker(WordElement el, String replace, int page, boolean left) {
            Integer n;
            Rectangle rectangle = LocationUtils.getOutline((PagedElement)el);
            HighlightData.Highlight highlight = new HighlightData.Highlight(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2, replace, HighlightData.Highlight.Appearance.RECTANGLE, OUTLINE);
            HashMap hashMap = left ? this.getFirst() : this.getSecond();
            ArrayList<HighlightData.Highlight> arrayList = (ArrayList<HighlightData.Highlight>)hashMap.get(n = Integer.valueOf(page));
            if (arrayList == null) {
                arrayList = new ArrayList<HighlightData.Highlight>();
                hashMap.put(n, arrayList);
            }
            arrayList.add(highlight);
        }
    }

    private static interface a
    extends Serializable {
        public String transform(String var1);
    }
}

