/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.headerfooter;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.filter.headerfooter.a;
import com.inet.pdfc.generator.comparator.FullElementComparator;
import com.inet.pdfc.generator.comparator.IElementComparator;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.filter.SortFilterBase;
import com.inet.pdfc.generator.filter.headerfooter.ISingleDocumentHFDetector;
import com.inet.pdfc.generator.message.BasicHighlightDataImpl;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.plugin.ProfileHighlighter;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.LocationUtils;
import com.inet.thread.SessionLocator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public class HeaderFooterFilter
extends SortFilterBase
implements ProfileHighlighter {
    public static final String FILTER_NAME = "HEADERFOOTER";
    public static final int MIN_PAGES_BEFORE_RUN = 15;
    public static final int INVALID = -1;
    public static final int INHERIT_FOOTER = -2;
    private int fixedHeader;
    private int fixedFooter;
    private double v = -1.0;
    private double w = -1.0;
    private ISingleDocumentHFDetector x;
    private ISingleDocumentHFDetector y;
    private IElementComparator z;
    private List<@Nonnull DrawableElement> A;
    private boolean B = false;
    private boolean C = false;
    private boolean D = false;
    private boolean E = false;
    private HeaderFooterDetectionResult F = new HeaderFooterDetectionResult(this.getExtensionName());
    private boolean activate = false;

    public HeaderFooterFilter() {
        super(FILTER_NAME);
    }

    public HeaderFooterFilter setProfile(IProfile profile) {
        this.activate = profile.getString(PDFCProperty.FILTERS).toLowerCase().contains(this.getExtensionName().toLowerCase());
        this.fixedHeader = profile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
        this.fixedFooter = profile.getInt(PDFCProperty.FIXED_FOOTER_SIZE);
        this.w = this.v = this.fixedFooter >= 0 ? (double)this.fixedFooter : -1.0;
        this.z = new FullElementComparator(profile);
        this.x = new a(this.fixedHeader, this.fixedFooter, this.getLookAheadWindowSize(), this.z);
        this.y = new a(this.fixedHeader, this.fixedFooter, this.getLookAheadWindowSize(), this.z);
        return this;
    }

    public void reInit(IProfile profile) {
        this.z.init(profile);
    }

    public void setTotalPages(int pageCount, boolean first) {
        ISingleDocumentHFDetector iSingleDocumentHFDetector = first ? this.x : this.y;
        iSingleDocumentHFDetector.setPageCount(pageCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyze(int pageNr, @Nonnull Dimension size, @Nonnull @Nonnull List<@Nonnull DrawableElement> pageElements, boolean first) {
        ISingleDocumentHFDetector iSingleDocumentHFDetector;
        super.analyze(pageNr, size, pageElements, first);
        ISingleDocumentHFDetector iSingleDocumentHFDetector2 = iSingleDocumentHFDetector = first ? this.x : this.y;
        if (pageNr == 0) {
            HeaderFooterFilter headerFooterFilter = this;
            synchronized (headerFooterFilter) {
                if (this.A == null) {
                    this.A = pageElements;
                    if (first) {
                        this.B = true;
                    } else {
                        this.C = true;
                    }
                } else {
                    if (this.fixedFooter < 0) {
                        double[] dArray = this.a(this.A, pageElements);
                        if (dArray != null) {
                            this.v = first ? dArray[1] : dArray[0];
                            this.w = first ? dArray[0] : dArray[1];
                        }
                    } else {
                        this.v = Math.max(0, size.height - this.fixedFooter);
                        this.w = Math.max(0, size.height - this.fixedFooter);
                    }
                    this.A = null;
                    if (first) {
                        this.B = true;
                    } else {
                        this.C = true;
                    }
                    ((Object)((Object)this)).notifyAll();
                }
            }
        } else if (first) {
            this.B = true;
        } else {
            this.C = true;
        }
        iSingleDocumentHFDetector.analyze(pageNr, size, pageElements);
        if (this.D && this.x.hasEnoughPages() || this.E && this.y.hasEnoughPages()) {
            this.F.update(this, this.D && this.x.hasEnoughPages(), this.E && this.y.hasEnoughPages());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DrawableElement> sortOrFilterPage(int pageNr, @Nonnull @Nonnull List<@Nonnull DrawableElement> pageElements, boolean first, List<CompareDiffGroup> diffGroups) {
        ISingleDocumentHFDetector iSingleDocumentHFDetector;
        HeaderFooterFilter headerFooterFilter;
        if (!this.B && !this.C) {
            headerFooterFilter = this;
            synchronized (headerFooterFilter) {
                if (!this.B && !this.C) {
                    try {
                        ((Object)((Object)this)).wait(15000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (first && !this.D) {
            headerFooterFilter = this;
            synchronized (headerFooterFilter) {
                if (first && !this.D) {
                    this.x.runDetector();
                    this.D = true;
                    if (this.x.hasEnoughPages() || this.v != -1.0) {
                        this.F.update(this, true, false);
                    }
                }
            }
        }
        if (!first && !this.E) {
            headerFooterFilter = this;
            synchronized (headerFooterFilter) {
                if (!first && !this.E) {
                    this.y.runDetector();
                    this.E = true;
                    if (this.y.hasEnoughPages() || this.w != -1.0) {
                        this.F.update(this, false, true);
                    }
                }
            }
        }
        double d2 = first ? this.v : this.w;
        ISingleDocumentHFDetector iSingleDocumentHFDetector2 = iSingleDocumentHFDetector = first ? this.x : this.y;
        if (!(this.fixedHeader >= 0 || this.fixedFooter >= 0 || iSingleDocumentHFDetector.hasEnoughPages() || pageNr <= 0 && d2 != -1.0)) {
            return pageElements;
        }
        if (pageNr == 0) {
            if (d2 != -1.0) {
                return this.a(this.b(first), pageElements);
            }
            return pageElements;
        }
        return iSingleDocumentHFDetector.sortOrFilterPage(pageNr, pageElements);
    }

    @Nonnull
    private @Nonnull List<@Nonnull DrawableElement> a(double d2, @Nonnull @Nonnull List<@Nonnull DrawableElement> list) {
        if (d2 < 0.0) {
            return list;
        }
        ArrayList<@Nonnull DrawableElement> arrayList = new ArrayList<DrawableElement>(list.size());
        for (DrawableElement drawableElement : list) {
            if (drawableElement.getType().isStructuralType()) {
                StructureElement structureElement = (StructureElement)drawableElement;
                List<@Nonnull DrawableElement> list2 = this.a(d2, (List<DrawableElement>)structureElement.getChildren());
                if (list2.size() <= 0) continue;
                if (list2.size() != structureElement.getChildren().size()) {
                    @Nonnull Rectangle2D rectangle2D = LocationUtils.getJoinedBounds(list2);
                    structureElement.getChildren().clear();
                    structureElement.getChildren().addAll(list2);
                    structureElement.setBounds(rectangle2D);
                    structureElement.setX(rectangle2D.getX());
                    structureElement.setY(rectangle2D.getY());
                }
                arrayList.add(drawableElement);
                continue;
            }
            double d3 = drawableElement.getY();
            if (!(d3 < d2) || this.fixedHeader > 0 && !(d3 >= (double)this.fixedHeader)) continue;
            arrayList.add(drawableElement);
        }
        return arrayList;
    }

    private double[] a(@Nonnull @Nonnull List<@Nonnull DrawableElement> list, @Nonnull @Nonnull List<@Nonnull DrawableElement> list2) {
        int n;
        int n2 = list.size();
        int n3 = list2.size();
        for (n = n2 - 1; n >= 0 && list.get(n).getType() == ElementType.InternalMarkup; --n) {
            --n2;
        }
        for (n = n3 - 1; n >= 0 && list2.get(n).getType() == ElementType.InternalMarkup; --n) {
            --n3;
        }
        n = Math.min(n2, n3);
        int n4 = n2 - n;
        int n5 = n3 - n;
        boolean bl = false;
        for (int i = n - 1; i >= 0; --i) {
            DrawableElement drawableElement = list.get(i + n4);
            DrawableElement drawableElement2 = list2.get(i + n5);
            if (drawableElement.getType() == ElementType.TextWord && drawableElement2.getType() == ElementType.TextWord && (Math.abs(drawableElement.getY() - drawableElement2.getY()) > 1.0 || Math.abs(drawableElement.getX() - drawableElement2.getX()) > 1.0) || !this.z.isEqual(drawableElement, drawableElement2) || this.a(drawableElement) != 0.0 || this.a(drawableElement2) != 0.0) {
                if (bl) {
                    if (i != n - 1) {
                        DrawableElement drawableElement3 = list.get(i + 1 + n4);
                        DrawableElement drawableElement4 = list2.get(i + 1 + n5);
                        double d2 = drawableElement.getY() == drawableElement3.getY() ? drawableElement.getY() + 0.01 : drawableElement3.getY() - 0.01;
                        double d3 = drawableElement2.getY() == drawableElement4.getY() ? drawableElement2.getY() + 0.01 : drawableElement4.getY() - 0.01;
                        return new double[]{d2, d3};
                    }
                    return new double[]{drawableElement.getY() + 0.01, drawableElement2.getY() + 0.01};
                }
                return null;
            }
            bl = true;
        }
        return new double[]{-2.0, -2.0};
    }

    private boolean a(boolean bl) {
        return this.fixedFooter < 0 && SessionLocator.exists() && Boolean.parseBoolean(PdfcSession.getSession().getSessionProperties().getProperty("SkipFirstPageFooter_" + (bl ? "First" : "Second")));
    }

    private double a(DrawableElement drawableElement) {
        switch (drawableElement.getType()) {
            case Text: 
            case TextLine: 
            case TextWord: 
            case Paragraph: {
                return drawableElement.getRotation();
            }
        }
        return 0.0;
    }

    private double b(boolean bl) {
        double d2 = bl ? this.v : this.w;
        boolean bl2 = this.a(bl);
        if (d2 >= 0.0 && !bl2) {
            return bl ? this.v : this.w;
        }
        if (d2 == -2.0 || bl2) {
            ISingleDocumentHFDetector iSingleDocumentHFDetector = bl ? this.x : this.y;
            return iSingleDocumentHFDetector.getFooterStart(0);
        }
        return -1.0;
    }

    private int a(boolean bl, int n) {
        return (bl ? this.x : this.y).getHeaderEnd(n);
    }

    private int b(boolean bl, int n) {
        int n2 = this.a(bl, n);
        int n3 = (bl ? this.x : this.y).getFooterStart(n);
        return Math.max(n3, n2);
    }

    public HeaderFooterDetectionResult getHighlightProvider() {
        return this.F;
    }

    public int getLookAheadWindowSize() {
        return this.fixedHeader >= 0 && this.fixedFooter >= 0 ? 5 : 15;
    }

    public HighlightData getPageHighlight(IProfile profile, Object value) {
        boolean bl = profile.getString(PDFCProperty.FILTERS).toLowerCase().contains(this.getFilterKey().toLowerCase());
        int n = profile.getInt(PDFCProperty.FIXED_HEADER_SIZE);
        int n2 = profile.getInt(PDFCProperty.FIXED_FOOTER_SIZE);
        return new HeaderFooterHighlightData(this.getExtensionName(), n2, n, value, bl);
    }

    public String getFilterKey() {
        return this.getExtensionName();
    }

    @JsonData
    public static class HeaderFooterDetectionResult
    extends BasicHighlightDataImpl {
        public HeaderFooterDetectionResult(String extensionName) {
            super(extensionName);
        }

        private synchronized void update(HeaderFooterFilter source, boolean updateLeft, boolean updateRight) {
            double d2;
            int n;
            int n2;
            Dimension dimension;
            int n3;
            if (!source.activate) {
                return;
            }
            if (updateLeft) {
                for (n3 = n2 = this.getFirst().size(); n3 < source.getAnalyzedPagesCount(true) && (dimension = source.getPageSize(n3, true)) != null; ++n3) {
                    if (n3 == 0 && this.getSecond().size() > 0) {
                        this.getSecond().put(0, HeaderFooterDetectionResult.createHighlight(source.getPageSize(n3, false), -1, source.b(false)));
                    }
                    if (!source.x.hasEnoughPages()) {
                        return;
                    }
                    n = n3 == 0 ? -1 : source.a(true, n3);
                    d2 = n3 == 0 ? source.b(true) : (double)source.b(true, n3);
                    this.getFirst().put(n3, HeaderFooterDetectionResult.createHighlight(dimension, n, d2));
                }
            }
            if (source.getAnalyzedPagesCount(false) > 0) {
                n2 = this.getSecond().size();
                if (updateRight) {
                    for (n3 = n2; n3 < source.getAnalyzedPagesCount(false); ++n3) {
                        if (n3 == 0 && this.getFirst().size() > 0) {
                            this.getFirst().put(0, HeaderFooterDetectionResult.createHighlight(source.getPageSize(n3, true), -1, source.b(true)));
                        }
                        if (!source.y.hasEnoughPages()) {
                            return;
                        }
                        dimension = source.getPageSize(n3, false);
                        if (dimension == null) break;
                        n = n3 == 0 ? -1 : source.a(false, n3);
                        d2 = n3 == 0 ? source.b(false) : (double)source.b(false, n3);
                        this.getSecond().put(n3, HeaderFooterDetectionResult.createHighlight(dimension, n, d2));
                    }
                }
            }
        }

        private static List<HighlightData.Highlight> createHighlight(Dimension pageSize, int header, double footer) {
            ArrayList<HighlightData.Highlight> arrayList = new ArrayList<HighlightData.Highlight>();
            if (header != -1) {
                arrayList.add(new HighlightData.Highlight(0, 0, pageSize.width, header, "Header", HighlightData.Highlight.Appearance.FILLED_RECTANGLE, Color.GRAY));
            }
            if (footer != -1.0) {
                arrayList.add(new HighlightData.Highlight(0, (int)footer, pageSize.width, pageSize.height - (int)footer, "Footer", HighlightData.Highlight.Appearance.FILLED_RECTANGLE, Color.GRAY));
            }
            return arrayList.isEmpty() ? null : arrayList;
        }
    }

    @JsonData
    private static class HeaderFooterHighlightData
    extends BasicHighlightDataImpl {
        private final int fixedFooter;
        private final int fixedHeader;
        private final Object value;
        private final boolean activate;

        private HeaderFooterHighlightData(String type, int fixedFooter, int fixedHeader, Object value, boolean activate) {
            super(type);
            this.fixedFooter = fixedFooter;
            this.fixedHeader = fixedHeader;
            this.value = value;
            this.activate = activate;
        }

        public List<HighlightData.Highlight> getPageHighlights(int pageNr, boolean firstDocument) {
            ResultModelData resultModelData = (ResultModelData)this.value;
            ResultPage resultPage = resultModelData.getPage(pageNr, firstDocument);
            ArrayList<HighlightData.Highlight> arrayList = new ArrayList<HighlightData.Highlight>();
            if (this.fixedHeader != -1) {
                arrayList.add(new HighlightData.Highlight(0, 0, resultPage.getSize().width, this.fixedHeader, "Custom Header", HighlightData.Highlight.Appearance.FILLED_RECTANGLE, Color.RED));
            }
            if (this.fixedFooter != -1) {
                arrayList.add(new HighlightData.Highlight(0, resultPage.getSize().height - this.fixedFooter, resultPage.getSize().width, this.fixedFooter, "Custom Footer", HighlightData.Highlight.Appearance.FILLED_RECTANGLE, Color.RED));
            }
            return this.activate ? arrayList : new ArrayList<HighlightData.Highlight>();
        }
    }
}

