/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.baselinetable.tatr;

import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.lib.core.OS;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.filter.baselinetable.tatr.b;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;

public class TableTransformerProcess {
    private Process cp;
    private WeakHashMap<b, Long> cw = new WeakHashMap();
    @Nullable
    private Thread cq;
    @Nullable
    private Thread cx;
    private File cr;

    public boolean aT() {
        return this.cp != null && this.cp.isAlive();
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="The command is fixed and gerated by code. There is no user interaction or configuration that may modify this command.")
    public synchronized void aU() throws Exception {
        Object object;
        Object object2;
        if (this.cp != null) {
            this.cp.destroy();
            if (this.cq != null) {
                this.cq.interrupt();
            }
            this.cq = null;
            if (this.cx != null) {
                this.cx.interrupt();
            }
            this.cx = null;
        }
        if (this.cr == null) {
            this.cr = File.createTempFile("TATR", "py");
            object2 = this.getClass().getResourceAsStream("tatr.py");
            try {
                object = new FileOutputStream(this.cr);
                try {
                    IOFunctions.copyData((InputStream)object2, (OutputStream)object);
                }
                finally {
                    ((OutputStream)object).close();
                }
            }
            finally {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
        }
        object2 = OS.isWindows() ? "python.exe" : "python";
        object = new ProcessBuilder(new String[]{object2, "-u", this.cr.getPath(), "0.7"});
        this.cp = ((ProcessBuilder)object).start();
        this.cq = new Thread(() -> {
            Thread.currentThread().setName("Table AI Error Logger");
            try (InputStream inputStream = this.cp.getErrorStream();){
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = inputStream.read()) >= 0) {
                    stringBuilder.append((char)n);
                    if (n != 10) continue;
                    PDFCCore.LOGGER_COMPARE.debug((Object)stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_COMPARE.error((Throwable)iOException);
            }
        });
        this.cq.start();
        this.cx = new Thread(() -> {
            Thread.currentThread().setName("Table AI Event Receiver");
            try {
                InputStream inputStream = this.cp.getInputStream();
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    TransformerResponse transformerResponse = null;
                    while (true) {
                        Object object2;
                        HashMap hashMap;
                        block17: {
                            hashMap = new HashMap();
                            try {
                                transformerResponse = (TransformerResponse)new Json().fromJson((Reader)inputStreamReader, TransformerResponse.class, hashMap);
                            }
                            catch (Exception exception) {
                                PDFCCore.LOGGER_COMPARE.error((Throwable)exception);
                                if (this.cp.isAlive()) break block17;
                                PDFCCore.LOGGER_COMPARE.error((Object)"Table detection process was terminated.");
                                this.cp = null;
                                if (inputStream == null) return;
                                inputStream.close();
                                return;
                            }
                        }
                        if (transformerResponse == null) continue;
                        if (!hashMap.isEmpty()) {
                            PDFCCore.LOGGER_COMPARE.error((Object)("Error while executing the table transformer for page " + transformerResponse.pageIndex));
                            for (Object object2 : hashMap.values()) {
                                for (Map.Entry entry2 : object2.entrySet()) {
                                    PDFCCore.LOGGER_COMPARE.error((Object)((String)entry2.getKey() + ": " + (String)entry2.getValue()));
                                }
                            }
                        }
                        Long l = transformerResponse.id;
                        object2 = this.cw.entrySet().stream().filter(entry -> ((Long)entry.getValue()).equals(l)).map(entry -> (b)entry.getKey()).findFirst().orElse(null);
                        if (object2 == null) {
                            PDFCCore.LOGGER_COMPARE.warn((Object)("Callback ID " + (Long)l + " for table detection is missing. AI table detection for page " + transformerResponse.pageIndex + " is void."));
                            continue;
                        }
                        this.cw.remove(object2);
                        if (PDFCCore.LOGGER_COMPARE.isDebug()) {
                            PDFCCore.LOGGER_COMPARE.debug((Object)("Response TATR for " + Thread.currentThread().getName() + ", page #" + transformerResponse.pageIndex + ", " + (transformerResponse.first ? "first" : "second") + " with ID " + (Long)l));
                        }
                        for (TableData tableData : transformerResponse.tables) {
                            tableData.x -= 20;
                            tableData.y -= 20;
                            TableTransformerProcess.a(0.6666666666666666, tableData);
                            for (CellData cellData : tableData.cells) {
                                cellData.x -= 20;
                                cellData.y -= 20;
                                TableTransformerProcess.a(0.6666666666666666, cellData);
                            }
                        }
                        object2.a(transformerResponse.pageIndex, transformerResponse.first, transformerResponse.tables);
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_COMPARE.error((Throwable)iOException);
                return;
            }
        });
        this.cx.start();
    }

    public static void a(double d2, Rectangle rectangle) {
        if (rectangle == null || d2 == 1.0) {
            return;
        }
        rectangle.x = (int)Math.round((double)rectangle.x * d2);
        rectangle.y = (int)Math.round((double)rectangle.y * d2);
        rectangle.width = (int)Math.round((double)rectangle.width * d2);
        rectangle.height = (int)Math.round((double)rectangle.height * d2);
    }

    public synchronized void a(int n, boolean bl, @Nullable Rectangle rectangle, @Nonnull b b2) throws IOException {
        Object object;
        Object object2;
        int n2;
        Object object3;
        if (this.cp == null || !this.cp.isAlive()) {
            try {
                this.aU();
            }
            catch (Exception exception) {
                ErrorCode.throwAny((Throwable)exception);
            }
        }
        if ((object3 = PdfcSession.getSession().getStoreMap().getPageImage(bl, n, 1.5, 1.5)) == null) {
            b2.a(n, bl, new ArrayList<TableData>());
            return;
        }
        if (rectangle != null) {
            rectangle = LocationUtils.scaleRect((double)1.5, (Rectangle)rectangle);
            Rectangle.intersect(rectangle, new Rectangle(((BufferedImage)object3).getWidth(), ((BufferedImage)object3).getHeight()), rectangle);
            int n3 = rectangle.width;
            n2 = rectangle.height;
            object2 = new BufferedImage(n3 + 40, n2 + 40, 1);
            object = ((BufferedImage)object2).getGraphics();
            ((Graphics)object).setColor(Color.WHITE);
            ((Graphics)object).fillRect(0, 0, ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight());
            ((Graphics)object).drawImage((Image)object3, 20, 20, 20 + n3, 20 + n2, rectangle.x, rectangle.y, rectangle.x + n3, rectangle.y + n2, null);
            object3 = object2;
        }
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        ImageIO.write((RenderedImage)object3, "jpg", (OutputStream)fastByteArrayOutputStream);
        n2 = System.identityHashCode(b2);
        this.cw.put(b2, Long.valueOf(n2));
        object2 = new Json().toJson((Object)new TransformerCall(n, bl, n2, Base64.getEncoder().encodeToString(fastByteArrayOutputStream.toByteArray())));
        object = this.cp.getOutputStream();
        ((OutputStream)object).write(((String)object2).getBytes());
        ((OutputStream)object).write("\n".getBytes());
        ((OutputStream)object).flush();
        if (PDFCCore.LOGGER_COMPARE.isDebug()) {
            PDFCCore.LOGGER_COMPARE.debug((Object)("Request TATR for " + Thread.currentThread().getName() + ", page #" + n + ", " + (bl ? "first" : "second") + " with ID " + n2));
        }
    }

    @JsonData
    private static class TransformerCall {
        private int pageIndex;
        private boolean first;
        private long id;
        private String imageData;

        public TransformerCall(int pageIndex, boolean first, long id, String imageData) {
            this.pageIndex = pageIndex;
            this.first = first;
            this.id = id;
            this.imageData = imageData;
        }
    }

    @JsonData
    private static class TransformerResponse {
        public long id;
        public int pageIndex;
        public boolean first;
        public List<TableData> tables;

        private TransformerResponse() {
        }
    }

    @JsonData
    public static class TableData
    extends Rectangle {
        private double score;
        private String label;
        private List<CellData> cells;

        private TableData() {
        }

        public TableData(@Nonnull Rectangle bounds, double score, @Nullable String label, @Nullable List<CellData> cells) {
            super(bounds);
            this.score = score;
            this.label = label;
            this.cells = cells;
        }

        public double getScore() {
            return this.score;
        }

        @Nullable
        public String getLabel() {
            return this.label;
        }

        @Nullable
        public List<CellData> getCells() {
            return this.cells;
        }
    }

    @JsonData
    public static class CellData
    extends Rectangle {
        private double score;
        private String label;

        public double getScore() {
            return this.score;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public String toString() {
            if (this.label.contains("row")) {
                return "Row: " + (int)this.getMinY() + " : " + (int)this.getMaxY() + " conf: " + this.score;
            }
            if (this.label.contains("column")) {
                return "Col: " + (int)this.getMinX() + " : " + (int)this.getMaxX() + " conf: " + this.score;
            }
            return this.label + ": " + this.getBounds().toString().substring(18) + " conf: " + this.score;
        }
    }
}

