/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.filter.baselinetable.tatr;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.filter.line.LineCombineSorter;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasBounds;
import com.inet.pdfc.util.ElementSearch;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.RattleSort;
import com.inet.pdfc.util.Sample;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class TablePropertiesDetector {
    public static final int COLUMN_MIN_WIDTH = 30;
    public static final double WORD_SPACE_RATIO = 1.5;
    public static final double CONTENT_TO_ROWS_RATIO = 0.2;
    private double cc;
    private double cd;

    public TablePropertiesDetector() {
        this(1.5, 0.2);
    }

    public TablePropertiesDetector(double wordSpaceRatio, double contentToRowsRatio) {
        this.cc = wordSpaceRatio;
        this.cd = contentToRowsRatio;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    public c detectRowsAndColumns(@Nonnull Rectangle2D tableArea, @Nonnull ElementSearch<DrawableElement> searcher) {
        double d2;
        double d3;
        @Nonnull @Nonnull List list = searcher.getElementsInAreaAsList(tableArea, true);
        Rectangle2D rectangle2D = LocationUtils.getJoinedBounds((List)list);
        tableArea = rectangle2D != null ? rectangle2D : tableArea;
        c c2 = new c(tableArea);
        c2.cm = this.a(list, tableArea).stream().mapToDouble(Double::doubleValue).toArray();
        ArrayList<@Nonnull List> arrayList = new ArrayList<List>();
        for (int i = 0; i < c2.aN(); ++i) {
            Rectangle2D rectangle2D2 = c2.l(i);
            @Nonnull @Nonnull List list2 = searcher.getElementsInAreaAsList(rectangle2D2, false);
            for (DrawableElement drawableElement2 : list2) {
                Rectangle2D object2 = LocationUtils.getNormedBounds((HasBounds)drawableElement2);
                if (drawableElement2.getType() != ElementType.TextWord || LocationUtils.contains((Rectangle2D)rectangle2D2, (Rectangle2D)object2)) continue;
                d3 = ((WordElement)drawableElement2).getStyle().getWsWidthScaled();
                double arrayList3 = object2.getWidth();
                Rectangle2D.intersect(rectangle2D2, object2, object2);
                double d4 = object2.getWidth();
                d2 = arrayList3 - d4;
                if (!(d2 > d3) || !(d2 < d4 || i == 0 && drawableElement2.getX() < rectangle2D2.getX()) && (i != c2.aN() - 1 || !(drawableElement2.getBounds().getMaxX() > rectangle2D2.getMaxX()))) continue;
                c2.cn = false;
                c2.co = drawableElement2.getLabel() + " leaves col ";
                break;
            }
            arrayList.add(list2);
        }
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d6 = Double.MAX_VALUE;
        int n = 0;
        for (List list2 : arrayList) {
            d3 = -1.0;
            int n2 = 0;
            Collections.sort(list2, ElementSorter.Y_COMPARATOR);
            for (DrawableElement drawableElement2 : list2) {
                if (drawableElement2.getType() != ElementType.TextWord) continue;
                d6 = Math.min(d6, Math.abs(drawableElement2.getBounds().getHeight()));
                if (d3 < 0.0) {
                    d3 = drawableElement2.getY();
                    continue;
                }
                double d5 = drawableElement2.getY() - d3;
                if (d5 > Math.abs(drawableElement2.getBounds().getHeight())) {
                    Double d7 = d5;
                    arrayList2.add(d7);
                    ++n2;
                }
                d3 = drawableElement2.getY();
            }
            n = Math.max(n, n2);
        }
        c2.bN = n;
        if (arrayList2.size() > 0) {
            DrawableElement drawableElement2;
            drawableElement2 = new RattleSort(Double::doubleValue);
            List list3 = drawableElement2.sort(arrayList2, 1.0);
            list3.sort(new Comparator<Sample<Double>>(){

                public int a(Sample<Double> sample, Sample<Double> sample2) {
                    int n = Integer.compare(sample2.getCount(), sample.getCount());
                    return n != 0 ? n : Double.compare(sample2.doubleValue(), sample.doubleValue());
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((Sample<Double>)((Sample)object), (Sample<Double>)((Sample)object2));
                }
            });
            if (list3.size() > 1) {
                double[] dArray = list3.stream().mapToDouble(Sample::getMax).toArray();
                Arrays.sort(dArray);
                d3 = dArray[0];
            } else {
                d3 = ((Sample)list3.get(0)).getMin() - 0.1;
            }
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            arrayList3.add(tableArea.getMinY());
            LineCombineSorter lineCombineSorter = new LineCombineSorter();
            lineCombineSorter.setIgnoreStyles(true);
            lineCombineSorter.setCombineFilledShapes(true);
            lineCombineSorter.setNormalizeDirection(false);
            List list4 = list.stream().filter(drawableElement -> drawableElement.getType() == ElementType.LineHorizontal).collect(Collectors.toCollection(ArrayList::new));
            @Nonnull List list5 = lineCombineSorter.sortOrFilterPage(0, list4, false, null);
            list.stream().filter(drawableElement -> drawableElement.getType() == ElementType.TextWord).forEach(drawableElement -> list4.add(drawableElement));
            Collections.sort(list5, ElementSorter.YX_COMPARATOR);
            d2 = -1.0;
            for (DrawableElement drawableElement3 : list5) {
                LineShape lineShape;
                if (drawableElement3.getType() == ElementType.LineHorizontal && Math.abs((lineShape = (LineShape)drawableElement3).getBounds().getMinX() - tableArea.getMinX()) < 1.5 && Math.abs(lineShape.getBounds().getMaxX() - tableArea.getMaxX()) < 1.5) {
                    arrayList3.add(lineShape.getY());
                    d2 = -1.0;
                }
                if (drawableElement3.getType() != ElementType.TextWord) continue;
                if (d2 < 0.0) {
                    d2 = drawableElement3.getY();
                    continue;
                }
                double d8 = drawableElement3.getY() - d2;
                if (d8 > d3) {
                    arrayList3.add(d2 + (LocationUtils.getMinY((Rectangle2D)drawableElement3.getBounds()) - d2) / 2.0);
                }
                d2 = drawableElement3.getY();
            }
            arrayList3.add(tableArea.getMaxY());
            drawableElement2.sort(arrayList3, d6 / 3.0).stream().map(sample -> sample.doubleValue()).toList();
            c2.cl = drawableElement2.sort(arrayList3, d6 / 3.0).stream().mapToDouble(sample -> sample.doubleValue()).toArray();
        } else {
            c2.cn = false;
        }
        return c2;
    }

    private boolean a(@Nonnull WordElement wordElement, @Nonnull WordElement wordElement2) {
        double d2;
        if (wordElement.getY() != wordElement2.getY()) {
            return false;
        }
        TextStyle textStyle = wordElement.getStyle();
        double d3 = textStyle.getWsWidthScaled();
        if (!Double.isNaN(textStyle.getActualSpaceWidth())) {
            d3 = Math.max(d3, textStyle.getActualSpaceWidth() * textStyle.getWsWidthScaled() / textStyle.getWsWidth());
        }
        TextStyle textStyle2 = wordElement2.getStyle();
        double d4 = textStyle2.getWsWidthScaled();
        if (!Double.isNaN(textStyle2.getActualSpaceWidth())) {
            d4 = Math.max(d4, textStyle2.getActualSpaceWidth() * textStyle2.getWsWidthScaled() / textStyle2.getWsWidth());
        }
        return (d2 = wordElement2.getX() - wordElement.getBounds().getMaxX()) < Math.max(d3, d4) * this.cc;
    }

    @Nonnull
    private @Nonnull List<@Nonnull Double> a(@Nonnull @Nonnull List<@Nonnull DrawableElement> list, @Nonnull Rectangle2D rectangle2D) {
        Object object;
        DrawableElement drawableElement22;
        Object object2 = null;
        RectangularShape rectangularShape = null;
        int n = 0;
        ArrayList<b> arrayList = new ArrayList<b>();
        double d2 = 30.0;
        for (DrawableElement drawableElement22 : list) {
            if (drawableElement22.getType() == ElementType.TextWord) {
                object = (WordElement)drawableElement22;
                d2 = Math.min(d2, object.getStyle().getTextHeight());
                if (object2 == null) {
                    object2 = object;
                    rectangularShape = LocationUtils.getNormedBounds((HasBounds)object);
                    continue;
                }
                if (object2.getY() != object.getY()) {
                    ++n;
                }
                if (!this.a((WordElement)object2, (WordElement)object) && rectangularShape != null) {
                    arrayList.add(new b(rectangularShape.getMinX(), true));
                    arrayList.add(new b(rectangularShape.getMaxX(), false));
                    rectangularShape = LocationUtils.getNormedBounds((HasBounds)object);
                } else {
                    rectangularShape = LocationUtils.union((Rectangle2D)LocationUtils.getNormedBounds((HasBounds)object), (Rectangle2D)rectangularShape);
                }
                object2 = object;
                continue;
            }
            if (drawableElement22.getType() != ElementType.LineHorizontal || drawableElement22.getStrokePaint() == null || ((LineShape)drawableElement22).isUnderline() || !(((RectangularShape)(object = drawableElement22.getBounds())).getWidth() / rectangle2D.getWidth() < 0.8)) continue;
            arrayList.add(new b(((RectangularShape)object).getMinX(), true));
            arrayList.add(new b(((RectangularShape)object).getMaxX(), false));
        }
        Object object3 = list.stream().filter(drawableElement -> drawableElement.getType() == ElementType.LineVertical).collect(Collectors.toCollection(ArrayList::new));
        if (!object3.isEmpty()) {
            drawableElement22 = new LineCombineSorter();
            drawableElement22.setIgnoreStyles(true);
            drawableElement22.setCombineFilledShapes(true);
            object3 = drawableElement22.sortOrFilterPage(0, (List)object3, true, null);
            object3.stream().filter(drawableElement -> LocationUtils.contains((Rectangle2D)rectangle2D, (Rectangle2D)drawableElement.getBounds()) && drawableElement.getBounds().getHeight() / rectangle2D.getHeight() > 0.66).forEach(drawableElement -> {
                b b2 = new b(drawableElement.getX(), true);
                b2.ck = true;
                arrayList.add(b2);
            });
        }
        if (rectangularShape == null) {
            return new ArrayList<Double>(List.of(Double.valueOf(rectangle2D.getMinX()), Double.valueOf(rectangle2D.getMaxX())));
        }
        arrayList.add(new b(rectangularShape.getMinX(), true));
        arrayList.add(new b(rectangularShape.getMaxX(), false));
        drawableElement22 = new RattleSort(b::aL);
        object = drawableElement22.sort(arrayList, 0.75);
        int n2 = 0;
        int n3 = (int)((double)n * this.cd);
        double d3 = rectangle2D.getMinX();
        a a2 = null;
        ArrayList<a> arrayList2 = new ArrayList<a>();
        int n4 = 0;
        double d4 = 0.0;
        Object object4 = object.iterator();
        while (object4.hasNext()) {
            Sample sample = (Sample)object4.next();
            if (a2 != null && (a2.ci == n2 || a2.ci > n3 && n2 > n3)) {
                a2.cg = sample.doubleValue();
                a2.ci = Math.max(a2.ci, n2);
            } else {
                a2 = new a(d3, sample.doubleValue(), n2);
                arrayList2.add(a2);
            }
            if (n4 != 0) {
                a2.ch = d4;
                n2 = n4;
                n4 = 0;
            }
            long l = sample.getOccurrences().stream().filter(b2 -> b2.start && !b2.ck).count();
            long l2 = sample.getOccurrences().stream().filter(b2 -> !b2.start && !b2.ck).count();
            boolean bl = sample.getOccurrences().stream().filter(b2 -> b2.ck).findAny().isPresent();
            if ((n2 = (int)((long)n2 - l2)) <= n3 && (long)n2 + l2 > (long)n3 && (long)n2 + l > (long)n3 && !bl) {
                a2.cg = sample.doubleValue();
                arrayList2.add(new a(sample.doubleValue(), sample.doubleValue(), n2));
                a2 = new a(sample.doubleValue(), sample.doubleValue(), (int)((long)n2 + l));
                arrayList2.add(a2);
            }
            n2 = (int)((long)n2 + l);
            if (bl) {
                n4 = n2;
                d4 = sample.doubleValue();
                n2 = 0;
            }
            d3 = sample.doubleValue();
        }
        arrayList2.add(new a(d3, rectangle2D.getMaxX(), n2));
        object4 = new ArrayList();
        object4.add(rectangle2D.getMinX());
        for (int i = 1; i < arrayList2.size() - 1; ++i) {
            a a3 = (a)arrayList2.get(i - 1);
            a a4 = (a)arrayList2.get(i);
            a a5 = (a)arrayList2.get(i + 1);
            if (a4.ci > n3 || a3.ci < a4.ci || a5.ci < a4.ci) continue;
            if (!object4.isEmpty()) {
                Double d5 = (Double)object4.get(object4.size() - 1);
                if (a4.aK() - d5 < d2) continue;
            }
            object4.add(a4.aK());
        }
        if ((Double)object4.get(object4.size() - 1) < rectangle2D.getMaxX() - 1.5) {
            object4.add(rectangle2D.getMaxX());
        }
        return object4;
    }

    public static class c {
        private int bN;
        private double @Nonnull [] cl;
        private double @Nonnull [] cm;
        private boolean cn;
        private String co = "";

        public c(@Nonnull Rectangle2D rectangle2D) {
            this.cl = new double[]{rectangle2D.getMinY(), rectangle2D.getMaxY()};
            this.cm = new double[]{rectangle2D.getMinX(), rectangle2D.getMaxX()};
        }

        public int aM() {
            return this.bN;
        }

        public int aN() {
            return this.cm.length - 1;
        }

        public double @Nonnull [] aO() {
            return this.cm;
        }

        public double @Nonnull [] aP() {
            return this.cl;
        }

        public Rectangle2D l(int n) {
            return new Rectangle2D.Double(this.cm[n], this.cl[0], this.cm[n + 1] - this.cm[n], this.cl[this.cl.length - 1] - this.cl[0]);
        }
    }

    static class b
    implements Comparable<b> {
        private double cj;
        boolean start = false;
        boolean ck = false;

        public b(double d2, boolean bl) {
            this.cj = d2;
            this.start = bl;
        }

        public int d(@Nonnull b b2) {
            int n = Double.compare(this.cj, b2.cj);
            return n != 0 ? n : Boolean.compare(this.start, b2.start);
        }

        @Nonnull
        public String toString() {
            return this.cj + " " + (this.start ? "START" : "END");
        }

        public double aL() {
            return this.cj;
        }

        @Override
        public /* synthetic */ int compareTo(@Nonnull Object object) {
            return this.d((b)object);
        }
    }

    static class a {
        private double cf;
        private double cg;
        private double ch = Double.NaN;
        int ci;

        public a(double d2, double d3, int n) {
            this.cf = d2;
            this.cg = d3;
            this.ci = n;
        }

        @Nonnull
        public Double aK() {
            return Double.isNaN(this.ch) ? Double.valueOf((this.cg + this.cf) / 2.0) : this.ch;
        }
    }
}

