/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.structure;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.CurrencyConfigProperty;
import com.inet.config.structure.model.I18NChooserProperty;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.TableConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.FieldSettingsPropertyExtension;
import com.inet.fieldsettings.api.FieldSettingsStructureInfo;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.usersandgroups.api.ui.fields.user.CurrencyUserFieldDefinition;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
@InternalApi
public class GenericFieldSettingsProperty
extends ItemListConfigProperty {
    public static final String FIELD_NEW = "field.new";
    public static final String PROP_DISABLE_DELETE_BUTTON = "disableDeleteButton";
    public static final String PROP_IS_NEW = "field.isNew";
    public static final String PROP_ICON = "fieldIcon";
    public static final String PROP_LABEL = "fieldLabel";
    public static final String PROP_PREWVIEW_DESC = "previewDescription";
    public static final String PROP_I18N_CHOOSER = "i18nchooser";
    public static final String PROP_DUPLICATE = "duplicate";

    public GenericFieldSettingsProperty(String key, ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        this(key, settings, manager, "FieldSettingsRenderer");
    }

    public GenericFieldSettingsProperty(String key, ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager, String renderer) {
        super(0, key, renderer, null, null, new ConfigRowAction[0]);
        this.setDeleteDisabledCondition(new ConfigCondition(ConfigCondition.Operation.And, new Object[]{new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{PROP_DISABLE_DELETE_BUTTON, "true"}), new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{PROP_DUPLICATE, "false"})}));
        this.setReloadAfterRowDeletion(true);
        this.setManuallySortable(true);
        this.setValue(this.createListValue(settings, manager));
        this.setRowActions(this.createRowActions(settings, manager));
    }

    protected List<Map<String, String>> createListValue(ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        List list = (List)settings.getChangedValue(this.getKey(), List.class);
        if (list != null) {
            for (Map map : list) {
                if (!((String)map.get("fieldsettingsIsCustom")).equalsIgnoreCase("true") && !((String)map.get(PROP_DUPLICATE)).equalsIgnoreCase("true")) continue;
                map.put(PROP_ICON, manager.getFieldSettingsStructureInfo().getIconKeyCustomField());
                Map map2 = (Map)new Json().fromJson((String)map.get("fieldsettingsLabel"), (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, String.class}));
                String string = (String)map2.get(ClientLocale.getThreadLocale().getLanguage());
                if (string == null) {
                    string = (String)map2.get("default");
                }
                map.put(PROP_LABEL, string);
                Map map3 = (Map)new Json().fromJson((String)map.get("description"), (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, String.class}));
                String string2 = (String)map3.get(ClientLocale.getThreadLocale().getLanguage());
                if (string2 == null) {
                    string2 = (String)map3.get("default");
                }
                map.put(PROP_PREWVIEW_DESC, string2);
                map.put("fieldsettingsIsCustom", "true");
            }
            return list;
        }
        List<GenericFieldSetting> list2 = manager.getSettings();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        list2.forEach(setting -> {
            Map<String, String> map = this.createRowPropertiesFor((GenericFieldSetting)setting, manager);
            arrayList.add(map);
        });
        return arrayList;
    }

    protected Map<String, String> createRowPropertiesFor(GenericFieldSetting setting, AbstractFieldSettingsManager<?, ?> manager) {
        Map<String, String> map = setting.toMap(manager);
        map.put("fieldsettingsCanSetDefault", String.valueOf(setting.isCustom() ? true : setting.canConfigureDefaultValue()));
        map.put("fieldsettingsCanSetTranslation", String.valueOf(setting.canConfigureTranslation()));
        map.put(PROP_IS_NEW, "false");
        if (setting.isCustom()) {
            map.put(PROP_ICON, manager.getFieldSettingsStructureInfo().getIconKeyCustomField());
        } else {
            map.put(PROP_ICON, manager.getFieldSettingsStructureInfo().getIconKeyRegisteredField());
        }
        String string = setting.getKey();
        map.put(PROP_LABEL, manager.getDefinitionForSetting(string).getLabel());
        map.put(PROP_PREWVIEW_DESC, manager.getDefinitionForSetting(string).getDescription());
        map.put(PROP_DISABLE_DELETE_BUTTON, String.valueOf(!setting.isCustom()));
        map.putIfAbsent(PROP_I18N_CHOOSER, "");
        map.putIfAbsent("fieldsettingsDefaultValueSelect", new Json().toJson((Object)new LocalizedKey("", "")));
        map.putIfAbsent("fieldsettingsDefaultValueText", "");
        map.putIfAbsent("fieldsettingsDefaultValueTextMulti", "");
        map.putIfAbsent("fieldsettingsDefaultValueInt", "");
        map.putIfAbsent("fieldsettingsDefaultValueDouble", "");
        map.putIfAbsent("fieldsettingsDefaultValueCurrency", "");
        map.putIfAbsent("fieldsettingsDefaultValueBoolean", "false");
        map.putIfAbsent("selectstaticoptions", "[]");
        map.putIfAbsent("fieldSettingsSelectMode", String.valueOf(1));
        map.putIfAbsent("fieldSettingsIgnoreTimezone", "false");
        map.putIfAbsent("linkPatternLabel", "");
        map.putIfAbsent("linkPatternLink", "");
        map.putIfAbsent("fieldsettingsLabel", "{}");
        map.putIfAbsent("description", "{}");
        map.putIfAbsent(PROP_DUPLICATE, "false");
        for (FieldSettingsPropertyExtension fieldSettingsPropertyExtension : manager.getFieldPropertyExtensions()) {
            fieldSettingsPropertyExtension.patchRowProperties(map, setting);
        }
        return map;
    }

    protected ConfigRowAction[] createRowActions(ConfigStructureSettings settings, AbstractFieldSettingsManager<?, ?> manager) {
        FieldSettingsStructureInfo fieldSettingsStructureInfo = manager.getFieldSettingsStructureInfo();
        ConfigAction configAction = new ConfigAction(this.getKey() + FIELD_NEW, fieldSettingsStructureInfo.translate("fields.button.add", new Object[0]));
        ConfigCategory configCategory = new ConfigCategory(0, this.getKey() + FIELD_NEW, fieldSettingsStructureInfo.getFieldKindLabel(), fieldSettingsStructureInfo.getHelpKey());
        ArrayList<ConfigPropertyGroup> arrayList = new ArrayList<ConfigPropertyGroup>();
        arrayList.add(new ConfigPropertyGroup(0, "field.new.group", ""));
        HashMap<String, ArrayList<ConfigProperty>> hashMap = new HashMap<String, ArrayList<ConfigProperty>>();
        ArrayList<ConfigProperty> arrayList2 = new ArrayList<ConfigProperty>();
        hashMap.put("field.new.group", arrayList2);
        ArrayList<ConfigConditionAction> arrayList3 = new ArrayList<ConfigConditionAction>();
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        ConfigCondition configCondition = conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(PROP_DUPLICATE).equals().value((Object)"true"), conditionGenerator.createCondition().property("fieldsettingsIsCustom").equals().value((Object)"true")});
        ConfigCondition configCondition2 = conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(PROP_DUPLICATE).equals().value((Object)"true"), conditionGenerator.createCondition().property(PROP_IS_NEW).equals().value((Object)"true")});
        ConfigCondition configCondition3 = conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(PROP_DUPLICATE).equals().value((Object)"true"), conditionGenerator.createCondition().property("fieldsettingsCanSetDefault").equals().value((Object)"true")});
        ConfigCondition configCondition4 = conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property(PROP_DUPLICATE).equals().value((Object)"true"), conditionGenerator.createCondition().property("fieldsettingsCanSetTranslation").equals().value((Object)"true")});
        arrayList3.add(conditionGenerator.enableActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{configCondition, configCondition2}), "fieldsettingsKey"));
        arrayList3.add(conditionGenerator.enableActionFor(configCondition, "type"));
        arrayList3.add(conditionGenerator.enableActionFor(configCondition4, "fieldsettingsLabel"));
        arrayList3.add(conditionGenerator.enableActionFor(configCondition4, "description"));
        arrayList3.add(conditionGenerator.enableActionFor(configCondition4, PROP_I18N_CHOOSER));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_SELECT.toString()), configCondition}), "selectstaticoptions"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_SELECT.toString()), configCondition}), "fieldSettingsSelectMode"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_TEXT.toString()), configCondition3}), "fieldsettingsDefaultValueText"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_MULTILINE_TEXT.toString()), configCondition3}), "fieldsettingsDefaultValueTextMulti"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_SELECT.toString()), configCondition3}), "fieldsettingsDefaultValueSelect"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_NUMBER.toString()), configCondition3}), "fieldsettingsDefaultValueInt"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_BOOLEAN.toString()), configCondition3}), "fieldsettingsDefaultValueBoolean"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_DOUBLE.toString()), configCondition3}), "fieldsettingsDefaultValueDouble"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_CURRENCY.toString()), configCondition3}), "fieldsettingsDefaultValueCurrency"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_LINK.toString()), configCondition3}), "linkPatternLabel"));
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_LINK.toString()), configCondition3}), "linkPatternLink"));
        ConfigCondition configCondition5 = conditionGenerator.createCondition().or(new ConfigCondition[]{conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_DATE.toString()), conditionGenerator.createCondition().property("type").equals().value((Object)FieldSettingsType.TYPE_DATE_TIME.toString())});
        arrayList3.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{configCondition5, configCondition}), "fieldSettingsIgnoreTimezone"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("SimpleText", fieldSettingsStructureInfo.translate("fields.row.key", new Object[0]), "fieldsettingsKey", ""));
        arrayList2.add((ConfigProperty)new I18NChooserProperty(0, PROP_I18N_CHOOSER, ""));
        arrayList2.add(GenericFieldSettingsProperty.propWith("MultiLingualText", fieldSettingsStructureInfo.translate("fields.row.labels", new Object[0]), "fieldsettingsLabel", "{}"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("MultiLingualText", fieldSettingsStructureInfo.translate("fields.row.description", new Object[0]), "description", "{}"));
        List list = manager.getSupportedTypesForCustomFields().stream().map(type -> new LocalizedKey(type.toString(), type.getLabel())).collect(Collectors.toList());
        arrayList2.add((ConfigProperty)new SelectConfigProperty(78, "type", "SimpleText", fieldSettingsStructureInfo.translate("fields.row.datatype", new Object[0]), (Object)FieldSettingsType.TYPE_TEXT.toString(), "", list));
        arrayList2.add(GenericFieldSettingsProperty.propWith("SelectFiltered", fieldSettingsStructureInfo.translate("fields.row.defaulvalue", new Object[0]), "fieldsettingsDefaultValueSelect", new Json().toJson((Object)new LocalizedKey("", ""))));
        arrayList2.add(GenericFieldSettingsProperty.propWith("SimpleText", fieldSettingsStructureInfo.translate("fields.row.defaulvalue", new Object[0]), "fieldsettingsDefaultValueText", ""));
        arrayList2.add(GenericFieldSettingsProperty.propWith("MultiLineText", fieldSettingsStructureInfo.translate("fields.row.defaulvalue", new Object[0]), "fieldsettingsDefaultValueTextMulti", ""));
        arrayList2.add(GenericFieldSettingsProperty.propWith("FixNumber", fieldSettingsStructureInfo.translate("fields.row.defaulvalue", new Object[0]), "fieldsettingsDefaultValueInt", ""));
        arrayList2.add(GenericFieldSettingsProperty.propWith("FloatNumber", fieldSettingsStructureInfo.translate("fields.row.defaulvalue", new Object[0]), "fieldsettingsDefaultValueDouble", ""));
        String string = CurrencyUserFieldDefinition.getCurrency().getSymbol(ClientLocale.getThreadLocale());
        arrayList2.add((ConfigProperty)new CurrencyConfigProperty(0, "fieldsettingsDefaultValueCurrency", fieldSettingsStructureInfo.translate("fields.row.defaulvalue", new Object[0]), (Object)"", null, string, null));
        arrayList2.add((ConfigProperty)new BooleanConfigProperty(1257, "fieldsettingsDefaultValueBoolean", fieldSettingsStructureInfo.translate("fields.row.defaulvalue", new Object[0]), null, null, (Object)"false"));
        ConfigAction[] configActionArray = new ConfigAction[]{new ConfigAction(fieldSettingsStructureInfo.translate("fields.row.selectvalues.add", new Object[0]))};
        TableConfigProperty tableConfigProperty = new TableConfigProperty(1255, "selectstaticoptions", "SimpleTextReloadSelectInputs", fieldSettingsStructureInfo.translate("fields.row.selectvalues", new Object[0]), "", Collections.emptyList(), new ConfigProperty[]{new ConfigProperty(0, "", "SimpleText", null, null, null, "")}, new int[]{100}, configActionArray, null);
        tableConfigProperty.setSortable(true);
        arrayList2.add((ConfigProperty)tableConfigProperty);
        List<LocalizedKey> list2 = List.of(new LocalizedKey(String.valueOf(1), fieldSettingsStructureInfo.translate("fields.row.select.mode.normal", new Object[0])), new LocalizedKey(String.valueOf(3), fieldSettingsStructureInfo.translate("fields.row.select.mode.multi", new Object[0])), new LocalizedKey(String.valueOf(2), fieldSettingsStructureInfo.translate("fields.row.select.mode.own", new Object[0])));
        arrayList2.add((ConfigProperty)new SelectConfigProperty(1256, "fieldSettingsSelectMode", "SimpleText", fieldSettingsStructureInfo.translate("fields.row.select.mode", new Object[0]), (Object)String.valueOf(1), "", list2));
        arrayList2.add((ConfigProperty)new BooleanConfigProperty(1258, "fieldSettingsIgnoreTimezone", fieldSettingsStructureInfo.translate("fields.row.ignoreTimezone", new Object[0]), null, null, (Object)"false"));
        arrayList2.add(new ConfigProperty(0, "linkPatternLink", "SimpleText", fieldSettingsStructureInfo.translate("fields.row.link.link", new Object[0]), (Object)"", null, "http://my.service.com/widget/{custom1}"));
        arrayList2.add(new ConfigProperty(0, "linkPatternLabel", "SimpleText", fieldSettingsStructureInfo.translate("fields.row.link.label", new Object[0]), (Object)"", null, "My external service"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("Hidden", "", "fieldsettingsIsCustom", "true"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("Hidden", "", "fieldsettingsCanSetDefault", "true"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("Hidden", "", "fieldsettingsCanSetTranslation", "true"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("Hidden", "", PROP_IS_NEW, "true"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("Hidden", "", PROP_DUPLICATE, "false"));
        arrayList2.add(GenericFieldSettingsProperty.propWith("Hidden", "", PROP_LABEL, ""));
        arrayList2.add(GenericFieldSettingsProperty.propWith("Hidden", "", PROP_DISABLE_DELETE_BUTTON, "false"));
        List<FieldSettingsPropertyExtension> list3 = manager.getFieldPropertyExtensions();
        Collections.sort(list3, (o1, o2) -> o1.getOrder() - o2.getOrder());
        for (FieldSettingsPropertyExtension fieldSettingsPropertyExtension : list3) {
            fieldSettingsPropertyExtension.addProperties(arrayList2);
            fieldSettingsPropertyExtension.addConditions(arrayList3);
        }
        ConfigRowAction configRowAction = new ConfigRowAction(configAction, null, configCategory, arrayList, hashMap, arrayList3);
        return new ConfigRowAction[]{configRowAction};
    }

    protected static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }
}

