/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.field.SelectOption;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.FieldSettingsSelectValueProvider;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@InternalApi
public abstract class GenericFieldConfigStructureProvider
extends AbstractStructureProvider {
    private Supplier<AbstractFieldSettingsManager<?, ?>> u;
    private String v;

    public GenericFieldConfigStructureProvider(Supplier<AbstractFieldSettingsManager<?, ?>> manager, String propertyKey) {
        this.u = manager;
        this.v = propertyKey;
    }

    public List<LocalizedKey> getSelectValues(String key, String filter, ConfigStructureSettings settings) {
        if (key.equals("fieldsettingsDefaultValueSelect") && settings.getChangedValue(this.v) != null) {
            String string = settings.getValue("fieldsettingsIsCustom");
            String string2 = settings.getValue("duplicate");
            if (string != null) {
                if ("true".equals(string) || "true".equals(string2)) {
                    List<SelectOption> list;
                    ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                    String string3 = settings.getValue("selectstaticoptions");
                    if (string3 != null) {
                        list = (List<SelectOption>)new Json().fromJson(string3, List.class);
                        for (List list2 : list) {
                            arrayList.add(new LocalizedKey((String)list2.get(0), (String)list2.get(0)));
                        }
                    }
                    list = FieldSettingsSelectValueProvider.getSelectValues(settings.getValue("fieldsettingsKey"), new HashMap<Object, Object>(settings.getValues()));
                    arrayList.addAll(list.stream().map(selectOption -> new LocalizedKey(selectOption.getValue(), selectOption.getLabel())).toList());
                    if (filter != null && !filter.isBlank()) {
                        arrayList.removeIf(localizedKey -> !localizedKey.getDisplayName().contains(filter));
                    }
                    return arrayList;
                }
                GenericFieldSetting genericFieldSetting = this.getManager().getSetting(settings.getValue("fieldsettingsKey"));
                return genericFieldSetting.getSelectOptions(filter).stream().map(SelectOption::asLocalizedKey).collect(Collectors.toList());
            }
        }
        return super.getSelectValues(key, filter, settings);
    }

    public ConfigStructure.SaveState save(String key, String value, ConfigStructureSettings settings) {
        if (key.equals(this.v)) {
            List list = (List)settings.getChangedValue(this.v, List.class);
            this.a(list);
            HashMap hashMap = new HashMap();
            list.forEach(map2 -> hashMap.put((String)map2.get("fieldsettingsKey"), map2));
            AbstractFieldSettingsManager<?, ?> abstractFieldSettingsManager = this.getManager();
            abstractFieldSettingsManager.doBatchModification(() -> {
                List<GenericFieldSetting> list = abstractFieldSettingsManager.getSettings();
                for (GenericFieldSetting genericFieldSetting : list) {
                    String string2 = genericFieldSetting.getKey();
                    Map map3 = (Map)hashMap.get(string2);
                    if (map3 == null) {
                        abstractFieldSettingsManager.deleteCustomSetting(string2);
                        continue;
                    }
                    abstractFieldSettingsManager.updateSetting(string2, map3);
                    hashMap.remove(string2);
                }
                hashMap.forEach((string, map) -> abstractFieldSettingsManager.addNewCustomField((String)string, (Map<String, String>)map));
            });
            return ConfigStructure.SaveState.SAVE;
        }
        return ConfigStructure.SaveState.NONE;
    }

    private void a(List<Map<String, String>> list) {
        int n = 100;
        for (Map<String, String> map : list) {
            map.put("sortPrio", String.valueOf(n));
            n += 100;
        }
    }

    protected AbstractFieldSettingsManager<?, ?> getManager() {
        return this.u.get();
    }

    public void validate(String categoryKey, ArrayList<ConfigValidationMsg> messages, ArrayList<ConfigConditionAction> conditions, ConfigStructureSettings settings) {
        AbstractFieldSettingsManager<?, ?> abstractFieldSettingsManager = this.u.get();
        if (categoryKey != null && categoryKey.equals(this.v + "field.new")) {
            String string2 = settings.getChangedValue("fieldsettingsKey");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            settings.getValues().stringPropertyNames().forEach(string -> hashMap.put((String)string, settings.getValues().getProperty((String)string)));
            boolean bl = "true".equalsIgnoreCase((String)hashMap.get("field.isNew"));
            messages.addAll(abstractFieldSettingsManager.validate(string2, hashMap, bl));
        } else if (settings.getChangedValue(this.v) != null) {
            Object object;
            Object object2;
            Object object32;
            List list = (List)new Json().fromJson(settings.getValue(this.v), List.class);
            block2: for (int k = 0; k < list.size(); ++k) {
                Object object4 = (Map)list.get(k);
                object32 = (String)object4.get("fieldsettingsKey");
                for (int i2 = k + 1; i2 < list.size(); ++i2) {
                    object2 = (Map)list.get(i2);
                    object = (String)object2.get("fieldsettingsKey");
                    if (!((String)object32).equals(object)) continue;
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, abstractFieldSettingsManager.getFieldSettingsStructureInfo().translate("fields.validation.duplicatekey", object32), this.v));
                    continue block2;
                }
            }
            for (Object object4 : list) {
                object32 = (String)object4.get("fieldsettingsKey");
                FieldSettingsType fieldSettingsType = FieldSettingsType.valueOf((String)object4.get("type"));
                object2 = this.u.get().getSetting((String)object32);
                if (object2 == null || ((GenericFieldSetting)object2).getType().getValueType().equals(fieldSettingsType.getValueType())) continue;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, abstractFieldSettingsManager.getFieldSettingsStructureInfo().translate("fields.validation.confirm.typeChangedAllDataDeleted", object32), this.v));
            }
            ArrayList arrayList = new ArrayList();
            for (Object object32 : list) {
                String string3 = (String)object32.get("fieldsettingsKey");
                object2 = FieldSettingsType.valueOf((String)object32.get("type"));
                object = this.u.get().getSetting(string3);
                if (object == null) {
                    arrayList.add(string3);
                    continue;
                }
                if (((GenericFieldSetting)object).getType() == object2) continue;
                arrayList.add(string3);
            }
            try {
                this.u.get().checkKeysToDelete(arrayList);
            }
            catch (IllegalStateException illegalStateException) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, illegalStateException.getMessage(), this.v));
            }
        }
    }
}

