/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.api.model.nature;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.field.SelectOption;
import com.inet.fieldsettings.api.FieldSettingsSelectValueProvider;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.GenericFieldNature;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
@InternalApi
public class CustomNature
implements GenericFieldNature {
    private FieldSettingsType type;
    private List<String> staticValues;
    @Deprecated
    private transient boolean select_allowOwnValue;
    @Deprecated
    private transient boolean select_allowMultipleValues;
    private int select_optionsMode = 0;
    private List<List<String>> selectOptionData;
    @Deprecated
    private transient Map<String, String> labels;

    private CustomNature() {
    }

    public CustomNature(Map<String, String> properties) {
        this.type = FieldSettingsType.valueOf(properties.get("type"));
        if (this.type == null) {
            throw new IllegalArgumentException("Custom field needs a type");
        }
        properties.remove("type");
        List list = (List)new Json().fromJson(properties.getOrDefault("selectstaticoptions", "[[]]"), List.class);
        this.staticValues = new ArrayList<String>(list.size());
        this.selectOptionData = new ArrayList<List<String>>(list.size());
        list.forEach(row -> {
            if (!row.isEmpty()) {
                this.staticValues.add((String)row.get(0));
                this.selectOptionData.add(row.subList(1, row.size()));
            }
        });
        properties.remove("selectstaticoptions");
        String string = properties.remove("fieldSettingsSelectMode");
        if (string == null) {
            string = String.valueOf(1);
        }
        try {
            this.select_optionsMode = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal value for field fieldSettingsSelectMode: " + string);
        }
    }

    @Override
    public List<SelectOption> getSelectOptions(String filter, GenericFieldSetting settings) {
        List<SelectOption> list = FieldSettingsSelectValueProvider.getSelectValues(settings.getKey(), settings.getSpecificProperties());
        list.addAll(0, this.staticValues.stream().map(str -> new SelectOption(str, str)).collect(Collectors.toList()));
        if (filter != null && !filter.isBlank()) {
            list.removeIf(o -> !o.getLabel().toLowerCase().contains(filter.toLowerCase()));
        }
        return list;
    }

    @Override
    public FieldSettingsType getType() {
        return this.type;
    }

    public List<String> getStaticValues() {
        return Collections.unmodifiableList(this.staticValues);
    }

    public List<List<String>> getStaticValuesWithData() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        for (int k = 0; k < this.staticValues.size(); ++k) {
            String string = this.staticValues.get(k);
            if (this.selectOptionData == null) {
                arrayList.add(List.of(string));
                continue;
            }
            List<String> list = this.selectOptionData.get(k);
            ArrayList<String> arrayList2 = new ArrayList<String>(list.size() + 1);
            arrayList2.add(string);
            arrayList2.addAll(list);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    @Override
    public boolean canConfigureDefaultValue() {
        return this.type.getDefaultValuePropertyKey() != null;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.selectOptionData == null ? 0 : this.selectOptionData.hashCode());
        n2 = 31 * n2 + (this.select_allowMultipleValues ? 1231 : 1237);
        n2 = 31 * n2 + (this.select_allowOwnValue ? 1231 : 1237);
        n2 = 31 * n2 + (this.staticValues == null ? 0 : this.staticValues.hashCode());
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomNature customNature = (CustomNature)obj;
        if (this.selectOptionData == null ? customNature.selectOptionData != null : !this.selectOptionData.equals(customNature.selectOptionData)) {
            return false;
        }
        if (this.select_allowMultipleValues != customNature.select_allowMultipleValues) {
            return false;
        }
        if (this.select_allowOwnValue != customNature.select_allowOwnValue) {
            return false;
        }
        if (this.staticValues == null ? customNature.staticValues != null : !this.staticValues.equals(customNature.staticValues)) {
            return false;
        }
        if (this.type == null ? customNature.type != null : !this.type.equals(customNature.type)) {
            return false;
        }
        return this.select_optionsMode == customNature.select_optionsMode;
    }

    public boolean onlySimpleValueAreDifferent(CustomNature other) {
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public void updateSimpleValues(CustomNature nature) {
        this.staticValues = new ArrayList<String>(nature.staticValues);
        this.select_allowMultipleValues = nature.select_allowMultipleValues;
        this.select_allowOwnValue = nature.select_allowOwnValue;
        this.selectOptionData = nature.selectOptionData;
        this.select_optionsMode = nature.select_optionsMode;
    }

    @Deprecated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public boolean canConfigureTranslation() {
        return true;
    }

    public int getSelectOptionsMode() {
        if (this.select_optionsMode == 0) {
            this.select_optionsMode = this.select_allowOwnValue ? 2 : (this.select_allowMultipleValues ? 3 : 1);
        }
        return this.select_optionsMode;
    }
}

