/*
 * Decompiled with CFR 0.152.
 */
package com.inet.fieldsettings.api.model;

import com.inet.annotations.JsonData;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@JsonData
public abstract class FieldSettingsType {
    private static final List<FieldSettingsType> ALL = new ArrayList<FieldSettingsType>();
    public static final FieldSettingsType TYPE_TEXT = new a("Text", String.class, "fieldsettingsDefaultValueText");
    public static final FieldSettingsType TYPE_MULTILINE_TEXT = new a("MultiLineText", String.class, "fieldsettingsDefaultValueTextMulti");
    public static final FieldSettingsType TYPE_DATE = new a("Date", Long.class, null);
    public static final FieldSettingsType TYPE_DATE_TIME = new a("DateTime", Long.class, null);
    public static final FieldSettingsType TYPE_TIME = new a("Time", String.class, null);
    public static final FieldSettingsType TYPE_NUMBER = new a("Number", Integer.class, "fieldsettingsDefaultValueInt");
    public static final FieldSettingsType TYPE_DOUBLE = new a("Double", Double.class, "fieldsettingsDefaultValueDouble");
    public static final FieldSettingsType TYPE_CURRENCY = new a("Currency", Double.class, "fieldsettingsDefaultValueCurrency");
    public static final FieldSettingsType TYPE_BOOLEAN = new a("Boolean", Boolean.class, "fieldsettingsDefaultValueBoolean");
    public static final FieldSettingsType TYPE_SELECT = new a("SelectString", String.class, "fieldsettingsDefaultValueSelect");
    public static final FieldSettingsType TYPE_LINK = new a("Link", String.class, null);
    public static final FieldSettingsType TYPE_RATING = new a("Rating", Integer.class, "fieldsettingsDefaultValueInt");
    private String name;
    private String defaultValuePropertyKey;
    private Class<?> valueType;

    public FieldSettingsType(String name, Class<?> valueType, String defaultValuePropertyKey) {
        if (ALL.stream().anyMatch(item -> item.name.equals(name))) {
            throw new IllegalArgumentException("FieldSettingsType already exists: " + name);
        }
        this.name = name;
        this.defaultValuePropertyKey = defaultValuePropertyKey;
        this.valueType = valueType;
        ALL.add(this);
    }

    public static List<FieldSettingsType> all() {
        return Collections.unmodifiableList(ALL);
    }

    public String toString() {
        return this.name;
    }

    public static FieldSettingsType valueOf(String str) {
        Optional<FieldSettingsType> optional = ALL.stream().filter(item -> item.name.equals(str)).findFirst();
        if (optional.isEmpty()) {
            throw new IllegalArgumentException("No such value: " + str);
        }
        return optional.get();
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public String getDefaultValuePropertyKey() {
        return this.defaultValuePropertyKey;
    }

    public String getLabel() {
        return AbstractFieldSettingsManager.BASE_TRANSLATIONS.getMsg("fields.type." + this.name, new Object[0]);
    }

    public abstract void validateStringInput(String var1) throws IllegalArgumentException;

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.defaultValuePropertyKey == null ? 0 : this.defaultValuePropertyKey.hashCode());
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.valueType == null ? 0 : this.valueType.hashCode());
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSettingsType fieldSettingsType = (FieldSettingsType)obj;
        if (this.defaultValuePropertyKey == null ? fieldSettingsType.defaultValuePropertyKey != null : !this.defaultValuePropertyKey.equals(fieldSettingsType.defaultValuePropertyKey)) {
            return false;
        }
        if (this.name == null ? fieldSettingsType.name != null : !this.name.equals(fieldSettingsType.name)) {
            return false;
        }
        return !(this.valueType == null ? fieldSettingsType.valueType != null : !this.valueType.equals(fieldSettingsType.valueType));
    }

    public abstract FieldType<?> toFieldType(GenericFieldSetting var1, Supplier<String> var2);

    private static class a
    extends FieldSettingsType {
        public a(String string, Class<?> clazz, String string2) {
            super(string, clazz, string2);
        }

        @Override
        public void validateStringInput(String input) {
            if (input == null || input.isEmpty()) {
                return;
            }
            if (this == TYPE_DOUBLE || this == TYPE_CURRENCY) {
                try {
                    Double.valueOf(input);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(AbstractFieldSettingsManager.BASE_TRANSLATIONS.getMsg("fields.validation.invalidDefaultValue", new Object[]{input}));
                }
            }
            if (this == TYPE_NUMBER) {
                try {
                    Integer.valueOf(input);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(AbstractFieldSettingsManager.BASE_TRANSLATIONS.getMsg("fields.validation.invalidDefaultValue", new Object[]{input}));
                }
            }
            if (this == TYPE_RATING) {
                try {
                    int n = Integer.valueOf(input);
                    if (n < 0 || n > 10) {
                        throw new IllegalArgumentException(AbstractFieldSettingsManager.BASE_TRANSLATIONS.getMsg("fields.validation.invalidRating", new Object[]{input}));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(AbstractFieldSettingsManager.BASE_TRANSLATIONS.getMsg("fields.validation.invalidRating", new Object[]{input}));
                }
            }
        }

        @Override
        public FieldType<?> toFieldType(GenericFieldSetting setting, Supplier<String> displayname) {
            if (this == TYPE_TEXT) {
                return new FieldTypeString(setting.getKey(), displayname);
            }
            if (this == TYPE_MULTILINE_TEXT) {
                return new FieldTypeString(setting.getKey(), displayname);
            }
            if (this == TYPE_DATE) {
                return new FieldTypeDate(setting.getKey(), displayname, false);
            }
            if (this == TYPE_DATE_TIME) {
                return new FieldTypeDate(setting.getKey(), displayname, true);
            }
            if (this == TYPE_TIME) {
                return new FieldTypeTime(setting.getKey(), displayname);
            }
            if (this == TYPE_NUMBER) {
                return new FieldTypeInteger(setting.getKey(), displayname);
            }
            if (this == TYPE_DOUBLE) {
                return new FieldTypeDouble(setting.getKey(), displayname);
            }
            if (this == TYPE_CURRENCY) {
                return new FieldTypeCurrency(setting.getKey(), displayname);
            }
            if (this == TYPE_BOOLEAN) {
                return new FieldTypeBoolean(setting.getKey(), displayname);
            }
            if (this == TYPE_RATING) {
                return new FieldTypeRating(setting.getKey(), displayname);
            }
            throw new UnsupportedOperationException(this.toString());
        }
    }
}

