/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.adapters;

import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.sources.ResolverLSInput;

public class LSResourceAdapter
implements LSResourceResolver {
    private final XMLResolver resolver;
    private final ResolverLogger logger;

    public LSResourceAdapter(XMLResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        this.resolver = resolver;
        this.logger = resolver.getConfiguration().getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (type == null || "http://www.w3.org/TR/REC-xml".equals(type)) {
            return this.resolveDTD(type, namespaceURI, publicId, systemId, baseURI);
        }
        return this.resolveSchema(type, namespaceURI, publicId, systemId, baseURI);
    }

    private LSInput resolveDTD(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId == null) {
            return null;
        }
        this.logger.log("request", "resolveResource: XML: %s (baseURI: %s, publicId: %s)", systemId, baseURI, publicId);
        ResourceRequest request = this.resolver.getRequest(systemId, baseURI, "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", "http://www.rddl.org/purposes#validation");
        request.setPublicId(publicId);
        ResourceResponse resp = this.resolver.resolve(request);
        return this.resolveResponse(resp, publicId);
    }

    private LSInput resolveSchema(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        ResourceResponse resp;
        ResourceRequest request;
        this.logger.log("request", "resolveResource: %s, %s (namespace: %s, baseURI: %s, publicId: %s)", type, systemId, namespaceURI, baseURI, publicId);
        String purpose = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(type) || "http://www.w3.org/2001/XMLSchema/v1.1".equals(type) || "http://relaxng.org/ns/structure/1.0".equals(type)) {
            purpose = "http://www.rddl.org/purposes#schema-validation";
        }
        if (systemId != null) {
            request = this.resolver.getRequest(systemId, baseURI, type, purpose);
            request.setPublicId(publicId);
            resp = this.resolver.resolve(request);
            if (resp != null && resp.isResolved()) {
                return this.resolveResponse(resp, publicId);
            }
        }
        request = this.resolver.getRequest(namespaceURI, baseURI, type, purpose);
        request.setPublicId(publicId);
        resp = this.resolver.resolve(request);
        return this.resolveResponse(resp, publicId);
    }

    private LSInput resolveResponse(ResourceResponse resp, String publicId) {
        ResolverLSInput input = null;
        if (resp != null && resp.isResolved()) {
            input = new ResolverLSInput(resp, publicId);
        }
        return input;
    }
}

