/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceConnection;
import org.xmlresolver.ResourceRequest;

public class ResourceResponse {
    public final ResourceRequest request;
    private URI uri;
    private URI resolvedURI;
    private boolean rejected = false;
    private boolean resolved = false;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private InputStream stream = null;
    private String contentType = null;
    private String encoding = null;
    private int statusCode = -1;
    private ResourceConnection connection = null;

    public ResourceResponse(ResourceRequest request) {
        this(request, false);
    }

    public ResourceResponse(ResourceRequest request, boolean rejected) {
        this.request = request;
        this.rejected = rejected;
        this.uri = null;
        this.resolvedURI = null;
        this.resolved = false;
    }

    public ResourceResponse(ResourceRequest request, URI uri) {
        this.request = request;
        this.rejected = false;
        this.uri = uri;
        this.resolvedURI = uri;
        this.resolved = false;
        if (uri != null) {
            if (("jar".equals(uri.getScheme()) || "classpath".equals(uri.getScheme())) && request.config.getFeature(ResolverFeature.MASK_JAR_URIS).booleanValue()) {
                try {
                    this.uri = request.getAbsoluteURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.resolved = true;
        }
    }

    void setConnection(ResourceConnection conn) {
        this.connection = conn;
    }

    public ResourceConnection getConnection() {
        return this.connection;
    }

    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    void setInputStream(InputStream stream) {
        this.stream = stream;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    void setRejected(boolean rejected) {
        this.rejected = rejected;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    void setResolvedURI(URI uri) {
        this.resolvedURI = uri;
    }

    public URI getResolvedURI() {
        if (this.resolvedURI != null && (this.resolvedURI.getScheme().equals("jar") || this.resolvedURI.getScheme().equals("classpath")) && this.request.config.getFeature(ResolverFeature.MASK_JAR_URIS).booleanValue()) {
            return this.uri;
        }
        return this.resolvedURI;
    }

    public URI getUnmaskedURI() {
        return this.resolvedURI;
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    void setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        if (name != null) {
            name = name.toLowerCase();
        }
        for (String key : this.headers.keySet()) {
            if ((name != null || key != null) && (name == null || !name.equals(key.toLowerCase()))) continue;
            List<String> value = this.headers.get(key);
            if (value == null || value.isEmpty()) {
                return null;
            }
            return value.get(0);
        }
        return null;
    }

    void setStatusCode(int code) {
        this.statusCode = code;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

