/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.URIResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverConstants;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.adapters.LSResourceAdapter;
import org.xmlresolver.adapters.SAX1Adapter;
import org.xmlresolver.adapters.SAX2Adapter;
import org.xmlresolver.adapters.XercesXniAdapter;
import org.xmlresolver.adapters.XmlStreamAdapter;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.sources.ResolverSAXSource;
import org.xmlresolver.utils.URIUtils;

public class XMLResolver {
    protected final ResolverConfiguration config;
    protected final ResolverLogger logger;

    public XMLResolver() {
        this(new XMLResolverConfiguration());
    }

    public XMLResolver(ResolverConfiguration config) {
        this.config = config;
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public ResolverConfiguration getConfiguration() {
        return this.config;
    }

    public ResourceRequest getRequest(String uri) {
        return this.getRequest(uri, null, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
    }

    public ResourceRequest getRequest(String uri, String baseUri) {
        return this.getRequest(uri, baseUri, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
    }

    public ResourceRequest getRequest(String uri, String nature, String purpose) {
        return this.getRequest(uri, null, nature, purpose);
    }

    public ResourceRequest getRequest(String uri, String baseUri, String nature, String purpose) {
        ResourceRequest request = new ResourceRequest(this.config, nature, purpose);
        request.setURI(uri);
        request.setBaseURI(baseUri);
        return request;
    }

    public ResourceResponse lookupEntity(String publicId, String systemId) {
        return this.lookupEntity(publicId, systemId, null);
    }

    public ResourceResponse lookupEntity(String publicId, String systemId, String baseUri) {
        ResourceRequest request = this.getRequest(systemId, "https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity", ResolverConstants.ANY_PURPOSE);
        request.setURI(systemId);
        request.setBaseURI(baseUri);
        request.setPublicId(publicId);
        return this.lookup(request);
    }

    public ResourceResponse lookupDoctype(String name) {
        return this.lookupDoctype(name, null, null, null);
    }

    public ResourceResponse lookupDoctype(String name, String publicId, String systemId) {
        return this.lookupDoctype(name, null, null, null);
    }

    public ResourceResponse lookupDoctype(String name, String publicId, String systemId, String baseUri) {
        ResourceRequest request = this.getRequest(systemId, "https://www.iana.org/assignments/media-types/application/xml-dtd", ResolverConstants.ANY_PURPOSE);
        request.setEntityName(name);
        request.setPublicId(publicId);
        request.setBaseURI(baseUri);
        return this.lookup(request);
    }

    public ResourceResponse lookupUri(String href) {
        return this.lookupUri(href, null);
    }

    public ResourceResponse lookupUri(String href, String baseUri) {
        ResourceRequest request = this.getRequest(href, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
        request.setURI(href);
        request.setBaseURI(baseUri);
        return this.lookup(request);
    }

    public ResourceResponse lookupNamespace(String href, String nature, String purpose) {
        ResourceRequest request = this.getRequest(href, nature, purpose);
        request.setURI(href);
        return this.lookup(request);
    }

    public ResourceResponse lookup(ResourceRequest request) {
        CatalogManager manager = this.config.getFeature(ResolverFeature.CATALOG_MANAGER);
        if ("https://www.iana.org/assignments/media-types/application/xml-dtd".equals(request.nature)) {
            return this.lookupDtd(request, manager);
        }
        if ("https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity".equals(request.nature)) {
            return this.lookupEntity(request, manager);
        }
        ResourceResponse response = this.lookupUri(request, manager);
        if (response.isResolved()) {
            return response;
        }
        if (request.nature == null && !(response = this.lookupEntity(request, manager)).isResolved() && request.getEntityName() != null) {
            response = this.lookupDtd(request, manager);
        }
        return response;
    }

    private ResourceResponse lookupDtd(ResourceRequest request, CatalogManager manager) {
        URI absuri;
        String name = request.getEntityName();
        String publicId = request.getPublicId();
        String systemId = request.getSystemId();
        String baseUri = request.getBaseURI();
        if (name == null) {
            throw new NullPointerException("Name must not be null for DTD lookup");
        }
        URI found = manager.lookupDoctype(name, systemId, publicId);
        if (found == null && baseUri != null && (absuri = this.makeAbsolute(request)) != null) {
            found = manager.lookupDoctype(name, absuri.toString(), publicId);
        }
        return new ResourceResponse(request, found);
    }

    private ResourceResponse lookupEntity(ResourceRequest request, CatalogManager manager) {
        String name = request.getEntityName();
        String publicId = request.getPublicId();
        String systemId = request.getSystemId();
        String baseUri = request.getBaseURI();
        String allowed = this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY);
        if (name == null && publicId == null && systemId == null && baseUri == null) {
            this.logger.log("request", "lookupEntity: null", new Object[0]);
            return new ResourceResponse(request);
        }
        URI systemIdURI = this.makeUri(systemId);
        if (systemIdURI != null && systemIdURI.isAbsolute() && URIUtils.forbidAccess(allowed, systemId, this.config.getFeature(ResolverFeature.MERGE_HTTPS))) {
            this.logger.log("request", "lookupEntity (access denied): %s", systemIdURI.toString());
            return new ResourceResponse(request, true);
        }
        this.logger.log("request", "lookupEntity: %s%s (baseURI: %s, publicId: %s)", name == null ? "" : name + " ", systemId, baseUri, publicId);
        URI resolved = null;
        resolved = manager.lookupEntity(name, systemId, publicId);
        if (resolved == null && systemId != null && this.config.getFeature(ResolverFeature.URI_FOR_SYSTEM).booleanValue()) {
            resolved = manager.lookupURI(systemId);
        }
        if (resolved != null) {
            return new ResourceResponse(request, resolved);
        }
        URI absSystem = this.makeAbsolute(request);
        if (absSystem != null) {
            if (URIUtils.forbidAccess(allowed, absSystem.toString(), this.config.getFeature(ResolverFeature.MERGE_HTTPS))) {
                this.logger.log("request", "lookupEntity: (access denied): null", new Object[0]);
                return new ResourceResponse(request, true);
            }
            resolved = manager.lookupEntity(name, absSystem.toString(), publicId);
            if (resolved == null && this.config.getFeature(ResolverFeature.URI_FOR_SYSTEM).booleanValue()) {
                resolved = manager.lookupURI(absSystem.toString());
            }
        }
        if (resolved == null) {
            if (this.config.getFeature(ResolverFeature.ALWAYS_RESOLVE).booleanValue()) {
                if (absSystem == null) {
                    return new ResourceResponse(request);
                }
                return new ResourceResponse(request, absSystem);
            }
            return new ResourceResponse(request);
        }
        return new ResourceResponse(request, resolved);
    }

    private ResourceResponse lookupUri(ResourceRequest request, CatalogManager manager) {
        URI systemIdURI;
        String systemId = request.getSystemId();
        String baseUri = request.getBaseURI();
        String allowed = this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT);
        if (systemId == null && baseUri == null) {
            this.logger.log("request", "lookupUri: null", new Object[0]);
            return new ResourceResponse(request);
        }
        if (systemId == null) {
            systemId = baseUri;
        }
        if ((systemIdURI = this.makeUri(systemId)) != null && systemIdURI.isAbsolute() && URIUtils.forbidAccess(allowed, systemId, this.config.getFeature(ResolverFeature.MERGE_HTTPS))) {
            this.logger.log("request", "lookupUri (access denied): null", new Object[0]);
            return new ResourceResponse(request, true);
        }
        this.logger.log("request", "lookupUri: %s (baseURI: %s)", systemId, baseUri);
        URI resolved = manager.lookupNamespaceURI(systemId, request.nature, request.purpose);
        if (resolved != null) {
            return new ResourceResponse(request, resolved);
        }
        URI absSystem = this.makeAbsolute(request);
        if (absSystem != null) {
            if (URIUtils.forbidAccess(allowed, absSystem.toString(), this.config.getFeature(ResolverFeature.MERGE_HTTPS))) {
                this.logger.log("request", "lookupUri (access denied): null", new Object[0]);
                return new ResourceResponse(request, true);
            }
            resolved = manager.lookupNamespaceURI(absSystem.toString(), request.nature, request.purpose);
        }
        if (resolved == null) {
            if (this.config.getFeature(ResolverFeature.ALWAYS_RESOLVE).booleanValue()) {
                if (absSystem == null) {
                    return new ResourceResponse(request);
                }
                return new ResourceResponse(request, absSystem);
            }
            return new ResourceResponse(request);
        }
        return new ResourceResponse(request, resolved);
    }

    public ResourceResponse resolve(ResourceRequest request) {
        ResourceResponse lookup = this.lookup(request);
        if (lookup.isRejected()) {
            return lookup;
        }
        boolean tryRddl = this.config.getFeature(ResolverFeature.PARSE_RDDL) != false && lookup.request.nature != null && lookup.request.purpose != null;
        try {
            if (tryRddl) {
                if (lookup.isResolved()) {
                    lookup = this.rddlLookup(lookup);
                } else if (lookup.request.getAbsoluteURI() != null) {
                    lookup = this.rddlLookup(lookup, lookup.request.getAbsoluteURI());
                }
            }
            if (!lookup.isResolved()) {
                if (this.config.getFeature(ResolverFeature.ALWAYS_RESOLVE).booleanValue()) {
                    return this.config.getResource(lookup);
                }
                return lookup;
            }
            return this.config.getResource(lookup);
        }
        catch (IOException | URISyntaxException ex) {
            boolean throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            if (throwExceptions) {
                this.logger.log("error", ex.getMessage(), new Object[0]);
                throw new IllegalArgumentException(ex);
            }
            return lookup;
        }
    }

    private ResourceResponse rddlLookup(ResourceResponse lookup) {
        return this.rddlLookup(lookup, lookup.getResolvedURI());
    }

    private ResourceResponse rddlLookup(ResourceResponse lookup, URI resolved) {
        String nature = lookup.request.nature;
        String purpose = lookup.request.purpose;
        URI rddl = this.checkRddl(resolved, nature, purpose);
        if (rddl == null) {
            return lookup;
        }
        ResourceRequest rddlRequest = new ResourceRequest(this.config, ResolverConstants.ANY_NATURE, ResolverConstants.ANY_PURPOSE);
        rddlRequest.setURI(rddl.toString());
        rddlRequest.setBaseURI(resolved.toString());
        ResourceResponse resp = this.lookup(rddlRequest);
        if (!resp.isResolved()) {
            this.logger.log("response", "RDDL %s: %s", resolved, rddl);
            return new ResourceResponse(lookup.request, rddl);
        }
        this.logger.log("response", "RDDL %s: %s", resolved, resp.getURI());
        return resp;
    }

    private URI checkRddl(URI uri, String nature, String purpose) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            spf.setXIncludeAware(false);
            ResourceRequest req = new ResourceRequest(this.config, nature, purpose);
            req.setURI(uri.toString());
            ResourceResponse rsrc = this.config.getResource(req);
            String contentType = rsrc.getContentType();
            if (contentType != null && (contentType.startsWith("text/html") || contentType.startsWith("application/html+xml") || contentType.startsWith("application/xhtml+xml"))) {
                InputSource source = new InputSource(rsrc.getInputStream());
                RddlQuery handler = new RddlQuery(rsrc.getURI(), nature, purpose);
                SAXParser parser = spf.newSAXParser();
                parser.parse(source, (DefaultHandler)handler);
                return handler.href();
            }
            return null;
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | ParserConfigurationException | SAXException ex) {
            this.logger.log("error", "RDDL parse failed: %s: %s", uri, ex.getMessage());
            return null;
        }
    }

    public URIResolver getURIResolver() {
        return (href, base) -> {
            ResourceRequest request = this.getRequest(href, base);
            ResourceResponse resp = this.resolve(request);
            ResolverSAXSource source = null;
            if (resp.isResolved()) {
                source = new ResolverSAXSource(resp);
                source.setSystemId(resp.getURI().toString());
            }
            return source;
        };
    }

    public SAX1Adapter getEntityResolver() {
        return new SAX1Adapter(this);
    }

    public SAX2Adapter getEntityResolver2() {
        return new SAX2Adapter(this);
    }

    public LSResourceAdapter getLSResourceResolver() {
        return new LSResourceAdapter(this);
    }

    public javax.xml.stream.XMLResolver getXMLResolver() {
        return new XmlStreamAdapter(this);
    }

    public XercesXniAdapter getXMLEntityResolver() {
        return new XercesXniAdapter(this);
    }

    private URI makeUri(String uri) {
        block3: {
            if (uri != null) {
                boolean throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
                try {
                    return new URI(uri);
                }
                catch (URISyntaxException ex) {
                    this.logger.log("error", "URI exception: %s", uri);
                    if (!throwExceptions) break block3;
                    throw new IllegalArgumentException(ex);
                }
            }
        }
        return null;
    }

    private URI makeAbsolute(ResourceRequest request) {
        block3: {
            boolean throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
            try {
                URI absuri = request.getAbsoluteURI();
                if (absuri != null && !absuri.toString().equals(request.getURI())) {
                    return absuri;
                }
            }
            catch (URISyntaxException ex) {
                this.logger.log("error", "URI exception: %s", ex.getMessage());
                if (!throwExceptions) break block3;
                throw new IllegalArgumentException(ex);
            }
        }
        return null;
    }

    private static class RddlQuery
    extends DefaultHandler {
        private final String nature;
        private final String purpose;
        private URI found = null;
        private final Stack<URI> baseUriStack = new Stack();

        public RddlQuery(URI baseURI, String nature, String purpose) {
            this.nature = nature;
            this.purpose = purpose;
            this.baseUriStack.push(baseURI);
        }

        public URI href() {
            return this.found;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("http://www.w3.org/1999/xhtml".equals(uri) && attributes.getValue("", "base") != null) {
                this.baseUriStack.push(this.baseUriStack.peek().resolve(attributes.getValue("", "base")));
            } else if (attributes.getValue("http://www.w3.org/XML/1998/namespace", "base") != null) {
                this.baseUriStack.push(this.baseUriStack.peek().resolve(attributes.getValue("http://www.w3.org/XML/1998/namespace", "base")));
            } else {
                this.baseUriStack.push(this.baseUriStack.peek());
            }
            if (this.found == null && "http://www.rddl.org/".equals(uri) && "resource".equals(localName)) {
                String rnature = attributes.getValue("http://www.w3.org/1999/xlink", "role");
                String rpurpose = attributes.getValue("http://www.w3.org/1999/xlink", "arcrole");
                String href = attributes.getValue("http://www.w3.org/1999/xlink", "href");
                if (this.nature.equals(rnature) && this.purpose.equals(rpurpose) && href != null) {
                    this.found = this.baseUriStack.peek().resolve(href);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.baseUriStack.pop();
        }
    }
}

