/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.binding.xpath.PSXPathVariables;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.helger.schematron.pure.model.PSRule;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundRule {
    private final PSRule m_aRule;
    private final String m_sRuleContext;
    private final XPathExpression m_aBoundRuleContext;
    private final ICommonsList<PSXPathBoundAssertReport> m_aBoundAssertReports;
    private final PSXPathVariables m_aVariables;

    public PSXPathBoundRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnull XPathExpression xPathExpression, @Nonnull ICommonsList<PSXPathBoundAssertReport> iCommonsList, @Nonnull PSXPathVariables pSXPathVariables) {
        ValueEnforcer.notNull((Object)pSRule, (String)"Rule");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RuleContext");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"BoundRuleContext");
        ValueEnforcer.notNull(iCommonsList, (String)"BoundAssertReports");
        ValueEnforcer.notNull((Object)pSXPathVariables, (String)"Variables");
        this.m_aRule = pSRule;
        this.m_sRuleContext = string;
        this.m_aBoundRuleContext = xPathExpression;
        this.m_aBoundAssertReports = iCommonsList;
        this.m_aVariables = pSXPathVariables;
    }

    @Nonnull
    public final PSRule getRule() {
        return this.m_aRule;
    }

    @Nonnull
    public final String getRuleContext() {
        return this.m_sRuleContext;
    }

    @Nonnull
    public final XPathExpression getBoundRuleContext() {
        return this.m_aBoundRuleContext;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<PSXPathBoundAssertReport> boundAssertReports() {
        return this.m_aBoundAssertReports;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<PSXPathBoundAssertReport> getAllBoundAssertReports() {
        return (ICommonsList)this.m_aBoundAssertReports.getClone();
    }

    @Nonnull
    public final PSXPathVariables getVariables() {
        return this.m_aVariables;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Rule", (Object)this.m_aRule).append("RuleExpression", (Object)this.m_sRuleContext).append("BoundRuleExpression", (Object)this.m_aBoundRuleContext).append("BoundAssertReports", this.m_aBoundAssertReports).append("Variables", (Object)this.m_aVariables).getToString();
    }
}

