/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.thread;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsNavigableSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.timing.StopWatch;
import com.helger.xml.microdom.IHasMicroNodeRepresentation;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.util.thread.ThreadDescriptor;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ThreadDescriptorList
implements IHasMicroNodeRepresentation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDescriptorList.class);
    private final ICommonsList<ThreadDescriptor> m_aList = new CommonsArrayList();
    private String m_sError;

    @Nonnull
    public ThreadDescriptorList addDescriptor(@Nonnull ThreadDescriptor threadDescriptor) {
        ValueEnforcer.notNull((Object)threadDescriptor, (String)"Descriptor");
        this.m_aList.add((Object)threadDescriptor);
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ThreadDescriptor> getAllDescriptors() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Nonnull
    public ThreadDescriptorList setError(@Nullable String string) {
        this.m_sError = string;
        return this;
    }

    @Nullable
    public String getError() {
        return this.m_sError;
    }

    @Nonnull
    @ReturnsMutableCopy
    private ICommonsMap<Thread.State, ICommonsNavigableSet<Long>> _getStateMap() {
        CommonsEnumMap commonsEnumMap = new CommonsEnumMap(Thread.State.class);
        for (ThreadDescriptor threadDescriptor : this.m_aList) {
            Thread.State state2 = threadDescriptor.getThreadState();
            ICommonsNavigableSet iCommonsNavigableSet = (ICommonsNavigableSet)commonsEnumMap.computeIfAbsent((Object)state2, state -> new CommonsTreeSet());
            iCommonsNavigableSet.add((Object)threadDescriptor.getThreadID());
        }
        return commonsEnumMap;
    }

    @Nonnull
    @Nonempty
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText((String)this.m_sError)) {
            stringBuilder.append("ERROR retrieving all thread stack traces: ").append(this.m_sError).append("\n\n");
        }
        stringBuilder.append("Total thread count: ").append(this.m_aList.size()).append('\n');
        ICommonsMap<Thread.State, ICommonsNavigableSet<Long>> iCommonsMap = this._getStateMap();
        for (Thread.State state : Thread.State.values()) {
            ICommonsSet iCommonsSet = (ICommonsSet)iCommonsMap.get((Object)state);
            int n = iCommonsSet.size();
            stringBuilder.append("Thread state ").append((Object)state).append(" [").append(n).append(']');
            if (n > 0) {
                stringBuilder.append(": ").append(iCommonsSet.toString());
            }
            stringBuilder.append('\n');
        }
        for (ThreadDescriptor threadDescriptor : this.m_aList) {
            stringBuilder.append('\n').append(threadDescriptor.getAsString());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroNode() {
        MicroElement microElement = new MicroElement("threadlist");
        if (StringHelper.hasText((String)this.m_sError)) {
            microElement.appendElement("error").appendText(this.m_sError);
        }
        microElement.setAttribute("threadcount", this.m_aList.size());
        ICommonsMap<Thread.State, ICommonsNavigableSet<Long>> iCommonsMap = this._getStateMap();
        for (Thread.State state : Thread.State.values()) {
            ICommonsSet iCommonsSet = (ICommonsSet)iCommonsMap.get((Object)state);
            int n = iCommonsSet.size();
            IMicroElement iMicroElement = microElement.appendElement("threadstate");
            iMicroElement.setAttribute("id", state.toString());
            iMicroElement.setAttribute("threadcount", n);
            if (n <= 0) continue;
            iMicroElement.appendText(StringHelper.getImploded((char)',', (Iterable)iCommonsSet));
        }
        for (ThreadDescriptor threadDescriptor : this.m_aList) {
            microElement.appendChild(threadDescriptor.getAsMicroNode());
        }
        return microElement;
    }

    @Nonnull
    @Nonempty
    private static String _getAsString(@Nonnull Throwable throwable) {
        return throwable.getMessage() + " -- " + throwable.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ThreadDescriptorList createWithAllThreads() {
        StopWatch stopWatch = StopWatch.createdStarted();
        ThreadDescriptorList threadDescriptorList = new ThreadDescriptorList();
        try {
            for (Map.Entry entry : CollectionHelper.getSortedByKey(Thread.getAllStackTraces(), Comparator.comparing(Thread::getId)).entrySet()) {
                Object[] objectArray = (StackTraceElement[])entry.getValue();
                String string = ArrayHelper.isEmpty((Object[])objectArray) ? "No stack trace available!\n" : StackTraceHelper.getStackAsString((StackTraceElement[])objectArray, (boolean)false);
                threadDescriptorList.addDescriptor(new ThreadDescriptor((Thread)entry.getKey(), string));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error collecting all thread descriptors", (Throwable)exception);
            threadDescriptorList.setError("Error collecting all thread descriptors: " + ThreadDescriptorList._getAsString(exception));
        }
        finally {
            long l = stopWatch.stopAndGetMillis();
            if (l > 1000L) {
                LOGGER.warn("Took " + l + " ms to get all thread descriptors!");
            }
        }
        return threadDescriptorList;
    }
}

