/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.sources;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.w3c.dom.ls.LSInput;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.sources.ResolverResourceInfo;
import org.xmlresolver.utils.RsrcUtils;

public class ResolverLSInput
implements LSInput,
ResolverResourceInfo {
    private final ResourceResponse response;
    private final URI resolvedURI;
    final String publicId;
    final String systemId;
    final InputStream body;
    final URI uri;
    private final int statusCode;
    private final Map<String, List<String>> resolvedHeaders;

    public ResolverLSInput(ResourceResponse resp, String publicId) {
        this.resolvedURI = resp.getResolvedURI();
        this.response = resp;
        this.body = resp.getInputStream();
        this.systemId = resp.getResolvedURI().toString();
        this.publicId = publicId;
        this.uri = resp.getURI();
        this.statusCode = resp.getStatusCode();
        this.resolvedHeaders = resp.getHeaders();
    }

    @Override
    public Reader getCharacterStream() {
        return new InputStreamReader(this.body);
    }

    @Override
    public void setCharacterStream(Reader reader) {
        throw new UnsupportedOperationException("Can't set character stream on resolver LSInput");
    }

    @Override
    public InputStream getByteStream() {
        return this.body;
    }

    @Override
    public void setByteStream(InputStream inputStream) {
        throw new UnsupportedOperationException("Can't set byte stream on resolver LSInput");
    }

    @Override
    public String getStringData() {
        return null;
    }

    @Override
    public void setStringData(String string) {
        throw new UnsupportedOperationException("Can't set string data on resolver LSInput");
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String string) {
        throw new UnsupportedOperationException("Can't set system ID on resolver LSInput");
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String string) {
        throw new UnsupportedOperationException("Can't set public ID on resolver LSInput");
    }

    @Override
    public String getBaseURI() {
        return this.uri.toString();
    }

    @Override
    public void setBaseURI(String string) {
        throw new UnsupportedOperationException("Can't set base URI on resolver LSInput");
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public void setEncoding(String string) {
        throw new UnsupportedOperationException("Can't set encoding on resolver LSInput");
    }

    @Override
    public boolean getCertifiedText() {
        return false;
    }

    @Override
    public void setCertifiedText(boolean b) {
        throw new UnsupportedOperationException("Can't set certified text on resolver LSInput");
    }

    @Override
    public ResourceResponse getResponse() {
        return this.response;
    }

    @Override
    public URI getResolvedURI() {
        return this.resolvedURI;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.resolvedHeaders;
    }

    @Override
    public String getHeader(String headerName) {
        return RsrcUtils.getHeader(headerName, this.resolvedHeaders);
    }
}

