/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.loaders;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.ResourceAccess;
import org.xmlresolver.ResourceRequest;
import org.xmlresolver.ResourceResponse;
import org.xmlresolver.XMLResolver;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.exceptions.CatalogInvalidException;
import org.xmlresolver.exceptions.CatalogUnavailableException;
import org.xmlresolver.loaders.CatalogLoader;
import org.xmlresolver.loaders.XmlLoader;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.utils.SaxProducer;

public class ValidatingXmlLoader
implements CatalogLoader {
    protected final ResolverConfiguration config;
    protected final ResolverLogger logger;
    protected final HashMap<URI, EntryCatalog> catalogMap;
    private final XMLResolver resolver;
    private final XmlLoader underlyingLoader;

    public ValidatingXmlLoader(ResolverConfiguration config) {
        this.config = config;
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        this.underlyingLoader = new XmlLoader(config);
        this.resolver = XmlLoader.getLoaderResolver();
        this.catalogMap = new HashMap();
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.underlyingLoader.setEntityResolver(resolver);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.underlyingLoader.getEntityResolver();
    }

    @Override
    public EntryCatalog loadCatalog(URI catalog) {
        if (this.catalogMap.containsKey(catalog)) {
            return this.catalogMap.get(catalog);
        }
        try {
            ResourceRequest request = new ResourceRequest(this.config);
            request.setURI(catalog);
            request.setOpenStream(true);
            ResourceResponse resp = ResourceAccess.getResource(request);
            InputSource source = new InputSource(resp.getInputStream());
            source.setSystemId(catalog.toString());
            return this.loadCatalog(catalog, source);
        }
        catch (CatalogUnavailableException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                this.logger.log("warning", "Failed to load catalog: %s: %s", catalog, ex.getMessage());
                this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
                return this.catalogMap.get(catalog);
            }
            this.logger.log("error", "Failed to load catalog: %s: %s", catalog, ex.getMessage());
            this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
            throw ex;
        }
        catch (IOException | URISyntaxException ex) {
            this.logger.log("error", "Failed to load catalog: %s: %s", catalog, ex.getMessage());
            this.catalogMap.put(catalog, new EntryCatalog(this.config, catalog, null, false));
            throw new CatalogUnavailableException(ex);
        }
    }

    @Override
    public EntryCatalog loadCatalog(URI catalog, InputSource source) {
        try {
            ByteArrayOutputStream baos = null;
            if (source.getByteStream() != null) {
                baos = new ByteArrayOutputStream();
                InputStream instream = source.getByteStream();
                byte[] buf = new byte[4096];
                int readLen = instream.read(buf, 0, buf.length);
                while (readLen >= 0) {
                    baos.write(buf, 0, readLen);
                    readLen = instream.read(buf, 0, buf.length);
                }
                source.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
            }
            CharArrayWriter caw = null;
            if (source.getCharacterStream() != null) {
                caw = new CharArrayWriter();
                Reader instream = source.getCharacterStream();
                char[] buf = new char[4096];
                int readLen = instream.read(buf, 0, buf.length);
                while (readLen >= 0) {
                    caw.write(buf, 0, readLen);
                    readLen = instream.read(buf, 0, buf.length);
                }
                source.setCharacterStream(new CharArrayReader(caw.toCharArray()));
            }
            MyErrorHandler errorHandler = new MyErrorHandler(this.config);
            PropertyMapBuilder builder = new PropertyMapBuilder();
            builder.put(ValidateProperty.ERROR_HANDLER, (Object)errorHandler);
            builder.put(ValidateProperty.ENTITY_RESOLVER, (Object)this.resolver.getEntityResolver2());
            builder.put(ValidateProperty.URI_RESOLVER, (Object)this.resolver.getURIResolver());
            ValidationDriver driver = new ValidationDriver(builder.toPropertyMap(), builder.toPropertyMap(), null);
            URL schemaUrl = ValidatingXmlLoader.class.getResource("/org/xmlresolver/schemas/oasis-xml-catalog-1.1.rng");
            if (schemaUrl == null) {
                throw new CatalogInvalidException("Failed to read catalog schema resource");
            }
            InputStream schemaStream = schemaUrl.openStream();
            InputSource schema = new InputSource(schemaStream);
            if (!driver.loadSchema(schema)) {
                if (errorHandler.getMessage() == null) {
                    throw new CatalogInvalidException("Failed to load catalog schema");
                }
                throw new CatalogInvalidException("Failed to load catalog schema: " + errorHandler.getMessage());
            }
            if (!driver.validate(source)) {
                String msg = errorHandler.getMessage();
                throw new CatalogInvalidException("Catalog '" + catalog.toString() + "' is invalid: " + msg);
            }
            if (baos != null) {
                source.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
            }
            if (caw != null) {
                source.setCharacterStream(new CharArrayReader(caw.toCharArray()));
            }
        }
        catch (IOException | SAXException ex) {
            throw new CatalogUnavailableException(ex);
        }
        return this.underlyingLoader.loadCatalog(catalog, source);
    }

    @Override
    public EntryCatalog loadCatalog(URI catalog, SaxProducer producer) {
        try {
            MyErrorHandler errorHandler = new MyErrorHandler(this.config);
            PropertyMapBuilder builder = new PropertyMapBuilder();
            builder.put(ValidateProperty.ERROR_HANDLER, (Object)errorHandler);
            builder.put(ValidateProperty.ENTITY_RESOLVER, (Object)this.resolver.getEntityResolver2());
            builder.put(ValidateProperty.URI_RESOLVER, (Object)this.resolver.getURIResolver());
            ValidationDriver driver = new ValidationDriver(builder.toPropertyMap(), builder.toPropertyMap(), null);
            URL schemaUrl = ValidatingXmlLoader.class.getResource("/org/xmlresolver/schemas/oasis-xml-catalog-1.1.rng");
            if (schemaUrl == null) {
                throw new CatalogInvalidException("Failed to read catalog schema resource");
            }
            InputStream schemaStream = schemaUrl.openStream();
            InputSource schema = new InputSource(schemaStream);
            if (!driver.loadSchema(schema)) {
                if (errorHandler.getMessage() == null) {
                    throw new CatalogInvalidException("Failed to load catalog schema");
                }
                throw new CatalogInvalidException("Failed to load catalog schema: " + errorHandler.getMessage());
            }
            if (!driver.validate(SaxProducer.adaptForJing(producer))) {
                String msg = errorHandler.getMessage();
                throw new CatalogInvalidException("Catalog '" + catalog.toString() + "' is invalid: " + msg);
            }
        }
        catch (IOException | SAXException ex) {
            throw new CatalogUnavailableException(ex.getMessage());
        }
        return this.underlyingLoader.loadCatalog(catalog, producer);
    }

    @Override
    public void setPreferPublic(boolean prefer) {
        this.underlyingLoader.setPreferPublic(prefer);
    }

    @Override
    public boolean getPreferPublic() {
        return this.underlyingLoader.getPreferPublic();
    }

    @Override
    public void setArchivedCatalogs(boolean allow) {
        this.underlyingLoader.setArchivedCatalogs(allow);
    }

    @Override
    public boolean getArchivedCatalogs() {
        return this.underlyingLoader.getArchivedCatalogs();
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private final ResolverConfiguration config;
        private final ResolverLogger logger;
        private String firstError = null;
        private String firstWarning = null;

        public MyErrorHandler(ResolverConfiguration config) {
            this.config = config;
            this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (this.firstWarning == null) {
                this.firstWarning = exception.getMessage();
            }
            this.logger.log("warning", exception.getMessage(), new Object[0]);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (this.firstError == null) {
                this.firstError = exception.getMessage();
            }
            this.logger.log("error", exception.getMessage(), new Object[0]);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.firstError = exception.getMessage();
            this.logger.log("error", exception.getMessage(), new Object[0]);
        }

        public String getMessage() {
            return this.firstError == null ? this.firstWarning : this.firstError;
        }
    }
}

