/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.query;

import java.net.URI;
import java.util.ArrayList;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.catalog.entry.EntryDelegateSystem;
import org.xmlresolver.catalog.entry.EntryRewriteSystem;
import org.xmlresolver.catalog.entry.EntrySystem;
import org.xmlresolver.catalog.entry.EntrySystemSuffix;
import org.xmlresolver.catalog.query.QueryCatalog;
import org.xmlresolver.catalog.query.QueryDelegateSystem;
import org.xmlresolver.catalog.query.QueryResult;
import org.xmlresolver.catalog.query.QueryUri;
import org.xmlresolver.utils.URIUtils;

public class QuerySystem
extends QueryCatalog {
    public final String systemId;

    public QuerySystem(String systemId) {
        this.systemId = systemId;
    }

    @Override
    protected QueryResult lookup(CatalogManager manager, EntryCatalog catalog) {
        String compareSystem = manager.normalizedForComparison(this.systemId);
        String osname = System.getProperty("os.name").toLowerCase();
        boolean ignoreFScase = osname.contains("windows") || osname.contains("mac");
        String lowerCaseSystemId = compareSystem.toLowerCase();
        for (Entry raw : catalog.entries(Entry.Type.SYSTEM)) {
            EntrySystem entry = (EntrySystem)raw;
            String entrySystem = manager.normalizedForComparison(entry.systemId);
            if (!entrySystem.equals(compareSystem) && (!ignoreFScase || !entrySystem.equalsIgnoreCase(compareSystem))) continue;
            return new QueryResult(entry.uri);
        }
        EntryRewriteSystem rewrite = null;
        String rewriteStart = null;
        for (Entry raw : catalog.entries(Entry.Type.REWRITE_SYSTEM)) {
            EntryRewriteSystem entry = (EntryRewriteSystem)raw;
            String string = manager.normalizedForComparison(entry.systemIdStart);
            if (!compareSystem.startsWith(string) && (!ignoreFScase || !lowerCaseSystemId.startsWith(string.toLowerCase())) || rewrite != null && string.length() <= rewriteStart.length()) continue;
            rewrite = entry;
            rewriteStart = string;
        }
        if (rewrite != null) {
            URI resolved = URIUtils.resolve(rewrite.rewritePrefix, compareSystem.substring(rewriteStart.length()));
            return new QueryResult(resolved);
        }
        EntrySystemSuffix suffix = null;
        String systemSuffix = null;
        for (Entry entry : catalog.entries(Entry.Type.SYSTEM_SUFFIX)) {
            EntrySystemSuffix entry2 = (EntrySystemSuffix)entry;
            String compareSuffix = manager.normalizedForComparison(entry2.systemIdSuffix);
            if (!compareSystem.endsWith(compareSuffix) && (!ignoreFScase || !lowerCaseSystemId.endsWith(compareSuffix.toLowerCase())) || suffix != null && compareSuffix.length() <= systemSuffix.length()) continue;
            suffix = entry2;
            systemSuffix = compareSuffix;
        }
        if (suffix != null) {
            return new QueryResult(suffix.uri);
        }
        ArrayList<EntryDelegateSystem> delegated = new ArrayList<EntryDelegateSystem>();
        for (Entry raw : catalog.entries(Entry.Type.DELEGATE_SYSTEM)) {
            int pos;
            EntryDelegateSystem entry = (EntryDelegateSystem)raw;
            String delegateStart = manager.normalizedForComparison(entry.systemIdStart);
            if (!compareSystem.startsWith(delegateStart) && (!ignoreFScase || !lowerCaseSystemId.startsWith(delegateStart.toLowerCase()))) continue;
            for (pos = 0; pos < delegated.size() && delegateStart.length() <= manager.normalizedForComparison(((EntryDelegateSystem)delegated.get((int)pos)).systemIdStart).length(); ++pos) {
            }
            delegated.add(pos, entry);
        }
        if (!delegated.isEmpty()) {
            ArrayList<URI> arrayList = new ArrayList<URI>();
            for (EntryDelegateSystem entry : delegated) {
                arrayList.add(entry.catalog);
            }
            return new QueryDelegateSystem(this.systemId, arrayList);
        }
        if (manager.getResolverConfiguration().getFeature(ResolverFeature.URI_FOR_SYSTEM).booleanValue()) {
            QueryUri queryUri = new QueryUri(this.systemId);
            return queryUri.lookup(manager, catalog);
        }
        return QueryResult.EMPTY_RESULT;
    }
}

