/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.validation;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.model.PSAssertReport;
import com.helger.schematron.pure.model.PSPattern;
import com.helger.schematron.pure.model.PSPhase;
import com.helger.schematron.pure.model.PSRule;
import com.helger.schematron.pure.model.PSSchema;
import com.helger.schematron.pure.validation.IPSValidationHandler;
import com.helger.schematron.pure.validation.SchematronValidationException;
import com.helger.xml.XMLDebug;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoggingPSValidationHandler
implements IPSValidationHandler {
    private final Logger m_aLogger;
    private IErrorLevel m_aLogLevel = EErrorLevel.INFO;
    private String m_sLogPrefix;

    public LoggingPSValidationHandler() {
        this(LoggerFactory.getLogger(LoggingPSValidationHandler.class));
    }

    public LoggingPSValidationHandler(@Nonnull Logger logger) {
        ValueEnforcer.notNull((Object)logger, (String)"Logger");
        this.m_aLogger = logger;
    }

    @Nonnull
    public final Logger getLogger() {
        return this.m_aLogger;
    }

    @Nonnull
    public final IErrorLevel getLogLevel() {
        return this.m_aLogLevel;
    }

    @Nonnull
    public final LoggingPSValidationHandler setLogLevel(@Nonnull IErrorLevel iErrorLevel) {
        ValueEnforcer.notNull((Object)iErrorLevel, (String)"LogLevel");
        this.m_aLogLevel = iErrorLevel;
        return this;
    }

    @Nullable
    public final String getLogPrefix() {
        return this.m_sLogPrefix;
    }

    @Nonnull
    public final LoggingPSValidationHandler setLogPrefix(@Nullable String string) {
        this.m_sLogPrefix = string;
        return this;
    }

    private void _log(@Nonnull String string) {
        LogHelper.log((Logger)this.m_aLogger, (IErrorLevel)this.m_aLogLevel, (String)StringHelper.getConcatenatedOnDemand((String)this.m_sLogPrefix, (String)string));
    }

    @Nonnull
    public static String getAsString(@Nonnull Node node) {
        return XMLDebug.getNodeTypeAsString((int)node.getNodeType()) + ": " + node.toString();
    }

    @Nonnull
    public static String getAsString(@Nonnull NodeList nodeList) {
        int n = nodeList.getLength();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NodeList[").append(n).append("](");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(LoggingPSValidationHandler.getAsString(nodeList.item(i)));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void onStart(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase, @Nullable String string) throws SchematronValidationException {
        this._log("onStart (" + String.valueOf(pSSchema) + ", " + String.valueOf(pSPhase) + ", " + string + ")");
    }

    @Override
    public void onPattern(@Nonnull PSPattern pSPattern) throws SchematronValidationException {
        this._log("onPattern (" + String.valueOf(pSPattern) + ")");
    }

    @Override
    public void onRuleStart(@Nonnull PSRule pSRule, @Nonnull NodeList nodeList) throws SchematronValidationException {
        this._log("onRuleStart (" + String.valueOf(pSRule) + ", " + LoggingPSValidationHandler.getAsString(nodeList) + ")");
    }

    @Override
    public void onFiredRule(@Nonnull PSRule pSRule, @Nonnull String string, @Nonnegative int n, @Nonnegative int n2) throws SchematronValidationException {
        this._log("onFiredRule (" + String.valueOf(pSRule) + ", " + string + ", " + n + ", " + n2 + ")");
    }

    @Override
    @Nonnull
    public EContinue onFailedAssert(@Nonnull PSRule pSRule, @Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object, @Nullable Exception exception) throws SchematronValidationException {
        this._log("onFailedAssert (" + String.valueOf(pSRule) + ", " + String.valueOf(pSAssertReport) + ", " + string + ", " + LoggingPSValidationHandler.getAsString(node) + ", " + n + ", " + String.valueOf(object) + ")");
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EContinue onSuccessfulReport(@Nonnull PSRule pSRule, @Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull Node node, int n, @Nullable Object object, @Nullable Exception exception) throws SchematronValidationException {
        this._log("onSuccessfulReport (" + String.valueOf(pSRule) + ", " + String.valueOf(pSAssertReport) + ", " + string + ", " + LoggingPSValidationHandler.getAsString(node) + ", " + n + ", " + String.valueOf(object) + ")");
        return EContinue.CONTINUE;
    }

    @Override
    public void onEnd(@Nonnull PSSchema pSSchema, @Nullable PSPhase pSPhase) throws SchematronValidationException {
        this._log("onEnd (" + String.valueOf(pSSchema) + ", " + String.valueOf(pSPhase) + ")");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Logger", (Object)this.m_aLogger).append("LogLevel", (Object)this.m_aLogLevel).append("LogPrefix", (Object)this.m_sLogPrefix).getToString();
    }
}

