/*
 * Decompiled with CFR 0.152.
 */
package com.inet.embeddedwebsites.structure;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.embeddedwebsites.EmbeddedWebsitesModule;
import com.inet.embeddedwebsites.EmbeddedWebsitesServerPlugin;
import com.inet.embeddedwebsites.structure.EmbeddedWebsitesIconConfigProperty;
import com.inet.embeddedwebsites.structure.SelectiveLoginConfigProperty;
import com.inet.embeddedwebsites.structure.a;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.TargetValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@JsonData
public class EmbeddedWebsitesListConfigProperty
extends ItemListConfigProperty {
    public static final String ACTION_ADD_WEBSITE = "embeddedwebsites.add";

    public EmbeddedWebsitesListConfigProperty(@Nonnull a provider, @Nonnull ConfigStructureSettings settings) {
        this(100, provider, settings, EmbeddedWebsitesListConfigProperty.getRowAction(provider, settings));
    }

    private EmbeddedWebsitesListConfigProperty(int sortid, @Nonnull a provider, @Nonnull ConfigStructureSettings settings, ConfigRowAction[] actions) {
        super(sortid, EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY.getKey(), "ItemList" + EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY.getKey(), EmbeddedWebsitesListConfigProperty.getEmbeddedWebsitesList(settings), provider.translate(settings, "embeddedwebsites.actions", new Object[0]), actions);
    }

    @Nonnull
    public static List<EmbeddedWebsitesModule> getEmbeddedWebsitesList(@Nonnull ConfigStructureSettings settings) {
        Json json = new Json();
        String string = settings.getChangedValue(EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY.getKey());
        if (string != null) {
            List list = (List)json.fromJson(string, (Type)new JsonParameterizedType(List.class, new Type[]{EmbeddedWebsitesModule.class}), new HashMap());
            return Objects.requireNonNullElse(list, List.of());
        }
        String string2 = settings.getValue(EmbeddedWebsitesServerPlugin.EMBEDDEDWEBSITES_CONFIGKEY);
        ArrayList<EmbeddedWebsitesModule> arrayList = new ArrayList<EmbeddedWebsitesModule>();
        if (string2 != null && string2.length() > 0) {
            List<EmbeddedWebsitesModule> list = Objects.requireNonNullElse((List)json.fromJson(string2, (Type)new JsonParameterizedType(List.class, new Type[]{EmbeddedWebsitesModule.class}), new HashMap()), List.of());
            for (EmbeddedWebsitesModule embeddedWebsitesModule : list) {
                String string3 = embeddedWebsitesModule.getSelectiveLogin();
                if (string3.isEmpty()) {
                    embeddedWebsitesModule.setSelectiveLogin(json.toJson((Object)TargetValue.getValue(new HashMap())));
                }
                embeddedWebsitesModule.setEmbeddedWebsitesIcons(EmbeddedWebsitesIconConfigProperty.getEntryValue((int[])new int[0]));
            }
            return list;
        }
        return arrayList;
    }

    private static ConfigRowAction[] getRowAction(@Nonnull a provider, @Nonnull ConfigStructureSettings settings) {
        ConfigAction configAction = new ConfigAction(ACTION_ADD_WEBSITE, provider.translate(settings, ACTION_ADD_WEBSITE, new Object[0]));
        ConfigCategory configCategory = new ConfigCategory(0, ACTION_ADD_WEBSITE, provider.translate(settings, ACTION_ADD_WEBSITE, new Object[0]), "components-embeddedwebsites");
        ArrayList<ConfigPropertyGroup> arrayList = new ArrayList<ConfigPropertyGroup>();
        arrayList.add(new ConfigPropertyGroup(0, "embeddedwebsites.add.group"));
        HashMap hashMap = new HashMap();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        hashMap.put("embeddedwebsites.add.group", arrayList2);
        arrayList2.add(EmbeddedWebsitesListConfigProperty.propWith("SimpleText", provider.translate(settings, "embeddedwebsites.name", new Object[0]), "name", "", ""));
        arrayList2.add(EmbeddedWebsitesListConfigProperty.propWith("SimpleText", provider.translate(settings, "embeddedwebsites.description", new Object[0]), "description", "", ""));
        arrayList2.add(EmbeddedWebsitesListConfigProperty.propWith("SimpleText", provider.translate(settings, "embeddedwebsites.path", new Object[0]), "path", "", provider.translate(settings, "embeddedwebsites.path.placeholder", new Object[0])));
        arrayList2.add(EmbeddedWebsitesListConfigProperty.propWith("Color", provider.translate(settings, "embeddedwebsites.color", new Object[0]), "color", EmbeddedWebsitesListConfigProperty.generateColor(), ""));
        arrayList2.add(EmbeddedWebsitesListConfigProperty.propWith("SimpleText", provider.translate(settings, "embeddedwebsites.targetUrl", new Object[0]), "targetUrl", "", provider.translate(settings, "embeddedwebsites.targetUrl.placeholder", new Object[0])));
        ArrayList<LocalizedKey> arrayList3 = new ArrayList<LocalizedKey>();
        arrayList3.add(new LocalizedKey(Boolean.FALSE.toString(), provider.translate(settings, "embeddedwebsites.openembeddded", new Object[0])));
        arrayList3.add(new LocalizedKey(Boolean.TRUE.toString(), provider.translate(settings, "embeddedwebsites.opennewtab", new Object[0])));
        SelectConfigProperty selectConfigProperty = new SelectConfigProperty(0, "openTargetUrl", "SimpleText", provider.translate(settings, "embeddedwebsites.openTargetUrl", new Object[0]), (Object)Boolean.FALSE.toString(), "", arrayList3);
        arrayList2.add(selectConfigProperty);
        ArrayList<LocalizedKey> arrayList4 = new ArrayList<LocalizedKey>();
        arrayList4.add(new LocalizedKey(Boolean.FALSE.toString(), provider.translate(settings, "embeddedwebsites.userallallowed", new Object[0])));
        arrayList4.add(new LocalizedKey(Boolean.TRUE.toString(), provider.translate(settings, "embeddedwebsites.userloginreqired", new Object[0])));
        arrayList4.add(new LocalizedKey("selective", provider.translate(settings, "embeddedwebsites.userselective", new Object[0])));
        SelectConfigProperty selectConfigProperty2 = new SelectConfigProperty(0, "loginRequired", "SimpleText", provider.translate(settings, "embeddedwebsites.loginRequired", new Object[0]), (Object)Boolean.FALSE.toString(), "", arrayList4);
        arrayList2.add(selectConfigProperty2);
        UserManager userManager = UserManager.getInstance();
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.hasAnyPermission((UserAccount)userManager.getCurrentUserAccount(), (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER})) {
            arrayList2.add((Object)new SelectiveLoginConfigProperty(0, "selectiveLogin", provider.translate(settings, "embeddedwebsites.selectiveLogin", new Object[0]), ""));
        } else if (!ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager")) {
            arrayList2.add(new ConfigProperty(0, "selectiveLoginMissing", "Label", provider.translate(settings, "embeddedwebsites.hint", new Object[0]), (Object)provider.translate(settings, "embeddedwebsites.missingplugin", new Object[0]), null, provider.translate(settings, "embeddedwebsites.missingplugin", new Object[0])));
        } else {
            arrayList2.add(new ConfigProperty(0, "selectiveLoginMissing", "Label", provider.translate(settings, "embeddedwebsites.hint", new Object[0]), (Object)provider.translate(settings, "embeddedwebsites.missingpermission", new Object[0]), null, provider.translate(settings, "embeddedwebsites.missingpermission", new Object[0])));
        }
        arrayList2.add((Object)new EmbeddedWebsitesIconConfigProperty(0, provider.translate(settings, "embeddedwebsites.icon", new Object[0])));
        arrayList2.add(EmbeddedWebsitesListConfigProperty.propWith("Hidden", provider.translate(settings, "embeddedwebsites.icon", new Object[0]), "icon", "", provider.translate(settings, "embeddedwebsites.icon.placeholder", new Object[0])));
        arrayList2.add(EmbeddedWebsitesListConfigProperty.propWith("Hidden", provider.translate(settings, "embeddedwebsites.iconPath", new Object[0]), "iconPath", "", provider.translate(settings, "embeddedwebsites.iconPath.placeholder", new Object[0])));
        ConfigRowAction[] configRowActionArray = new ConfigRowAction[1];
        ArrayList<ConfigConditionAction> arrayList5 = new ArrayList<ConfigConditionAction>();
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        if (ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.hasAnyPermission((UserAccount)userManager.getCurrentUserAccount(), (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER})) {
            arrayList5.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().property("loginRequired").equals().value((Object)"selective"), "selectiveLogin"));
        } else {
            arrayList5.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().property("loginRequired").equals().value((Object)"selective"), "selectiveLoginMissing"));
        }
        configRowActionArray[0] = new ConfigRowAction(configAction, null, configCategory, arrayList, hashMap, arrayList5);
        return configRowActionArray;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, placeholder);
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="It is just a color ...")
    private static String generateColor() {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[7];
        int n = new Random().nextInt(0x1000000);
        cArray2[0] = 35;
        for (int i = 1; i < 7; ++i) {
            cArray2[i] = cArray[n & 0xF];
            n >>= 4;
        }
        return new String(cArray2);
    }
}

