/*
 * Decompiled with CFR 0.152.
 */
package com.inet.embeddedwebsites.structure;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.AbstractIconConfigProperty;
import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.spi.PersistenceHelper;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;

@JsonData
public class EmbeddedWebsitesIconConfigProperty
extends AbstractIconConfigProperty {
    public static final int[] ICON_SIZES = new int[]{64, 96, 256};
    private static final String ICON_LOADER_METHOD_NAME = "getEmbeddedWebsitesIcon";
    private static final String VALUE_MAP_KEY = "embeddedWebsitesIcons";
    private List<String> additionalRequestedProperties = Arrays.asList("path", "icon");

    public EmbeddedWebsitesIconConfigProperty(int sortid, String label) {
        super(sortid, VALUE_MAP_KEY, label, ICON_LOADER_METHOD_NAME, ICON_SIZES);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The path is relative and we've already made sure it can contain no traversals")
    public static String storeIcons(String imageData, String path, String oldRelativePath) {
        HashMap hashMap;
        if (imageData == null) {
            return null;
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if ((hashMap = (HashMap)new Json().fromJson(imageData, HashMap.class, new Type[]{Integer.class, AbstractIconConfigProperty.UploadedIconDescription.class})) == null || hashMap.isEmpty()) {
            return null;
        }
        String string = PersistenceHelper.checkName((String)("embeddedwebsites" + (String)path)).substring(1);
        boolean bl = !string.equals(oldRelativePath);
        for (Map.Entry entry : hashMap.entrySet()) {
            PersistenceEntry persistenceEntry;
            Object object;
            if (!StringFunctions.isEmpty((String)((AbstractIconConfigProperty.UploadedIconDescription)entry.getValue()).getData())) {
                try {
                    object = new URL(((AbstractIconConfigProperty.UploadedIconDescription)entry.getValue()).getData());
                    persistenceEntry = Persistence.getInstance().resolve("images").resolve(string);
                    PersistenceEntry persistenceEntry2 = persistenceEntry.resolve((Integer)entry.getKey() + ".png");
                    InputStream inputStream = ((URL)object).openStream();
                    try (OutputStream outputStream = persistenceEntry2.getOutputStream();){
                        IOFunctions.copyData((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Throwable throwable) {}
                continue;
            }
            object = Persistence.getInstance().resolve("images").resolve(string);
            persistenceEntry = object.resolve((Integer)entry.getKey() + ".png");
            persistenceEntry.deleteValue();
        }
        List<Integer> list = EmbeddedWebsitesIconConfigProperty.getAvailableSizes(string);
        if (list.isEmpty()) {
            if (!StringFunctions.isEmpty((String)oldRelativePath)) {
                return "";
            }
            return null;
        }
        if (bl) {
            return string;
        }
        return null;
    }

    public static List<Integer> getAvailableSizes(String relativePath) {
        try {
            PersistenceEntry persistenceEntry = Persistence.getInstance().resolve("images").resolve(relativePath);
            if (!persistenceEntry.exists()) {
                return Collections.emptyList();
            }
            return persistenceEntry.walk("*.png").map(e -> e.getName().substring(0, e.getName().length() - 4)).map(n -> Integer.valueOf(n)).sorted().collect(Collectors.toList());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList();
        }
    }
}

