/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.zip;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Lock;
import com.inet.drive.api.permission.PermissionChecker;
import com.inet.drive.webgui.pluginapi.ResolveRenameHandler;
import com.inet.drive.webgui.server.actions.zip.ZipRequestData;
import com.inet.drive.webgui.server.data.SingleIDData;
import com.inet.drive.webgui.server.events.ConflictEvent;
import com.inet.drive.webgui.server.events.o;
import com.inet.drive.webgui.server.state.b;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.IOFunctions;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class c
extends ServiceMethod<ZipRequestData, SingleIDData> {
    public SingleIDData a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ZipRequestData zipRequestData) throws IOException {
        Drive drive = com.inet.drive.webgui.server.a.du();
        DriveEntry driveEntry = drive.resolve(zipRequestData.getTargetID());
        if (driveEntry == null) {
            throw new ClientMessageException(DrivePlugin.MSG_CLIENT.getMsg("drive.gui.error.targetMissing", new Object[0]));
        }
        if (!driveEntry.hasFeature(DriveEntry.FOLDER)) {
            throw new ClientMessageException(DrivePlugin.MSG.getMsg("zip.error.parentnotfolder", new Object[]{driveEntry.getName()}));
        }
        if (!drive.getPermissionChecker().hasPermission(driveEntry.getID(), false, "EDITOR")) {
            throw new ClientMessageException(DrivePlugin.MSG.getMsg("zip.error.parentnotwritable", new Object[]{driveEntry.getName()}));
        }
        if (zipRequestData.getZipFileName() == null || zipRequestData.getZipFileName().isBlank()) {
            throw new ClientMessageException(DrivePlugin.MSG_CLIENT.getMsg("drive.gui.zip.error.noname", new Object[0]));
        }
        if (zipRequestData.toAPIResolutionsMap() != null && zipRequestData.toAPIResolutionsMap().get(null) != null) {
            return null;
        }
        String string = zipRequestData.getSourceTaskID();
        if (string != null) {
            com.inet.drive.webgui.server.state.a.eb().a(null, o.jI, string);
        }
        String string2 = b.er().a(new a(driveEntry, zipRequestData, drive), UserManager.getInstance().getCurrentUserAccountID(), zipRequestData.getPollingID());
        return new SingleIDData(string2);
    }

    public String getMethodName() {
        return "drive.zipentry";
    }

    public short getMethodType() {
        return 1;
    }

    public /* synthetic */ Object invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ZipRequestData)object);
    }

    private static class a
    implements b.c {
        private DriveEntry iA;
        private ZipRequestData iG;
        private boolean iC;
        private Drive as;
        private b.a iD;
        private int iH = 0;
        private DriveEntry iI;
        private String iE;

        public a(DriveEntry driveEntry, ZipRequestData zipRequestData, Drive drive) {
            this.iA = driveEntry;
            this.iG = zipRequestData;
            this.as = drive;
        }

        @Override
        public void at(String string) {
            this.iE = string;
        }

        @Override
        public void a(b.a a2) {
            this.iD = a2;
        }

        @Override
        public String getTitle() {
            return DrivePlugin.MSG.getMsg("action.zip.title", new Object[0]);
        }

        @Override
        public String getDisplayName() {
            return DrivePlugin.MSG.getMsg("action.zip.heading", new Object[]{this.iG.getZipFileName(), com.inet.drive.webgui.server.utils.c.Q(this.iA)});
        }

        @Override
        public String a(DriveEntry driveEntry, int n2, int n3) {
            return driveEntry != null ? DrivePlugin.MSG.getMsg("action.zip.label", new Object[]{com.inet.drive.webgui.server.utils.c.Q(driveEntry)}) : DrivePlugin.MSG.getMsg("action.zip.title", new Object[0]);
        }

        @Override
        public String b(DriveEntry driveEntry, int n2, int n3) {
            if (n2 + n3 > 0) {
                return com.inet.drive.webgui.server.utils.c.b(n2, n3) + " " + DrivePlugin.MSG.getMsg("action.zip.passive", new Object[0]);
            }
            return "";
        }

        @Override
        public int dA() {
            return this.iH;
        }

        @Override
        public void dB() {
            this.iC = true;
        }

        @Override
        public boolean dC() {
            return this.iC;
        }

        private void a(List<DriveEntry> list, Map<String, DriveOperationConflictException.RESOLUTION> map, ConflictEvent conflictEvent, PermissionChecker permissionChecker, Set<String> set) {
            for (DriveEntry driveEntry : list) {
                String string = driveEntry.getID();
                if (map.get(string) == DriveOperationConflictException.RESOLUTION.skip) continue;
                if (!driveEntry.exists() || !permissionChecker.hasPermission(string, false, "VIEWER")) {
                    conflictEvent.addCannotReadConflict(new com.inet.drive.webgui.server.model.a(driveEntry, false));
                    continue;
                }
                if (driveEntry.hasFeature(Folder.class)) {
                    this.a(driveEntry.getFeature(Folder.class).getChildren(), map, conflictEvent, permissionChecker, set);
                }
                if (!driveEntry.hasFeature(Content.class)) continue;
                set.add(driveEntry.getID());
            }
        }

        private void a(List<DriveEntry> list, String string, ZipArchiveOutputStream zipArchiveOutputStream, Set<String> set) throws IOException {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (DriveEntry driveEntry : list) {
                Object object;
                String string2;
                if (this.iC) {
                    return;
                }
                String string3 = driveEntry.getID();
                if (string3.equals(this.iI.getID())) continue;
                Object object2 = driveEntry.getName();
                Integer n2 = this.b(hashMap, (String)object2);
                if (n2 > 1) {
                    int n3 = ((String)object2).lastIndexOf(".");
                    string2 = " (" + n2 + ")";
                    object2 = n3 >= 0 && n3 < ((String)object2).length() - 1 ? ((String)object2).substring(0, n3) + string2 + ((String)object2).substring(n3 + 1) : (String)object2 + string2;
                    this.b(hashMap, (String)object2);
                }
                if (driveEntry.hasFeature(Content.class)) {
                    if (!set.contains(string3)) continue;
                    Content content = driveEntry.getFeature(Content.class);
                    string2 = new ZipArchiveEntry(string + (String)object2);
                    string2.setLastModifiedTime(FileTime.fromMillis(driveEntry.getLastModified()));
                    string2.setSize(content.getSize());
                    zipArchiveOutputStream.putArchiveEntry((ZipArchiveEntry)string2);
                    object = content.getInputStream();
                    try {
                        IOFunctions.copyData((InputStream)object, (OutputStream)zipArchiveOutputStream);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    zipArchiveOutputStream.closeArchiveEntry();
                    this.iD.L(driveEntry);
                }
                if (!driveEntry.hasFeature(Folder.class)) continue;
                Folder folder = driveEntry.getFeature(Folder.class);
                string2 = string + (String)object2 + "/";
                object = new ZipArchiveEntry(string2);
                object.setLastModifiedTime(FileTime.fromMillis(driveEntry.getLastModified()));
                zipArchiveOutputStream.putArchiveEntry((ZipArchiveEntry)object);
                this.a(folder.getChildren(), string2, zipArchiveOutputStream, set);
            }
        }

        private Integer b(Map<String, Integer> map, String string) {
            Integer n2 = map.get(string);
            n2 = n2 == null ? Integer.valueOf(1) : Integer.valueOf(n2 + 1);
            map.put(string, n2);
            return n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConflictEvent dD() throws Throwable {
            List<DriveEntry> list;
            Object object;
            Map<String, DriveOperationConflictException.RESOLUTION> map = this.iG.toAPIResolutionsMap();
            Folder folder = this.iA.getFeature(Folder.class);
            String string = this.iG.getZipFileName();
            this.iI = com.inet.drive.webgui.server.utils.a.a(folder, string);
            if (this.iI != null && this.iI.exists()) {
                object = map.get(this.iI.getID());
                if (object == DriveOperationConflictException.RESOLUTION.skip) {
                    this.dB();
                    return null;
                }
                if (object == DriveOperationConflictException.RESOLUTION.rename) {
                    string = ResolveRenameHandler.getRenameName(string, this.iA);
                    this.iI = null;
                } else if (object != DriveOperationConflictException.RESOLUTION.overwrite) {
                    ConflictEvent conflictEvent = new ConflictEvent("drive.zipentry", this.iG, this.iE);
                    conflictEvent.addOverwriteConflict(new com.inet.drive.webgui.server.model.a(this.iI, false), new com.inet.drive.webgui.server.model.a(string, -1L, new Date().getTime(), false));
                    return conflictEvent;
                }
            }
            object = new ConflictEvent("drive.zipentry", this.iG, this.iE);
            try {
                list = this.iG.getSelectedEntries(false, false);
            }
            catch (DriveOperationConflictException driveOperationConflictException) {
                object.addConflicts(driveOperationConflictException);
                return object;
            }
            HashSet<String> hashSet = new HashSet<String>();
            this.iD.c(DrivePlugin.MSG.getMsg("action.zip.scanning", new Object[0]), "", true);
            this.a(list, map, (ConflictEvent)object, this.as.getPermissionChecker(), (Set<String>)hashSet);
            this.iH = hashSet.size();
            if (object.hasConflicts()) {
                return object;
            }
            if (this.iI == null || !this.iI.exists()) {
                try {
                    this.iI = folder.createChild(new DataEntry(string, new byte[0]));
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    object.addConflicts(driveOperationConflictException, string, -1L, new Date().getTime(), false);
                    return object;
                }
            }
            try {
                DriveUtils.startOperation(DriveUtils.a.S);
                ConflictEvent conflictEvent = this.a((ConflictEvent)object, list, (Set<String>)hashSet);
                return conflictEvent;
            }
            finally {
                DriveUtils.startOperation(null);
            }
        }

        private ConflictEvent a(ConflictEvent conflictEvent, List<DriveEntry> list, Set<String> set) throws Throwable {
            Lock lock = this.iI.getFeature(DriveEntry.LOCK);
            if (lock != null) {
                try (ServerLock serverLock = lock.tryLock(200L);){
                    if (serverLock == null) {
                        conflictEvent.addConflicts(DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict("", DriveOperationConflictException.CONFLICT.locked)));
                        ConflictEvent conflictEvent2 = conflictEvent;
                        return conflictEvent2;
                    }
                    ConflictEvent conflictEvent3 = this.b(conflictEvent, list, set);
                    return conflictEvent3;
                }
            }
            return this.b(conflictEvent, list, set);
        }

        private ConflictEvent b(ConflictEvent conflictEvent, List<DriveEntry> list, Set<String> set) throws DriveOperationConflictException, IOException {
            ConflictEvent conflictEvent2;
            Content content = this.iI.getFeature(Content.class);
            ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(content.getOutputStream());
            try {
                this.a(list, "", zipArchiveOutputStream, set);
                conflictEvent2 = null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipArchiveOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    conflictEvent.addConflicts(driveOperationConflictException);
                    return conflictEvent;
                }
                catch (IOException iOException) {
                    this.iI.delete(null);
                    throw iOException;
                }
            }
            zipArchiveOutputStream.close();
            return conflictEvent2;
        }
    }
}

