/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.share;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DrivePermission;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.feature.ShareAnonymLink;
import com.inet.drive.api.feature.ShareData;
import com.inet.drive.api.feature.c;
import com.inet.drive.webgui.server.a;
import com.inet.drive.webgui.server.actions.permissions.PermissionsData;
import com.inet.drive.webgui.server.actions.share.ShareDialogData;
import com.inet.drive.webgui.server.data.SingleIDData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends ServiceMethod<SingleIDData, ShareDialogData> {
    public String getMethodName() {
        return "drive.share";
    }

    public short getMethodType() {
        return 1;
    }

    public ShareDialogData b(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, SingleIDData singleIDData) throws IOException {
        Map<GUID, Set<String>> map;
        Object object;
        if (!SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER, DrivePermission.DRIVE_SHARE_LINK_PERMISSION})) {
            throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
        }
        @Nullable String string = singleIDData.getId();
        if (string == null) {
            return null;
        }
        DriveEntry driveEntry = a.du().resolve(string);
        if (driveEntry == null || !driveEntry.exists()) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.noaccess", new Object[]{string}));
        }
        boolean bl = a.du().getPermissionChecker().hasPermission(string, false, "EDITOR");
        if (!bl) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.shareDialog", new Object[]{driveEntry.getName()}));
        }
        ArrayList<PermissionsData.PermissionsEntry> arrayList = new ArrayList<PermissionsData.PermissionsEntry>();
        ArrayList<PermissionsData.PermissionsEntry> arrayList2 = new ArrayList<PermissionsData.PermissionsEntry>();
        @Nullable c c2 = driveEntry.getFeature(c.class);
        if (c2 == null) {
            throw new IllegalStateException("The entry '" + driveEntry.getDislayName() + "' does not support sharing.");
        }
        ShareData shareData = c2.w();
        if (shareData != null) {
            String string2;
            Object object2;
            object = shareData.getPermissions(true);
            for (Map.Entry object3 : object.entrySet()) {
                Set set = (Set)object3.getValue();
                if (set == null || set.isEmpty()) continue;
                object2 = UserGroupManager.getInstance().getGroup((GUID)object3.getKey());
                string2 = object2 == null ? ((GUID)object3.getKey()).toString() : UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)object2);
                arrayList.add(PermissionsData.PermissionsEntry.forUserOrGroup((GUID)object3.getKey(), string2, new ArrayList<String>(set)));
            }
            map = shareData.getPermissions(false);
            for (Map.Entry<GUID, Set<String>> entry : map.entrySet()) {
                object2 = entry.getValue();
                if (object2 == null || object2.isEmpty()) continue;
                string2 = UserManager.getInstance().getUserAccount(entry.getKey());
                @Nonnull String string3 = string2 == null ? entry.getKey().toString() : string2.getDisplayName();
                arrayList2.add(PermissionsData.PermissionsEntry.forUserOrGroup(entry.getKey(), string3, new ArrayList<String>((Collection<String>)object2)));
            }
        }
        object = this.as(string);
        map = new ShareDialogData(string, arrayList, arrayList2);
        ((ShareDialogData)((Object)map)).setAvailablePermissions(com.inet.drive.webgui.server.actions.permissions.a.dw(), (List<String>)object);
        if (SystemPermissionChecker.checkAccess((Permission)DrivePermission.DRIVE_SHARE_LINK_PERMISSION)) {
            for (ShareAnonymLink shareAnonymLink : c2.y()) {
                ((ShareDialogData)((Object)map)).addShareLink(ShareDialogData.ShareLinkData.from(shareAnonymLink));
            }
        }
        this.b(driveEntry, (ShareDialogData)((Object)map));
        return map;
    }

    private void b(DriveEntry driveEntry, ShareDialogData shareDialogData) {
        driveEntry.runFeature(Folder.class, folder -> {
            ArrayList<@Nonnull String> arrayList = new ArrayList<String>();
            for (DriveEntry driveEntry : folder.getChildren()) {
                if (!driveEntry.hasFeature(Folder.class)) continue;
                driveEntry.runFeature(Permissions.class, permissions -> {
                    if (!permissions.getPermissions(true).isEmpty() || !permissions.getPermissions(false).isEmpty()) {
                        arrayList.add(driveEntry.getDislayName());
                    }
                });
            }
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
                shareDialogData.setNonInheritFolders(arrayList);
            }
        });
    }

    private List<String> as(@Nonnull String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DrivePermissionType drivePermissionType : com.inet.drive.webgui.server.actions.permissions.a.dw()) {
            if (!a.du().getPermissionChecker().hasPermission(string, false, drivePermissionType.getPermissionTypeName())) continue;
            arrayList.add(drivePermissionType.getPermissionTypeName());
        }
        return arrayList;
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (SingleIDData)object);
    }
}

