/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.permissions;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.webgui.server.actions.permissions.PermissionsData;
import com.inet.drive.webgui.server.actions.permissions.a;
import com.inet.drive.webgui.server.actions.permissions.b;
import com.inet.drive.webgui.server.data.SetPermissionsWarning;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
extends ServiceMethod<PermissionsData, SetPermissionsWarning> {
    public String getMethodName() {
        return "drive.permissions.set";
    }

    public short getMethodType() {
        return 1;
    }

    public SetPermissionsWarning a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, PermissionsData permissionsData) throws IOException {
        String string = permissionsData.getId();
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (string == null || gUID == null) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.noaccess", new Object[]{"<null>"}));
        }
        DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(string);
        if (driveEntry == null || !driveEntry.exists()) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.noaccess", new Object[]{string}));
        }
        if ("Drive".equals(string) && permissionsData.isInherit()) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.inheritOnRoot", new Object[0]));
        }
        Boolean bl = com.inet.drive.webgui.server.utils.a.O(driveEntry);
        Mount mount = driveEntry.getFeature(DriveEntry.MOUNT);
        if (mount != null && bl != Boolean.TRUE) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.nowrite", new Object[]{driveEntry.getName()}));
        }
        if (mount == null && !com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(string, false, "EDITOR")) {
            throw new ClientMessageException(DrivePlugin.MSG_SERVER.getMsg("permissions.error.nowrite", new Object[]{driveEntry.getName()}));
        }
        GUID gUID2 = driveEntry.getMetaData(MetaData.CREATOR_ID);
        Permissions permissions = driveEntry.getFeature(Permissions.class);
        if (!permissionsData.isInherit()) {
            UserAccountScope userAccountScope;
            List list;
            List<PermissionsData.PermissionsEntry> list2;
            if (b.dx()) {
                list2 = permissionsData.getGroupPermissions();
                list = permissionsData.getUserPermissions();
                if (list == null) {
                    list = new ArrayList<PermissionsData.PermissionsEntry>();
                }
                if (list2 == null) {
                    list2 = new ArrayList<PermissionsData.PermissionsEntry>();
                }
                if (bl == Boolean.TRUE) {
                    list = list.stream().filter(permissionsEntry -> !Objects.equals(gUID.toString(), permissionsEntry.getKey())).collect(Collectors.toCollection(() -> new ArrayList()));
                }
                if (list2.isEmpty() && list.isEmpty()) {
                    this.a(gUID2, gUID, list);
                }
            } else {
                list2 = new ArrayList<PermissionsData.PermissionsEntry>();
                list = new ArrayList<PermissionsData.PermissionsEntry>();
                userAccountScope = permissionsData.getPublicPermissions();
                if (userAccountScope != null && !userAccountScope.isEmpty()) {
                    list2.add(PermissionsData.PermissionsEntry.forUserOrGroup(UsersAndGroups.GROUPID_ALLUSERS, "", (List<String>)userAccountScope));
                } else {
                    this.a(gUID2, gUID, list);
                }
            }
            if (!permissionsData.isIgnoreWarnings() && bl != Boolean.TRUE) {
                boolean bl2 = this.a(list2, (List<PermissionsData.PermissionsEntry>)list, "EDITOR");
                if (!bl2 && !this.a(list2, (List<PermissionsData.PermissionsEntry>)list, "VIEWER")) {
                    return new SetPermissionsWarning(DrivePlugin.MSG_SERVER.getMsg(this.dy() ? "permissions.warning.lockedout" : "permissions.warning.lockedout.enduser", new Object[]{new com.inet.drive.webgui.server.model.fields.c().D(driveEntry)}));
                }
                if (!bl2) {
                    return new SetPermissionsWarning(DrivePlugin.MSG_SERVER.getMsg(this.dy() ? "permissions.warning.readonly" : "permissions.warning.readonly.enduser", new Object[]{new com.inet.drive.webgui.server.model.fields.c().D(driveEntry)}));
                }
            }
            userAccountScope = UserAccountScope.createPrivileged();
            try {
                this.a(permissions, list2, true);
                this.a(permissions, (List<PermissionsData.PermissionsEntry>)list, false);
            }
            finally {
                if (userAccountScope != null) {
                    userAccountScope.close();
                }
            }
        } else {
            ArrayList<PermissionsData.PermissionsEntry> arrayList = new ArrayList<PermissionsData.PermissionsEntry>();
            ArrayList<PermissionsData.PermissionsEntry> arrayList2 = new ArrayList<PermissionsData.PermissionsEntry>();
            a.a(driveEntry, arrayList2, arrayList);
            if (!permissionsData.isIgnoreWarnings() && bl != Boolean.TRUE) {
                boolean bl3 = this.a(arrayList, arrayList2, "EDITOR");
                if (!bl3 && !this.a(arrayList, arrayList2, "VIEWER")) {
                    return new SetPermissionsWarning(DrivePlugin.MSG_SERVER.getMsg(this.dy() ? "permissions.warning.lockedout" : "permissions.warning.lockedout.enduser", new Object[]{new com.inet.drive.webgui.server.model.fields.c().D(driveEntry)}));
                }
                if (!bl3) {
                    return new SetPermissionsWarning(DrivePlugin.MSG_SERVER.getMsg(this.dy() ? "permissions.warning.readonly" : "permissions.warning.readonly.enduser", new Object[]{new com.inet.drive.webgui.server.model.fields.c().D(driveEntry)}));
                }
            }
            if (permissions != null) {
                permissions.clearPermission();
            }
        }
        return null;
    }

    private boolean dy() {
        return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
    }

    private void a(GUID gUID, GUID gUID2, List<PermissionsData.PermissionsEntry> list) {
        if (gUID != null) {
            list.add(PermissionsData.PermissionsEntry.forOwner(gUID, gUID.toString()));
        } else {
            list.add(PermissionsData.PermissionsEntry.forOwner(gUID2, gUID2.toString()));
        }
    }

    private boolean a(List<PermissionsData.PermissionsEntry> list, List<PermissionsData.PermissionsEntry> list2, String string) {
        @Nullable GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID == null) {
            return false;
        }
        String string2 = gUID.toString();
        for (Object object : list2) {
            if (!string2.equals(object.getKey()) || !object.getPermissions().contains(string)) continue;
            return true;
        }
        if (list.isEmpty()) {
            return false;
        }
        Set set = UserGroupManager.getInstance().getGroupsForUser(gUID).stream().map(userGroupInfo -> userGroupInfo.getID().toString()).collect(Collectors.toSet());
        for (PermissionsData.PermissionsEntry permissionsEntry : list) {
            if (!set.contains(permissionsEntry.getKey()) || !permissionsEntry.getPermissions().contains(string)) continue;
            return true;
        }
        return false;
    }

    private void a(Permissions permissions, List<PermissionsData.PermissionsEntry> list, boolean bl) {
        HashMap<GUID, Map<String, Boolean>> hashMap = new HashMap<GUID, Map<String, Boolean>>();
        for (PermissionsData.PermissionsEntry permissionsEntry : list) {
            HashMap hashMap2 = new HashMap();
            permissionsEntry.getPermissions().forEach(string -> hashMap2.put(string, Boolean.TRUE));
            hashMap.put(GUID.valueOf((String)permissionsEntry.getKey()), hashMap2);
        }
        Map<GUID, Map<String, Boolean>> map = permissions.getPermissions(bl);
        if (map.equals(hashMap)) {
            return;
        }
        permissions.setPermissions(bl, hashMap);
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (PermissionsData)object);
    }
}

