/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.permissions;

import com.inet.annotations.JsonData;
import com.inet.drive.api.DrivePermissionType;
import com.inet.drive.webgui.server.actions.permissions.PermissionsData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class PermissionsDataWithInherit
extends PermissionsData {
    private List<PermissionsData.PermissionsEntry> groupsInherit;
    private List<PermissionsData.PermissionsEntry> usersInherit;
    private String mixedLabelOnEntry;
    private String mixedLabelOnInherit;
    private boolean readOnly;
    private boolean canInherit;
    private boolean reducedPermissions;
    private boolean isInLink;
    private String parentLinkID;
    private List<String> permissionsKeys = new ArrayList<String>();
    private List<String> permissionsNames = new ArrayList<String>();
    private List<String> allowedPermissionKeys = new ArrayList<String>();

    public PermissionsDataWithInherit(@Nonnull String entryID, @Nonnull List<PermissionsData.PermissionsEntry> groups, @Nonnull List<PermissionsData.PermissionsEntry> users, @Nonnull List<PermissionsData.PermissionsEntry> groupsInherit, @Nonnull List<PermissionsData.PermissionsEntry> usersInherit, boolean inherited) {
        super(entryID, groups, users, inherited);
        this.groupsInherit = groupsInherit;
        this.usersInherit = usersInherit;
    }

    public PermissionsDataWithInherit(@Nonnull String entryID, boolean inherited, List<String> publicPermissions, String mixedPermissionsOnEntry, String mixedPermissionsOnInherit) {
        super(entryID, publicPermissions, inherited);
        this.mixedLabelOnEntry = mixedPermissionsOnEntry;
        this.mixedLabelOnInherit = mixedPermissionsOnInherit;
        this.groupsInherit = new ArrayList<PermissionsData.PermissionsEntry>();
        this.usersInherit = new ArrayList<PermissionsData.PermissionsEntry>();
    }

    public void setAvailablePermissions(List<DrivePermissionType> permissions, List<String> allowedPermissions) {
        permissions.forEach(p2 -> {
            this.permissionsKeys.add(p2.getPermissionTypeName());
            this.permissionsNames.add(p2.getDisplayName());
        });
        this.allowedPermissionKeys = allowedPermissions != null ? allowedPermissions : this.permissionsKeys;
    }

    public void setCanInherit(boolean canInherit) {
        this.canInherit = canInherit;
    }

    public void setShowReducedPermissions(boolean reducedPermissions) {
        this.reducedPermissions = reducedPermissions;
    }

    public void setInLink(boolean isInLink) {
        this.isInLink = isInLink;
    }

    public void setParentLinkID(String parentLinkID) {
        this.parentLinkID = parentLinkID;
    }

    @Nullable
    public String getMixedLabelOnEntry() {
        return this.mixedLabelOnEntry;
    }

    public String getMixedLabelOnInherit() {
        return this.mixedLabelOnInherit;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public List<PermissionsData.PermissionsEntry> getUserPermissionsInherited() {
        return this.usersInherit;
    }

    public List<PermissionsData.PermissionsEntry> getGroupPermissionsInherited() {
        return this.groupsInherit;
    }
}

