/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.pluginapi;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.Folder;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class ResolveRenameHandler {
    private static final Pattern iw = Pattern.compile("(.+)\\s\\((\\d+)\\)");
    private static final Pattern ix = Pattern.compile("\\.\\w+");

    @Nonnull
    public static String getRenameName(@Nonnull String currentName, @Nonnull DriveEntry parent) {
        List list;
        if (!parent.hasFeature(Folder.class)) {
            return currentName;
        }
        try (Object object = UserAccountScope.createPrivileged();){
            list = parent.executeFeatureNN(Folder.class, folder -> folder.getChildren(), ArrayList::new);
        }
        object = list.stream().map(DriveEntry::getName).collect(Collectors.toSet());
        if (parent.getID().equals("Drive")) {
            object.add("Home");
        }
        if (!object.contains(currentName)) {
            return currentName;
        }
        return ResolveRenameHandler.getRenameName(currentName, (Set<String>)object);
    }

    @Nonnull
    public static String getRenameName(@Nonnull String currentName, Set<String> names) {
        String string;
        String string2;
        BigInteger bigInteger = BigInteger.valueOf(2L);
        Matcher matcher = iw.matcher(currentName);
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        if (matcher.matches()) {
            bigInteger = new BigInteger(matcher.group(2)).add(bigInteger2);
            string2 = matcher.group(1);
            string = "";
        } else {
            int n2 = currentName.lastIndexOf(46);
            if (n2 > 0) {
                string = currentName.substring(n2);
                if (ix.matcher(string).matches()) {
                    string2 = currentName.substring(0, n2);
                    matcher = iw.matcher(string2);
                    if (matcher.matches()) {
                        bigInteger = new BigInteger(matcher.group(2)).add(bigInteger2);
                        string2 = matcher.group(1);
                    }
                } else {
                    string2 = currentName;
                    string = "";
                }
            } else {
                string2 = currentName;
                string = "";
            }
        }
        BigInteger bigInteger3 = bigInteger.add(BigInteger.valueOf(10000L));
        while (bigInteger.compareTo(bigInteger3) < 0) {
            String string3 = string2 + " (" + bigInteger.toString() + ")" + string;
            if (!names.contains(string3)) {
                return string3;
            }
            bigInteger = bigInteger.add(bigInteger2);
        }
        return currentName;
    }
}

