/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.webgui.server.a;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@Schema(description="Response data for drive operation conflicts")
public class DriveConflictResponseData {
    @Schema(description="List of conflicts that occurred during the operation")
    @Nonnull
    private List<SingleConflict> conflicts = new ArrayList<SingleConflict>();

    @Nonnull
    public DriveConflictResponseData add(@Nonnull DriveOperationConflictException.SingleEntryConflict source, @Nullable String path) {
        this.conflicts.add(new SingleConflict(source, path));
        return this;
    }

    public void add(@Nonnull DriveConflictResponseData otherData) {
        this.conflicts.addAll(otherData.conflicts);
    }

    public boolean hasData() {
        return !this.conflicts.isEmpty();
    }

    @Nonnull
    public List<SingleConflict> getConflicts() {
        return this.conflicts;
    }

    @JsonData
    @Schema(description="Details of a single drive operation conflict")
    public static class SingleConflict {
        @Schema(description="ID of the existing entry that caused the conflict")
        private String id;
        @Schema(description="Type of conflict that occurred")
        @Nullable
        private DriveOperationConflictException.CONFLICT conflict;
        @Schema(description="Path or name of the conflicting entry")
        private String path;
        @Schema(description="Human-readable message describing the conflict")
        private String message;

        public SingleConflict(DriveOperationConflictException.SingleEntryConflict source, String path) {
            DriveEntry driveEntry;
            this.id = source.getExistingEntryID();
            this.conflict = source.getConflict();
            this.path = path;
            this.message = source.toMessage();
            if ((path == null || DriveIDUtils.isID(path)) && (driveEntry = a.du().resolve(this.id)) != null) {
                path = driveEntry.getName();
                try {
                    path = driveEntry.getPath();
                }
                catch (Exception exception) {
                    DrivePlugin.LOGGER.debug((Object)exception);
                }
            }
        }

        @Nullable
        public DriveOperationConflictException.CONFLICT getConflict() {
            return this.conflict;
        }
    }
}

