/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.setup;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.setup.RepositoryMigrationStepConfig;
import com.inet.drive.setup.d;
import com.inet.drive.setup.repository.e;
import com.inet.error.ServiceUnavailableException;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepConfigurationStorage;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressListener;
import com.inet.setupwizard.api.StepExecutionWarnings;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.api.StepsRepository;
import com.inet.setupwizard.basicsteps.BasicStepPriorities;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;

@InternalApi
public class DriveRepositoryMigrationStep
extends SetupStep<RepositoryMigrationStepConfig> {
    public static final StepKey KEY = new StepKey("DriveRepositoryMigration");

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return DrivePlugin.MSG.getMsg("repositoryMigration.displayname", new Object[0]);
    }

    public boolean hasPendingTasks() {
        com.inet.drive.setup.repository.d d2 = e.cA().cB();
        if (d2 != null) {
            try {
                return d.a(d2);
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                SetupLogger.LOGGER.info((Object)serviceUnavailableException);
                return false;
            }
        }
        SetupLogger.LOGGER.debug((Object)"No active repository to check.");
        return false;
    }

    public void execute(RepositoryMigrationStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        UserManagerWait.waitForUserManagerVeto((StepExecutionProgressListener)this.getStepExecutionProgressListener(), (SetupStep)this);
        this.ck();
    }

    void ck() {
        try {
            e e2 = e.cA();
            com.inet.drive.setup.repository.d d2 = e2.cB();
            if (d2 != null) {
                if (SetupLogger.LOGGER.isDebug()) {
                    SetupLogger.LOGGER.debug((Object)("Migrate Repository :" + d2.cr().toString()));
                }
                new d(d2, this.getStepExecutionProgressListener()).cn();
                e2.cC();
                e2.b((com.inet.drive.setup.repository.d)null);
            }
        }
        catch (Exception exception) {
            SetupLogger.LOGGER.error((Throwable)exception);
            StepExecutionWarnings.get().error(() -> DrivePlugin.MSG_SERVER.getMsg("repositoryMigration.migration.error", new Object[]{exception.getMessage()}));
        }
    }

    public SetupStepPriority getPriority() {
        return BasicStepPriorities.DRIVE_REPO_MIGRATION;
    }

    public InfoMessageGetter getExecutionInfoMessage(RepositoryMigrationStepConfig stepConfig) {
        return () -> DrivePlugin.MSG.getMsg("repositoryMigration.executionMessage", new Object[0]);
    }

    public boolean willPerformIrreversibleMigration(RepositoryMigrationStepConfig settings) {
        return true;
    }

    public boolean doesRequireToRestartServerAfterExecution(RepositoryMigrationStepConfig stepConfig) {
        return false;
    }

    public RepositoryMigrationStepConfig updateConfiguration(StepConfigurationStorage storage, StepsRepository repository, RepositoryMigrationStepConfig stepConfig, StepKey changedStep) {
        com.inet.drive.setup.repository.d d2;
        if (stepConfig == null) {
            stepConfig = new RepositoryMigrationStepConfig();
        }
        if ((d2 = e.cA().cB()) != null) {
            String string = d2.cr().toString();
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            stepConfig.setRepository(string);
        }
        return stepConfig;
    }
}

