/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Permission;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.api.mount.BrokenMountDriveEntry;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.api.mount.MountProvider;
import com.inet.drive.server.linked.d;
import com.inet.drive.server.persistence.PersistencePermissions;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.k;
import com.inet.drive.server.persistence.l;
import com.inet.id.GUID;
import com.inet.lib.json.Bon;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class i
implements DriveEntry {
    private static a eB;
    private static final Duration eC;
    private String et;
    private final String eD;
    private final String cy;
    private b eE;
    private Permissions eF;
    private com.inet.drive.server.persistence.c eG;
    private DriveEntry eH;
    private DriveEntry eI;
    private String cv;
    private PersistenceEntry ep;
    private com.inet.drive.server.a dQ;
    private MountDescription ax;

    public static i a(String string, String string2, String string3, com.inet.drive.server.a a2) {
        String string4 = DriveIDUtils.generateMountID();
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/link/" + string4 + "/.link");
        String[] stringArray = new String[]{string, string2, string3};
        persistenceEntry.setBytes(new Bon().toBinary((Object)stringArray));
        return new i(string4, a2);
    }

    public i(String string, com.inet.drive.server.a a2) {
        String[] stringArray;
        byte[] byArray;
        this.dQ = a2;
        this.cv = string;
        this.ep = Persistence.getRecoveryEnabledInstance().resolve("/drive/link/" + DriveIDUtils.getMountBaseID(string) + "/.link");
        if (this.ep.exists() && (byArray = this.ep.getBytes()) != null && (stringArray = (String[])new Bon().fromBinary(byArray, String[].class)) != null) {
            this.et = stringArray[0];
            this.eD = stringArray[1];
            this.cy = stringArray.length > 2 ? stringArray[2] : "/";
            return;
        }
        throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.mount.error.invaliddata", new Object[]{string}));
    }

    private com.inet.drive.server.persistence.c bf() {
        if (this.eG == null) {
            this.eG = (com.inet.drive.server.persistence.c)this.dQ.d(this.et);
            if (this.eG == null || !this.eG.hasFeature(FOLDER)) {
                throw new IllegalStateException(DrivePlugin.MSG_SERVER.getMsg("drive.corrupted", new Object[]{this.et}));
            }
        }
        return this.eG;
    }

    @Nonnull
    private DriveEntry bg() {
        if (this.eI == null) {
            try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)this.getDescription().getUserID());){
                this.eI = DriveIDUtils.getMountRootID(this.cy) != null ? this.getDescription().getRoot() : this.getDescription().resolve(this, this.cy);
            }
            if (this.eI == null) {
                this.eI = new BrokenMountDriveEntry(new MountManager.b(DrivePlugin.MSG.getMsg("link.error.targetnotfound", new Object[0])));
            }
        }
        return this.eI;
    }

    @Nullable
    DriveEntry bh() {
        if (this.eH == null) {
            try (Object object = UserAccountScope.createPrivileged();){
                this.eH = this.bi();
                Mount mount = this.getFeature(DriveEntry.MOUNT);
                if (mount == null || !mount.getDescription().getID().equals((Object)this.ax.getID())) {
                    throw new MountManager.b("Mount/Internal Link k\u00f6nnte nicht aufgel\u00f6st werden: '" + this.ax.getName() + "' unter Element = " + this.cy);
                }
            }
            if (this.eH instanceof BrokenMountDriveEntry) {
                object = this.eH;
                this.eH = null;
                return object;
            }
        }
        if (this.eH == null) {
            throw new MountManager.b("Mount/Internal Link k\u00f6nnte nicht aufgel\u00f6st werden: '" + this.getDescription().getName() + "' unter Element = " + this.cy);
        }
        return this.eH;
    }

    @Nullable
    DriveEntry bi() {
        if (eB != null && eB.isValid()) {
            return eB.bj();
        }
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            @Nonnull MountDescription mountDescription = this.getDescription();
            DriveEntry driveEntry = mountDescription.resolve(null, this.cy, "/");
            if (!("PERSISTENCE_PROVIDER".equals(mountDescription.getProvider()) || "sharing".equals(mountDescription.getProvider()) || "file".equals(mountDescription.getProvider()))) {
                eB = new a(driveEntry, eC);
            }
            DriveEntry driveEntry2 = driveEntry;
            return driveEntry2;
        }
    }

    @Nonnull
    public MountDescription getDescription() {
        this.ax = MountManager.getInstance().getMountDescription(GUID.valueOf((String)this.eD));
        if (this.ax == null) {
            throw new MountManager.a(DrivePlugin.MSG_SERVER.getMsg("drive.mount.error.notregistered", new Object[]{this.eD}));
        }
        return this.ax;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.bf().getName();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.bf().getPath();
    }

    @Override
    @Nonnull
    public String getID() {
        return this.cv;
    }

    @Override
    public long getLastModified() {
        return this.bf().getLastModified();
    }

    @Override
    public boolean exists() {
        return this.ep.exists();
    }

    @Override
    public boolean hasFeature(@Nonnull Class<? extends DriveFeature> type) {
        if (type == Mount.class || type == Permissions.class || type == MetaData.class) {
            return true;
        }
        if (type == com.inet.drive.api.feature.c.class) {
            return false;
        }
        try {
            return this.bg().hasFeature(type);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public DriveEntry resolve(String pathOrID) {
        com.inet.drive.server.linked.a a2 = new com.inet.drive.server.linked.a(this, this.getDescription(), this.dQ, this.cy, pathOrID);
        if (a2.exists()) {
            Mount mount = a2.getFeature(DriveEntry.MOUNT);
            if (mount != null && mount.isLinkRoot() && this.cv != null && this.cv.equals(mount.getLinkID())) {
                return this;
            }
            if (mount != null && this.cv != null && this.cv.equals(mount.getLinkID())) {
                LinkedList<Mount> linkedList = new LinkedList<Mount>();
                linkedList.add(mount);
                while (mount.getChild() != null) {
                    mount = mount.getChild();
                    linkedList.addFirst(mount);
                }
                while (linkedList.peek() != null) {
                    mount = (Mount)linkedList.poll();
                    if (this.cv == null || !this.cv.equals(mount.getLinkID())) continue;
                    return mount.getEntry();
                }
            }
            return a2;
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends DriveFeature> T getFeature(@Nonnull Class<T> type) {
        if (type == com.inet.drive.api.feature.c.class) {
            return null;
        }
        if (type == Mount.class) {
            return (T)new l(this, this.getDescription(), this.cy, this.cv, true);
        }
        if (type == Permissions.class) {
            PersistencePermissions persistencePermissions;
            com.inet.drive.server.persistence.c c2;
            if (this.eF == null && (c2 = this.bf()) != null && (persistencePermissions = (PersistencePermissions)c2.getFeature(Permissions.class)) != null) {
                persistencePermissions.setMountDriveEntry(this);
                this.eF = new c(this, persistencePermissions);
            }
            return (T)this.eF;
        }
        if (type == MetaData.class) {
            if (this.eE == null) {
                this.eE = new b(this);
            }
            return (T)this.eE;
        }
        DriveEntry driveEntry = this.bg();
        if (type == FOLDER) {
            Folder folder;
            DriveEntry driveEntry2 = this.bh();
            if (driveEntry2 != null && (folder = (Folder)driveEntry2.getFeature(FOLDER)) != null) {
                return (T)new com.inet.drive.server.linked.c(this, this.getDescription(), this, this.cy){

                    @Override
                    protected Folder G() {
                        return folder;
                    }
                };
            }
            return null;
        }
        if (type == THUMBNAIL) {
            Thumbnail thumbnail = (Thumbnail)driveEntry.getFeature(THUMBNAIL);
            if (thumbnail != null) {
                return (T)new d(thumbnail, this);
            }
            return null;
        }
        return driveEntry.getFeature(type);
    }

    @Override
    @Nullable
    public DriveEntry getParent() {
        return this.bf().getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(OperationProgressListener listener) throws DriveOperationConflictException {
        this.dQ.getPermissionChecker().hasPermission(this.getLinkID(), true, "EDITOR");
        String string = this.getName();
        String string2 = this.getMetaData(MetaData.PARENT_ID);
        DriveUtils.a a2 = DriveUtils.getOperation();
        try {
            DriveUtils.replaceOperation(DriveUtils.a.R);
            String string3 = this.getPath();
            int n2 = com.inet.drive.server.eventlog.a.d(this);
            this.bf().delete(listener);
            if (!(listener instanceof com.inet.drive.server.utils.c) && a2 == null) {
                com.inet.drive.server.eventlog.a.bz.a(this.cv, string3, n2, List.of(string3));
            }
        }
        finally {
            DriveUtils.replaceOperation(a2);
        }
        this.ep.deleteTree();
        MountManager.getInstance().removeMountsID(GUID.valueOf((String)this.eD), this.cv);
        this.dQ.notifyObservers(DriveObserver.EventType.REMOVED, new DriveObserver.EventType.RemoveEvent(this.getID(), string2, string));
    }

    @Override
    @Nonnull
    public String getExtensionName() {
        return "LINKED_ROOT";
    }

    public String getLinkID() {
        return this.cv;
    }

    static {
        eC = Duration.ofSeconds(5L);
    }

    private static class a {
        private final DriveEntry eK;
        private final long eL;

        a(@Nullable DriveEntry driveEntry, @Nonnull Duration duration) {
            this.eK = driveEntry;
            this.eL = System.currentTimeMillis() + duration.toMillis();
        }

        @Nullable
        DriveEntry bj() {
            return this.eK;
        }

        boolean isValid() {
            return System.currentTimeMillis() < this.eL;
        }
    }

    private class c
    implements Permissions {
        private GUID owner;
        private final i eN;
        private final Permissions bl;

        private c(i i3, Permissions permissions) {
            this.eN = i3;
            this.bl = permissions;
        }

        @Override
        public boolean hasPermission(@Nonnull String permissionType) {
            return this.bl.hasPermission(permissionType);
        }

        @Override
        public void addPermissions(@Nonnull GUID userOrGroupId, boolean isGroup, Permission ... permissions) {
            this.bk();
            this.bl.addPermissions(userOrGroupId, isGroup, permissions);
        }

        @Override
        public void removePermission(@Nonnull GUID userOrGroupId, boolean isGroup, String ... permissionTypes) {
            this.bk();
            this.bl.removePermission(userOrGroupId, isGroup, permissionTypes);
        }

        @Override
        public void setPermissions(boolean isGroup, @Nonnull Map<GUID, Map<String, Boolean>> permissions) {
            this.bk();
            this.bl.setPermissions(isGroup, permissions);
        }

        @Override
        public void clearPermission() {
            this.bk();
            this.bl.clearPermission();
        }

        private void bk() {
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount == null) {
                throw new AccessDeniedException("Only the owner can change the permission for a mount");
            }
            if (UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)userAccount.getID())) {
                return;
            }
            if (this.eN.getFeature(MetaData.class) == null) {
                throw new AccessDeniedException("Only the owner can change the permission for a mount");
            }
            if (this.owner == null) {
                this.owner = this.eN.getDescription().getUserID();
            }
            if (!userAccount.getID().equals((Object)this.owner)) {
                throw new AccessDeniedException("Only the owner can change the permission for a mount");
            }
        }

        @Override
        @Nonnull
        public Map<GUID, Map<String, Boolean>> getPermissions(boolean isGroup) {
            return this.bl.getPermissions(isGroup);
        }

        @Override
        @Nonnull
        public List<String> getAvailablePermissions() {
            return this.bl.getAvailablePermissions();
        }
    }

    private class b
    implements MetaData {
        private MetaData eM;
        private i eN;

        private MetaData D() {
            DriveEntry driveEntry = this.eN.bh();
            if (this.eM == null && driveEntry != null) {
                this.eM = driveEntry.getFeature(MetaData.class);
            }
            return this.eM;
        }

        private b(i i3) {
            this.eN = i3;
        }

        @Override
        public <T> void setMetaData(@Nonnull MetaKey<T> key, @Nullable T value) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
            if (ID.getKey().equals(key.getKey())) {
                throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangeid", new Object[]{this.getMetaData(ID), value}));
            }
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount == null) {
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(i.this.cv, DriveOperationConflictException.CONFLICT.writeProtected));
            }
            GUID gUID = (GUID)this.getMetaData(CREATOR_ID);
            if (!UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)userAccount.getID()) && !userAccount.getID().equals((Object)gUID)) {
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(i.this.cv, DriveOperationConflictException.CONFLICT.writeProtected));
            }
            if (e.es.contains(key)) {
                T t2;
                MetaData metaData = i.this.bf().getFeature(MetaData.class);
                if (metaData != null && !Objects.equals(value, t2 = metaData.getMetaData(key))) {
                    metaData.setMetaData(key, value);
                    i.this.dQ.notifyObservers(DriveObserver.EventType.MODIFIED, new DriveObserver.EventType.MetaDataChange(i.this.cv, key, t2, value));
                }
                return;
            }
            MetaData metaData = this.D();
            if (metaData != null) {
                if (metaData instanceof k) {
                    ((k)metaData).c(key, value);
                } else {
                    metaData.setMetaData(key, value);
                }
            }
        }

        @Override
        @Nullable
        public <T> T getMetaData(@Nonnull MetaKey<T> key) {
            if (key != MetaData.ID && key != MetaData.NAME && key != MetaData.CREATOR_ID && key != MetaData.PARENT_ID && key != MetaData.HOMEFOLDER && !com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(i.this.cv, false, Permissions.READ_ACCESS)) {
                throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied.mount", new Object[]{i.this.cv, Arrays.toString(Permissions.READ_ACCESS)}));
            }
            if (key == ID) {
                return (T)i.this.cv;
            }
            if (key == HOMEFOLDER) {
                DriveEntry driveEntry = i.this.getParent();
                if (driveEntry != null) {
                    return driveEntry.getMetaData(HOMEFOLDER);
                }
                return null;
            }
            if (key == LINK_SOURCEID) {
                return (T)i.this.et;
            }
            if (key == LINK_INDESCRIPTIONID) {
                return (T)i.this.cy;
            }
            if (key == MetaData.MOUNT_PROVIDER) {
                if ("PERSISTENCE_PROVIDER".equals(i.this.getDescription().getProvider())) {
                    return null;
                }
                MountProvider<?> mountProvider = MountManager.getProvider(i.this.getDescription().getProvider());
                if (mountProvider == null) {
                    return (T)DrivePlugin.MSG_SERVER.getMsg("drive.gui.mount.name.unknown." + i.this.getDescription().getProvider(), new Object[0]);
                }
                return (T)mountProvider.getDisplayName();
            }
            if (key == MetaData.LINK_DESTINATION_PATH) {
                DriveEntry driveEntry = i.this.bg();
                Object object = driveEntry.getPath();
                if (!"PERSISTENCE_PROVIDER".equals(i.this.getDescription().getProvider())) {
                    object = "/" + i.this.getDescription().getName() + (String)object;
                }
                return (T)object;
            }
            if (key == MetaData.MOUNT_CONNECTION_STATUS) {
                if ("PERSISTENCE_PROVIDER".equals(i.this.getDescription().getProvider())) {
                    return null;
                }
                try {
                    DriveEntry driveEntry = i.this.bi();
                    if (driveEntry == null) {
                        return (T)DrivePlugin.MSG_SERVER.getMsg("drive.mount.connection.noconnection", new Object[]{DrivePlugin.MSG_SERVER.getMsg("drive.entry.link.destinationNotFound", new Object[]{i.this.cy})});
                    }
                    if (driveEntry instanceof BrokenMountDriveEntry) {
                        throw ((BrokenMountDriveEntry)driveEntry).getTh();
                    }
                    Folder folder = driveEntry.getFeature(DriveEntry.FOLDER);
                    if (folder != null) {
                        folder.getChildren();
                    }
                }
                catch (Throwable throwable) {
                    return (T)DrivePlugin.MSG_SERVER.getMsg("drive.mount.connection.noconnection", new Object[]{throwable.getMessage()});
                }
                return (T)DrivePlugin.MSG_SERVER.getMsg("drive.mount.connection.connected", new Object[0]);
            }
            try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)i.this.getDescription().getUserID());){
                if (e.es.contains(key)) {
                    T t2 = i.this.bf().getMetaData(key);
                    return t2;
                }
                if (this.D() != null) {
                    T t3 = this.D().getMetaData(key);
                    return t3;
                }
            }
            return null;
        }
    }
}

