/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.mount.file;

import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.UploadListener;
import com.inet.error.ErrorCode;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.util.IOFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
implements Content {
    private File dk;
    private String id;

    public b(@Nonnull File file, @Nonnull String string) {
        this.dk = file;
        this.id = string;
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        if (!this.dk.isFile()) {
            return null;
        }
        try {
            return new FileInputStream(this.dk);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorCode.throwAny((Throwable)fileNotFoundException);
            return null;
        }
    }

    @Override
    public void setInputStream(@Nonnull InputStream in, @Nullable UploadListener listener) throws DriveOperationConflictException {
        try (FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.dk));){
            IOFunctions.copyData((InputStream)in, (OutputStream)fastBufferedOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw DriveOperationConflictException.createSingleConflictException(true, new DriveOperationConflictException.SingleEntryConflict(this.id, null, DriveOperationConflictException.CONFLICT.sourceNotFound));
        }
        catch (IOException iOException) {
            throw DriveOperationConflictException.createSingleConflictException(true, new DriveOperationConflictException.SingleEntryConflict(this.id, null, DriveOperationConflictException.CONFLICT.exception, "Error while writing: " + iOException.getMessage()));
        }
    }

    @Override
    @Nullable
    public OutputStream getOutputStream() throws DriveOperationConflictException {
        try {
            return new FileOutputStream(this.dk);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw DriveOperationConflictException.createSingleConflictException(true, new DriveOperationConflictException.SingleEntryConflict(this.id, null, DriveOperationConflictException.CONFLICT.sourceNotFound));
        }
    }

    @Override
    public long getSize() {
        return this.dk.length();
    }
}

