/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.metadata;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.feature.MetaKey;
import com.inet.http.servlet.ClientLocale;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DateTimeMetaKey
extends MetaKey<Long> {
    public DateTimeMetaKey(@Nonnull String key, boolean useInSearch, boolean displayInDetails, boolean appendForEachUIEntry) {
        super(key, useInSearch, displayInDetails, appendForEachUIEntry);
    }

    @Override
    @Nonnull
    public String getLabel() {
        return DrivePlugin.MSG_SERVER.getMsg("meta.key." + this.getKey(), new Object[0]);
    }

    @Override
    @Nonnull
    public String formatValue(@Nullable Long value) {
        if (value == null) {
            return "";
        }
        return DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale()).format(new Date(value));
    }

    @Override
    @Nullable
    public SearchTag getSearchTag() {
        if (!this.isUseInSearch() || this.searchTag != null) {
            return super.getSearchTag();
        }
        this.searchTag = new SearchTag(this.getKey(), SearchDataType.Date, false, 0, () -> this.getLabel());
        return this.searchTag;
    }
}

