/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.image.PreviewGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface DriveFileTypeHandler
extends NamedExtension {
    public boolean acceptFileTyp(@Nonnull DriveEntry var1);

    default public boolean acceptFileTyp(@Nonnull DriveEntry entry, @Nonnull FEATURE usecase) {
        return this.acceptFileTyp(entry);
    }

    @Nullable
    default public String getFileTypeName(@Nonnull DriveEntry entry) {
        return null;
    }

    @Nonnull
    public FileTypeDriveEntryHandler getFileTypeHandler(@Nonnull PersistenceEntry var1, @Nonnull DriveEntry var2);

    default public boolean thumbnailNeedCache(@Nonnull DriveEntry entry) {
        return true;
    }

    @Nullable
    public PreviewGenerator.ImagePreview getThumbnail(@Nonnull DriveEntry var1, @Nonnull Thumbnail.Size var2, boolean var3) throws IOException;

    @Nullable
    default public InputStream getAdhocThumbnail(@Nonnull DriveEntry entry, @Nonnull Thumbnail.Size size, boolean requireExactSize) {
        return null;
    }

    @Nullable
    public Object getFileSpecificDiff(@Nonnull DriveEntry var1, @Nonnull DriveEntry var2);

    @Nonnull
    default public List<MetaKey<?>> getAdditionalMetaKeyForFiletype() {
        return new ArrayList();
    }

    @Nonnull
    public static String getSuffix(@Nonnull DriveEntry entry) {
        return DriveFileTypeHandler.getSuffix(entry.getName());
    }

    @Nonnull
    public static String getSuffix(@Nonnull String name) {
        int n2 = name.lastIndexOf(46);
        if (n2 < 0) {
            return "";
        }
        return name.substring(n2 + 1).toLowerCase();
    }

    @InternalApi
    public static interface FileTypeDriveEntryHandler {
        @Nullable
        public String getTextForSearch();

        @Nullable
        public Map<MetaKey<?>, Object> getMetaData();
    }

    @InternalApi
    public static final class FEATURE
    extends Enum<FEATURE> {
        public static final /* enum */ FEATURE thumbnail = new FEATURE();
        public static final /* enum */ FEATURE metaData = new FEATURE();
        public static final /* enum */ FEATURE filetype = new FEATURE();
        private static final /* synthetic */ FEATURE[] l;

        public static FEATURE[] values() {
            return (FEATURE[])l.clone();
        }

        public static FEATURE valueOf(String name) {
            return Enum.valueOf(FEATURE.class, name);
        }

        private static /* synthetic */ FEATURE[] g() {
            return new FEATURE[]{thumbnail, metaData, filetype};
        }

        static {
            l = FEATURE.g();
        }
    }
}

