/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.PersistenceCloudEvent;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.permission.PermissionChecker;
import com.inet.persistence.PersistenceListener;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCommand;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface Drive
extends PersistenceListener<PersistenceCloudEvent> {
    @Nonnull
    public PermissionChecker getPermissionChecker();

    @Nonnull
    public static Drive getInstance() {
        return a.getInstance();
    }

    @Nullable
    public DriveEntry resolve(@Nullable String var1);

    @Nullable
    public DriveEntry resolve(@Nullable Path var1);

    @Nullable
    public DriveEntry move(@Nonnull DriveEntry var1, @Nonnull DriveEntry var2, @Nullable List<DriveOperationConflictException.SingleEntryConflict> var3, boolean var4, @Nullable OperationProgressListener var5) throws DriveOperationConflictException;

    @Nullable
    public List<DriveEntry> move(@Nonnull List<DriveEntry> var1, @Nonnull DriveEntry var2, @Nullable List<DriveOperationConflictException.SingleEntryConflict> var3, boolean var4, @Nullable OperationProgressListener var5) throws DriveOperationConflictException;

    @Nullable
    public DriveEntry copy(@Nonnull DriveEntry var1, @Nonnull DriveEntry var2, @Nullable List<DriveOperationConflictException.SingleEntryConflict> var3, boolean var4, @Nullable OperationProgressListener var5) throws DriveOperationConflictException;

    @Nullable
    public List<DriveEntry> copy(@Nonnull List<DriveEntry> var1, @Nonnull DriveEntry var2, @Nullable List<DriveOperationConflictException.SingleEntryConflict> var3, boolean var4, @Nullable OperationProgressListener var5) throws DriveOperationConflictException;

    @Nullable
    public DriveEntry createFolder(@Nonnull String var1, @Nonnull String var2) throws DriveOperationConflictException;

    @Nullable
    public DriveEntry createFile(@Nonnull String var1, @Nonnull DataEntry var2) throws DriveOperationConflictException;

    public void addObserver(@Nonnull DriveObserver var1);

    public void removeObserver(@Nonnull DriveObserver var1);

    @Nonnull
    public SearchResult<String> search(@Nonnull SearchCommand var1);

    @Nonnull
    public @Nonnull Map<@Nonnull ROOT_TYPES, @Nonnull List<@Nonnull DriveEntry>> getRoots();

    public <T> void notifyObservers(@Nonnull DriveObserver.EventType<T> var1, @Nonnull T var2);

    @Nullable
    default public DriveEntry createOrReplace(@Nonnull String path, @Nonnull InputStream input) throws DriveOperationConflictException {
        if (path.contains("//")) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(path, DriveOperationConflictException.CONFLICT.invalidPath));
        }
        DriveEntry driveEntry = this.resolve((String)(path.startsWith("/") ? path : "/" + path));
        if (driveEntry == null) {
            if (path.endsWith("/")) {
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(path, DriveOperationConflictException.CONFLICT.invalidName));
            }
            String string = path.contains("/") ? path.substring(0, path.lastIndexOf("/") + 1) : null;
            String string2 = path.contains("/") ? path.substring(path.lastIndexOf("/") + 1) : path;
            DataEntry dataEntry = new DataEntry(string2, input);
            String string3 = string == null ? "/" : "/" + string.toString().replace('\\', '/');
            return this.createFile(string3, dataEntry);
        }
        Content content = driveEntry.getFeature(Content.class);
        if (content == null) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.format));
        }
        content.setInputStream(input, null);
        return driveEntry;
    }

    @Nonnull
    default public DriveEntry createOrReplace(@Nonnull Path path, @Nonnull InputStream input) throws DriveOperationConflictException {
        DriveEntry driveEntry = this.resolve(path);
        if (driveEntry == null) {
            DataEntry dataEntry = new DataEntry(path.getFileName().toString(), input);
            Path path2 = path.getParent();
            String string = path2 == null ? "/" : "/" + path2.toString().replace('\\', '/');
            return this.createFile(string, dataEntry);
        }
        Content content = driveEntry.getFeature(Content.class);
        if (content == null) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.format));
        }
        content.setInputStream(input, null);
        return driveEntry;
    }

    public static abstract class a {
        private static Drive j;

        @Nonnull
        private static Drive getInstance() {
            if (j == null) {
                j = new com.inet.drive.server.a();
            }
            return j;
        }
    }

    @InternalApi
    public static final class ROOT_TYPES
    extends Enum<ROOT_TYPES> {
        public static final /* enum */ ROOT_TYPES DRIVE = new ROOT_TYPES();
        public static final /* enum */ ROOT_TYPES MOUNTS = new ROOT_TYPES();
        public static final /* enum */ ROOT_TYPES SHARED = new ROOT_TYPES();
        private static final /* synthetic */ ROOT_TYPES[] i;

        public static ROOT_TYPES[] values() {
            return (ROOT_TYPES[])i.clone();
        }

        public static ROOT_TYPES valueOf(String name) {
            return Enum.valueOf(ROOT_TYPES.class, name);
        }

        private static /* synthetic */ ROOT_TYPES[] e() {
            return new ROOT_TYPES[]{DRIVE, MOUNTS, SHARED};
        }

        static {
            i = ROOT_TYPES.e();
        }
    }
}

