/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.events;

import com.inet.annotations.JsonData;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.webgui.server.data.DriveGuiEntry;
import com.inet.drive.webgui.server.model.a;
import com.inet.drive.webgui.server.model.fields.b;
import com.inet.drive.webgui.server.utils.e;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ConflictEvent {
    private List<ConflictedEntry> conflicts;
    private String originalRequestKey;
    private Object originalRequestPayload;
    private boolean wasExecuted = true;
    private String sourceTaskID;
    private e.b renameMap;

    public ConflictEvent(@Nonnull String originalRequestKey, @Nonnull Object originalRequestPayload, String sourceTaskID) {
        this.originalRequestKey = originalRequestKey;
        this.originalRequestPayload = originalRequestPayload;
        this.sourceTaskID = sourceTaskID;
    }

    public void addConflicts(@Nonnull DriveOperationConflictException source, String name, long size, long lastModified, boolean isFolder) {
        this.wasExecuted |= source.isOperationExecuted();
        List<DriveOperationConflictException.SingleEntryConflict> list = source.getConflicts();
        if (!list.isEmpty()) {
            this.conflicts = new ArrayList<ConflictedEntry>();
            Drive drive = Drive.getInstance();
            for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : list) {
                if (singleEntryConflict.getConflict() == DriveOperationConflictException.CONFLICT.invalidName && name != null) {
                    this.addInvalidName(name, size, lastModified, isFolder);
                    continue;
                }
                DriveEntry driveEntry = singleEntryConflict.getExistingEntryID() != null ? drive.resolve(singleEntryConflict.getExistingEntryID()) : null;
                if (driveEntry == null || !driveEntry.exists()) continue;
                DriveGuiEntry driveGuiEntry = new a(driveEntry, false).dW();
                DriveEntry driveEntry2 = singleEntryConflict.getReplacementEntryID() != null ? drive.resolve(singleEntryConflict.getReplacementEntryID()) : null;
                DriveGuiEntry driveGuiEntry2 = null;
                if (driveEntry2 != null) {
                    driveGuiEntry2 = new a(driveEntry2, false).dW();
                } else if (singleEntryConflict.getConflict() == DriveOperationConflictException.CONFLICT.alreadyExists || singleEntryConflict.getConflict() == DriveOperationConflictException.CONFLICT.alreadyExistsFolder) {
                    driveGuiEntry2 = new DriveGuiEntry(name, null, new b().a(lastModified), isFolder ? DriveGuiEntry.a.iL : DriveGuiEntry.a.iJ, -1L, -1L);
                }
                this.conflicts.add(new ConflictedEntry(driveGuiEntry, driveGuiEntry2, singleEntryConflict.getConflict()));
            }
        }
    }

    public void addConflicts(@Nonnull DriveOperationConflictException source) {
        this.addConflicts(source, null, 0L, 0L, false);
    }

    public void addConflicts(ConflictEvent source) {
        if (source.hasConflicts()) {
            if (this.conflicts == null) {
                this.conflicts = new ArrayList<ConflictedEntry>();
            }
            this.conflicts.addAll(source.conflicts);
        }
        if (source.renameMap != null) {
            if (this.renameMap == null) {
                this.renameMap = new e.b();
            }
            this.renameMap.putAll(source.renameMap);
        }
    }

    public void addOverwriteConflict(@Nonnull a existing, long newSize, long newTime) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictedEntry>();
        }
        a a2 = new a(existing.getName(), newSize, newTime, newSize < 0L);
        this.conflicts.add(new ConflictedEntry(existing.dW(), a2.dW(), existing.getType() == DriveGuiEntry.a.iL ? DriveOperationConflictException.CONFLICT.alreadyExistsFolder : DriveOperationConflictException.CONFLICT.alreadyExists));
    }

    public void addOverwriteConflict(@Nonnull a existing, a replacement) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictedEntry>();
        }
        this.conflicts.add(new ConflictedEntry(existing.dW(), replacement.dW(), existing.getType() == DriveGuiEntry.a.iL ? DriveOperationConflictException.CONFLICT.alreadyExistsFolder : DriveOperationConflictException.CONFLICT.alreadyExists));
    }

    public void addWriteProtectionConflict(@Nonnull a existing, boolean hasViewerPermission) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictedEntry>();
        }
        if (!hasViewerPermission) {
            existing = new a(existing.getName(), -1L, -1L, existing.getType() != DriveGuiEntry.a.iJ);
        }
        this.conflicts.add(new ConflictedEntry(existing.dW(), null, hasViewerPermission ? DriveOperationConflictException.CONFLICT.writeProtected : DriveOperationConflictException.CONFLICT.protectedChild));
    }

    public void addTypeConflict(a existing) {
        DriveGuiEntry driveGuiEntry;
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictedEntry>();
        }
        driveGuiEntry.setType((driveGuiEntry = existing.dW()).getType() == DriveGuiEntry.a.iJ ? DriveGuiEntry.a.iL : DriveGuiEntry.a.iJ);
        this.conflicts.add(new ConflictedEntry(existing.dW(), driveGuiEntry, DriveOperationConflictException.CONFLICT.format));
    }

    public void addCannotReadConflict(@Nonnull a existing) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictedEntry>();
        }
        this.conflicts.add(new ConflictedEntry(null, existing.dW(), DriveOperationConflictException.CONFLICT.sourceNotFound));
    }

    public void addSkip(@Nonnull a existing) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictedEntry>();
        }
        ConflictedEntry conflictedEntry = new ConflictedEntry(null, existing.dW(), DriveOperationConflictException.CONFLICT.alreadyExists);
        this.conflicts.add(conflictedEntry);
    }

    public void addInvalidName(@Nonnull String name, long size, long lastModified, boolean isFolder) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictedEntry>();
        }
        ConflictedEntry conflictedEntry = new ConflictedEntry(new a(name, size, lastModified, isFolder).dW(), null, DriveOperationConflictException.CONFLICT.invalidName);
        this.conflicts.add(conflictedEntry);
    }

    public void setNotExecuted() {
        this.wasExecuted = false;
    }

    public boolean hasConflicts() {
        return this.conflicts != null && !this.conflicts.isEmpty();
    }

    @Nullable
    public List<ConflictedEntry> getConflicts() {
        return this.conflicts;
    }

    public void setRenameMap(@Nullable e.b renameMap) {
        this.renameMap = renameMap;
    }

    @JsonData
    public static class ConflictedEntry {
        private DriveGuiEntry existing;
        private DriveGuiEntry replacement;
        private DriveOperationConflictException.CONFLICT conflict;
        private DriveOperationConflictException.RESOLUTION[] resolutions;

        private ConflictedEntry(@Nullable DriveGuiEntry writeTarget, @Nullable DriveGuiEntry dataSource, @Nonnull DriveOperationConflictException.CONFLICT conflict) {
            this.existing = writeTarget;
            this.replacement = dataSource;
            this.conflict = conflict;
            this.resolutions = conflict.getDefaultResolutions();
        }

        @Nullable
        public DriveGuiEntry getExisting() {
            return this.existing;
        }

        @Nullable
        public DriveGuiEntry getReplacement() {
            return this.replacement;
        }

        @Nonnull
        public DriveOperationConflictException.CONFLICT getConflict() {
            return this.conflict;
        }
    }
}

